/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.Api.DataBase.LongType.LongType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import org.apache.commons.lang3.text.WordUtils;

public abstract class LongStackType<T extends LongType<T>>
implements IStackType<T> {
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    protected T stack;
    protected int hashCodeCache = 0;
    protected boolean NeedRecalHash = true;

    public abstract ResourceLocation getTypeID();

    @Override
    public ResourceLocation getTypeId() {
        return this.getTypeID();
    }

    @Override
    public T getStack() {
        return this.stack;
    }

    @Override
    public void setStack(T stack) {
        this.stack = ((LongType)stack).copy();
        this.NeedRecalHash = true;
    }

    @Override
    public Class<T> getStackClass() {
        return this.stack.getClass();
    }

    @Override
    public Class<?> getSourceClass() {
        return this.stack.getClass();
    }

    @Override
    public String getModId() {
        return "beyonddimensions";
    }

    @Override
    public boolean isEmpty() {
        return ((LongType)this.stack).isEmpty();
    }

    @Override
    public boolean isEmptyStack() {
        return ((LongType)this.stack).isEmpty();
    }

    @Override
    public T copyStack() {
        return (T)((LongType)this.stack).copy();
    }

    @Override
    public T copyStackWithCount(long count) {
        return (T)((LongType)this.stack).copyWithAmount(count);
    }

    @Override
    public long getStackAmount() {
        return ((LongType)this.stack).getStackCount();
    }

    @Override
    public void setStackAmount(long amount) {
        ((LongType)this.stack).setStackCount(amount);
    }

    @Override
    public void grow(long amount) {
        ((LongType)this.stack).grow(amount);
    }

    @Override
    public void shrink(long amount) {
        ((LongType)this.stack).shrink(amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public T splitStack(long amount) {
        if (amount <= 0L) {
            return (T)((LongType)this.stack).getEmpty();
        }
        int splitAmount = BDMath.clampLongToInt(Math.min(amount, ((LongType)this.stack).getStackCount()));
        LongType split = ((LongType)this.stack).copy();
        split.setStackCount(splitAmount);
        this.shrink(splitAmount);
        return (T)split;
    }

    @Override
    public boolean isSame(IStackType<?> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ((LongType)this.stack).isSame((LongType)other.getStack());
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<T> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return ((LongType)this.stack).isSame((LongType)other.getStack());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        IClientFluidTypeExtensions renderProperties;
        ResourceLocation fluidStill;
        Optional<TextureAtlasSprite> fluidStillSprite;
        if (((LongType)this.stack).isEmpty()) {
            return;
        }
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        FlowingFluid fluid = Fluids.f_76193_;
        if (!fluid.m_6212_(Fluids.f_76191_) && (fluidStillSprite = Optional.ofNullable(fluidStill = (renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid)).getStillTexture()).map(f -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(f)).filter(s -> s.m_247685_() != MissingTextureAtlasSprite.m_118071_())).isPresent()) {
            int fluidColor = -16711936;
            IngredientRenderer.drawTiledSprite(gui, 16, 16, fluidColor, 16L, fluidStillSprite.get(), x, y);
        }
        poseStack.m_85849_();
        String countText = this.getCountText(this.getStackAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.m_280168_();
        poseStackText.m_85836_();
        poseStackText.m_252880_(0.0f, 0.0f, 200.0f);
        poseStackText.m_85841_(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.m_91087_().f_91062_.m_92895_(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        if (!((LongType)this.stack).isEmpty()) {
            gui.m_280488_(Minecraft.m_91087_().f_91062_, countText, X, Y, 0xFFFFFF);
        }
        poseStackText.m_85849_();
    }

    @Override
    public String getCountText(long count) {
        if (count < 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public Component getDisplayName() {
        return ((LongType)this.stack).getName();
    }

    @Override
    public List<Component> getTooltipLines(@Nullable Player player, TooltipFlag tooltipFlag) {
        if (((LongType)this.stack).isEmpty()) {
            return List.of(Component.m_237119_());
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        Component displayName = this.getDisplayName();
        tooltips.add(displayName);
        MutableComponent modName = Component.m_237113_((String)WordUtils.capitalizeFully((String)"beyonddimensions".replace('_', ' '))).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC);
        tooltips.add((Component)modName);
        tooltips.add((Component)Component.m_237110_((String)"istack.beyonddimensions.storage_num.long_type", (Object[])new Object[]{this.getStackAmount()}));
        return tooltips;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        return Optional.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics gui, Font font, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        gui.renderTooltip(minecraft.f_91062_, this.getTooltipLines((Player)minecraft.f_91074_, (TooltipFlag)(minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)), this.getTooltipImage(), ItemStack.f_41583_, mouseX, mouseY);
    }

    public boolean equals(Object other) {
        if (other instanceof LongStackType) {
            LongStackType otherStack = (LongStackType)other;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        if (this.NeedRecalHash) {
            this.hashCodeCache = ((LongType)this.stack).hashCode();
            this.NeedRecalHash = false;
        }
        return this.hashCodeCache;
    }
}

