/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.ItemStackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackTypedHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Api.Util.CombinedItemHandlerWrapper;
import com.wintercogs.beyonddimensions.Block.Custom.NetFurnaceBlock;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.BaseMachineBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Item.Custom.MatterCompressionBall;
import com.wintercogs.beyonddimensions.Item.ModItems;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Machine.ReceiveMode;
import com.wintercogs.beyonddimensions.Menu.NetFurnaceMenu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class NetFurnaceBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    private static final int capacity = 9;
    private static final int filterCapacity = 8;
    private static final int fuelCapacity = 1;
    public PopMode popMode = PopMode.STOP;
    public ReceiveMode receiveMode = ReceiveMode.STOP;
    private List<RecipeManager.CachedCheck<Container, SmeltingRecipe>> quickChecks = new ArrayList<RecipeManager.CachedCheck>(Collections.nCopies(9, RecipeManager.m_220267_((RecipeType)RecipeType.f_44108_)));
    private List<Integer> litTime = new ArrayList<Integer>(Collections.nCopies(9, 0));
    private List<Integer> litDuration = new ArrayList<Integer>(Collections.nCopies(9, 0));
    private List<Integer> cookTime = new ArrayList<Integer>(Collections.nCopies(9, 0));
    private List<Integer> cookTimeTotal = new ArrayList<Integer>(Collections.nCopies(9, 0));
    private final StackTypedHandler inputFilterSlots = new StackTypedHandler(8){

        @Override
        public void onChange() {
            if (!NetFurnaceBlockEntity.this.f_58857_.m_5776_()) {
                NetFurnaceBlockEntity.this.f_58857_.m_151543_(NetFurnaceBlockEntity.this.f_58858_);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isStackValid(int slot, IStackType stack) {
            if (!(stack instanceof ItemStackType)) return false;
            ItemStackType itemInput = (ItemStackType)stack;
            if (!NetFurnaceBlockEntity.this.quickChecks.get(slot).m_213657_((Container)new SimpleContainer(new ItemStack[]{itemInput.copyStack()}), NetFurnaceBlockEntity.this.f_58857_).isPresent()) return false;
            return true;
        }
    };
    private final StackTypedHandler fuelFilterSlots = new StackTypedHandler(8){

        @Override
        public void onChange() {
            if (!NetFurnaceBlockEntity.this.f_58857_.m_5776_()) {
                NetFurnaceBlockEntity.this.f_58857_.m_151543_(NetFurnaceBlockEntity.this.f_58858_);
            }
        }

        @Override
        public boolean isStackValid(int slot, IStackType stack) {
            ItemStackType itemFuel;
            FluidStackType fluidStack;
            return stack instanceof EnergyStackType || stack instanceof FluidStackType && (fluidStack = (FluidStackType)stack).copyStack().getFluid() == Fluids.f_76195_ || stack instanceof ItemStackType && ForgeHooks.getBurnTime((ItemStack)(itemFuel = (ItemStackType)stack).getStack(), (RecipeType)RecipeType.f_44108_) > 0;
        }
    };
    private final StackTypedHandler inputStorageSlots = new StackTypedHandler(9){

        @Override
        public void onChange() {
            if (!NetFurnaceBlockEntity.this.f_58857_.m_5776_()) {
                NetFurnaceBlockEntity.this.f_58857_.m_151543_(NetFurnaceBlockEntity.this.f_58858_);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isStackValid(int slot, IStackType stack) {
            if (!(stack instanceof ItemStackType)) return false;
            ItemStackType itemInput = (ItemStackType)stack;
            if (!NetFurnaceBlockEntity.this.quickChecks.get(slot).m_213657_((Container)new SimpleContainer(new ItemStack[]{itemInput.copyStack()}), NetFurnaceBlockEntity.this.f_58857_).isPresent()) return false;
            return true;
        }
    };
    private final StackTypedHandler outputStorageSlots = new StackTypedHandler(9){

        @Override
        public void onChange() {
            if (!NetFurnaceBlockEntity.this.f_58857_.m_5776_()) {
                NetFurnaceBlockEntity.this.f_58857_.m_151543_(NetFurnaceBlockEntity.this.f_58858_);
            }
        }
    };
    private final StackTypedHandler fuelStorageSlots = new StackTypedHandler(1){

        @Override
        public void onChange() {
            if (!NetFurnaceBlockEntity.this.f_58857_.m_5776_()) {
                NetFurnaceBlockEntity.this.f_58857_.m_151543_(NetFurnaceBlockEntity.this.f_58858_);
            }
        }

        @Override
        public boolean isStackValid(int slot, IStackType stack) {
            ItemStackType itemFuel;
            FluidStackType fluidStack;
            return stack instanceof EnergyStackType || stack instanceof FluidStackType && (fluidStack = (FluidStackType)stack).copyStack().getFluid() == Fluids.f_76195_ || stack instanceof ItemStackType && ForgeHooks.getBurnTime((ItemStack)(itemFuel = (ItemStackType)stack).getStack(), (RecipeType)RecipeType.f_44108_) > 0;
        }
    };
    private final StackTypedHandler fuelReturnSlots = new StackTypedHandler(1){

        @Override
        public void onChange() {
            if (!NetFurnaceBlockEntity.this.f_58857_.m_5776_()) {
                NetFurnaceBlockEntity.this.f_58857_.m_151543_(NetFurnaceBlockEntity.this.f_58858_);
            }
        }
    };

    public int getCapacity() {
        return 9;
    }

    public int getFilterCapacity() {
        return 8;
    }

    public int getFuelCapacity() {
        return 1;
    }

    public List<Integer> getLitTime() {
        return this.litTime;
    }

    public void setLitTime(List<Integer> litTime) {
        this.litTime = litTime;
    }

    public List<Integer> getLitDuration() {
        return this.litDuration;
    }

    public void setLitDuration(List<Integer> litDuration) {
        this.litDuration = litDuration;
    }

    public List<Integer> getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(List<Integer> cookTime) {
        this.cookTime = cookTime;
    }

    public List<Integer> getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    public void setCookTimeTotal(List<Integer> cookTimeTotal) {
        this.cookTimeTotal = cookTimeTotal;
    }

    public StackTypedHandler getInputFilterSlots() {
        return this.inputFilterSlots;
    }

    public StackTypedHandler getFuelFilterSlots() {
        return this.fuelFilterSlots;
    }

    public StackTypedHandler getInputStorageSlots() {
        return this.inputStorageSlots;
    }

    public StackTypedHandler getOutputStorageSlots() {
        return this.outputStorageSlots;
    }

    public StackTypedHandler getFuelStorageSlots() {
        return this.fuelStorageSlots;
    }

    public StackTypedHandler getFuelReturnSlots() {
        return this.fuelReturnSlots;
    }

    public NetFurnaceBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_FURNACE_BLOCK_ENTITY.get(), pos, blockState);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap != ForgeCapabilities.ITEM_HANDLER) {
            return super.getCapability(cap, side);
        }
        ItemStackTypedHandler inputStorage = new ItemStackTypedHandler(this.inputStorageSlots){

            @Override
            public ItemStack extractItem(int slot, int count, boolean sim) {
                return ItemStack.f_41583_;
            }
        };
        ItemStackTypedHandler fuelStorage = new ItemStackTypedHandler(this.fuelStorageSlots){

            @Override
            public ItemStack extractItem(int slot, int count, boolean sim) {
                return ItemStack.f_41583_;
            }
        };
        ItemStackTypedHandler outputStorage = new ItemStackTypedHandler(this.outputStorageSlots){

            @Override
            public ItemStack insertItem(int slot, ItemStack itemStack, boolean sim) {
                return itemStack;
            }
        };
        ItemStackTypedHandler fuelReturn = new ItemStackTypedHandler(this.fuelReturnSlots){

            @Override
            public ItemStack insertItem(int slot, ItemStack itemStack, boolean sim) {
                return itemStack;
            }
        };
        CombinedItemHandlerWrapper finalHandler = new CombinedItemHandlerWrapper(inputStorage, fuelStorage, outputStorage, fuelReturn);
        return LazyOptional.of(() -> finalHandler).cast();
    }

    @Override
    public int getTicksPerWork() {
        return 1;
    }

    @Override
    public boolean shouldWork() {
        this.litTime.replaceAll(i -> Math.max(0, i - 1));
        if (this.litTime.stream().allMatch(t -> t <= 0)) {
            this.setLit(false);
        } else {
            this.setLit(true);
        }
        this.f_58857_.m_151543_(this.f_58858_);
        return super.shouldWork() && (!this.inputStorageSlots.isEmpty() || !this.inputFilterSlots.isEmpty() || !this.outputStorageSlots.isEmpty() || !this.fuelReturnSlots.isEmpty() || !this.fuelStorageSlots.isEmpty() || !this.fuelFilterSlots.isEmpty());
    }

    @Override
    public void workStart() {
        super.workStart();
        if (this.getNet() != null) {
            UnifiedStorage storage = this.getNet().getUnifiedStorage();
            block0: for (int inputSlot = 0; inputSlot < 9; ++inputSlot) {
                if (!this.inputStorageSlots.getStackBySlot(inputSlot).isEmpty()) continue;
                for (IStackType filterStack : this.inputFilterSlots.getStorage()) {
                    IStackType extracted;
                    IStackType remaining;
                    ItemStackType filterItem;
                    if (!this.inputStorageSlots.getStackBySlot(inputSlot).isEmpty()) continue block0;
                    if (!(filterStack instanceof ItemStackType) || (filterItem = (ItemStackType)filterStack).isEmpty() || (remaining = this.inputStorageSlots.insert(inputSlot, extracted = storage.extract(filterItem.copyWithCount(filterItem.getVanillaMaxStackSize()), false), false)).isEmpty()) continue;
                    storage.insert(remaining, false);
                }
            }
            block2: for (int fuelSlot = 0; fuelSlot < 1; ++fuelSlot) {
                if (!this.fuelStorageSlots.getStackBySlot(fuelSlot).isEmpty()) continue;
                for (IStackType filterStack : this.fuelFilterSlots.getStorage()) {
                    if (filterStack.isEmpty()) continue;
                    if (!this.fuelStorageSlots.getStackBySlot(fuelSlot).isEmpty()) continue block2;
                    IStackType extracted = storage.extract(filterStack.copyWithCount(filterStack.getVanillaMaxStackSize()), false);
                    IStackType remaining = this.fuelStorageSlots.insert(fuelSlot, extracted, false);
                    if (remaining.isEmpty()) continue;
                    storage.insert(remaining, false);
                }
            }
        }
        for (int litSlot = 0; litSlot < 9; ++litSlot) {
            if (this.litTime.get(litSlot) > 0 || this.inputStorageSlots.getStackBySlot(litSlot).isEmpty()) continue;
            for (IStackType fuelStack : this.fuelStorageSlots.getStorage()) {
                ItemStackType fuelItem;
                FluidStackType fuelFluid;
                int burnTime;
                if (fuelStack.isEmpty()) continue;
                if (fuelStack instanceof EnergyStackType) {
                    EnergyStackType fuelEnergy = (EnergyStackType)fuelStack;
                    burnTime = (int)Math.min(fuelEnergy.getStackAmount(), 20000L);
                    if (burnTime <= 0) continue;
                    this.fuelStorageSlots.extract(fuelEnergy.copyWithCount(burnTime), false);
                    this.litTime.set(litSlot, burnTime);
                    this.litDuration.set(litSlot, burnTime);
                    continue;
                }
                if (fuelStack instanceof FluidStackType && (fuelFluid = (FluidStackType)fuelStack).copyStack().getFluid() == Fluids.f_76195_) {
                    int burnNum = (int)Math.min(fuelFluid.getStackAmount(), 1000L);
                    int burnTime2 = burnNum * 20;
                    if (burnTime2 <= 0) continue;
                    this.fuelStorageSlots.extract(fuelFluid.copyWithCount(burnNum), false);
                    this.litTime.set(litSlot, burnTime2);
                    this.litDuration.set(litSlot, burnTime2);
                    continue;
                }
                if (!(fuelStack instanceof ItemStackType) || (burnTime = ForgeHooks.getBurnTime((ItemStack)(fuelItem = (ItemStackType)fuelStack).getStack(), (RecipeType)RecipeType.f_44108_)) <= 0) continue;
                ItemStack returnItem = fuelItem.copyStack().getCraftingRemainingItem();
                if (returnItem.m_41619_()) {
                    this.fuelStorageSlots.extract(fuelItem.copyWithCount(1L), false);
                    this.litTime.set(litSlot, burnTime);
                    this.litDuration.set(litSlot, burnTime);
                    continue;
                }
                if (this.fuelReturnSlots.insert(new ItemStackType(returnItem), true).isEmpty()) {
                    this.fuelReturnSlots.insert(new ItemStackType(returnItem), false);
                    this.fuelStorageSlots.extract(fuelItem.copyWithCount(1L), false);
                    this.litTime.set(litSlot, burnTime);
                    this.litDuration.set(litSlot, burnTime);
                    continue;
                }
                this.litTime.set(litSlot, 0);
                this.litDuration.set(litSlot, 0);
            }
        }
    }

    @Override
    public void workContent() {
        super.workContent();
        for (int inputSlot = 0; inputSlot < 9; ++inputSlot) {
            ItemStackType inputItem;
            if (this.litTime.get(inputSlot) <= 0) continue;
            IStackType iStackType = this.inputStorageSlots.getStackBySlot(inputSlot);
            if (iStackType instanceof ItemStackType && !(inputItem = (ItemStackType)iStackType).isEmpty()) {
                SmeltingRecipe recipeHolder = this.quickChecks.get(inputSlot).m_213657_((Container)new SimpleContainer(new ItemStack[]{inputItem.getStack()}), this.f_58857_).orElse(null);
                if (recipeHolder != null) {
                    this.cookTimeTotal.set(inputSlot, recipeHolder.m_43753_());
                    if (this.cookTime.get(inputSlot) >= this.cookTimeTotal.get(inputSlot)) {
                        ItemStackType resultItem = new ItemStackType(recipeHolder.m_8043_(this.f_58857_.m_9598_()));
                        if (!this.outputStorageSlots.insert(inputSlot, resultItem, true).isEmpty()) continue;
                        this.outputStorageSlots.insert(inputSlot, resultItem, false);
                        this.inputStorageSlots.extract(inputSlot, 1L, false);
                        this.cookTime.set(inputSlot, 0);
                        this.cookTimeTotal.set(inputSlot, recipeHolder.m_43753_());
                        continue;
                    }
                    this.cookTime.set(inputSlot, this.cookTime.get(inputSlot) + 1);
                    continue;
                }
                this.cookTime.set(inputSlot, 0);
                this.cookTimeTotal.set(inputSlot, 0);
                continue;
            }
            this.cookTime.set(inputSlot, 0);
            this.cookTimeTotal.set(inputSlot, 0);
        }
    }

    @Override
    public void workEnd() {
        IStackType extracted;
        IStackType extracted2;
        super.workEnd();
        ArrayList<IItemHandler> otherStroages = new ArrayList<IItemHandler>();
        if (this.popMode == PopMode.OPEN) {
            for (Direction dir : Direction.values()) {
                LazyOptional otherStorage;
                BlockPos targetPos = this.m_58899_().m_121945_(dir);
                BlockEntity neighbor = this.f_58857_.m_7702_(targetPos);
                if (neighbor == null || neighbor instanceof NetedBlockEntity || !(otherStorage = neighbor.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_())).isPresent()) continue;
                IItemHandler otherHandler = (IItemHandler)otherStorage.resolve().get();
                if (otherStorage == null) continue;
                otherStroages.add(otherHandler);
            }
        }
        for (int outputSlot = 0; outputSlot < 9; ++outputSlot) {
            UnifiedStorage storage;
            IStackType remaining;
            IStackType outputStack = this.outputStorageSlots.getStackBySlot(outputSlot);
            if (outputStack == null || outputStack.isEmpty()) continue;
            for (IItemHandler otherStorage : otherStroages) {
                for (int otherSlot = 0; otherSlot < otherStorage.getSlots(); ++otherSlot) {
                    extracted2 = this.outputStorageSlots.extract(outputSlot, outputStack.getVanillaMaxStackSize(), false);
                    int remaining2 = otherStorage.insertItem(otherSlot, (ItemStack)extracted2.copyStack(), false).m_41613_();
                    if (remaining2 <= 0) continue;
                    this.outputStorageSlots.insert(outputSlot, extracted2.copyWithCount(remaining2), false);
                }
            }
            if (this.receiveMode != ReceiveMode.OPEN || this.getNet() == null || (remaining = (storage = this.getNet().getUnifiedStorage()).insert(outputSlot, extracted = this.outputStorageSlots.extract(outputSlot, outputStack.getStackAmount(), false), false)).isEmpty()) continue;
            this.outputStorageSlots.insert(outputSlot, remaining, false);
        }
        for (int returnSlot = 0; returnSlot < 1; ++returnSlot) {
            IStackType remaining;
            IStackType returnStack = this.fuelReturnSlots.getStackBySlot(returnSlot);
            if (returnStack == null || returnStack.isEmpty()) continue;
            Object storage = otherStroages.iterator();
            while (storage.hasNext()) {
                IItemHandler otherStorage;
                otherStorage = (IItemHandler)storage.next();
                for (int otherSlot = 0; otherSlot < otherStorage.getSlots(); ++otherSlot) {
                    extracted2 = this.fuelReturnSlots.extract(returnSlot, returnStack.getVanillaMaxStackSize(), false);
                    int remaining3 = otherStorage.insertItem(otherSlot, (ItemStack)extracted2.copyStack(), false).m_41613_();
                    if (remaining3 <= 0) continue;
                    this.fuelReturnSlots.insert(returnSlot, extracted2.copyWithCount(remaining3), false);
                }
            }
            if (this.receiveMode != ReceiveMode.OPEN || this.getNet() == null || (remaining = ((UnifiedStorage)(storage = this.getNet().getUnifiedStorage())).insert(returnSlot, extracted = this.fuelReturnSlots.extract(returnSlot, returnStack.getStackAmount(), false), false)).isEmpty()) continue;
            this.fuelReturnSlots.insert(returnSlot, remaining, false);
        }
        for (int fuelSlot = 0; fuelSlot < 1; ++fuelSlot) {
            UnifiedStorage storage;
            IStackType remaining;
            IStackType fuelStack = this.fuelStorageSlots.getStackBySlot(fuelSlot);
            if (fuelStack == null || fuelStack.isEmpty() || !(fuelStack instanceof EnergyStackType) && !(fuelStack instanceof FluidStackType) || this.receiveMode != ReceiveMode.OPEN || this.getNet() == null || this.fuelFilterSlots.hasStackType(fuelStack) || (remaining = (storage = this.getNet().getUnifiedStorage()).insert(fuelSlot, extracted = this.fuelStorageSlots.extract(fuelSlot, fuelStack.getStackAmount(), false), false)).isEmpty()) continue;
            this.fuelStorageSlots.insert(fuelSlot, remaining, false);
        }
    }

    public void dropContent() {
        ItemStackType itemStackType;
        ArrayList<IStackType> dropList = new ArrayList<IStackType>();
        for (IStackType stack : this.inputStorageSlots.getStorage()) {
            if (stack.isEmpty()) continue;
            if (stack instanceof ItemStackType) {
                itemStackType = (ItemStackType)stack;
                if (itemStackType.getStack().m_41720_() instanceof MatterCompressionBall) {
                    Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)itemStackType.copyStack());
                    continue;
                }
                dropList.add(stack.copy());
                continue;
            }
            dropList.add(stack.copy());
        }
        for (IStackType stack : this.outputStorageSlots.getStorage()) {
            if (stack.isEmpty()) continue;
            if (stack instanceof ItemStackType) {
                itemStackType = (ItemStackType)stack;
                if (itemStackType.getStack().m_41720_() instanceof MatterCompressionBall) {
                    Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)itemStackType.copyStack());
                    continue;
                }
                dropList.add(stack.copy());
                continue;
            }
            dropList.add(stack.copy());
        }
        for (IStackType stack : this.fuelStorageSlots.getStorage()) {
            if (stack.isEmpty()) continue;
            if (stack instanceof ItemStackType) {
                itemStackType = (ItemStackType)stack;
                if (itemStackType.getStack().m_41720_() instanceof MatterCompressionBall) {
                    Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)itemStackType.copyStack());
                    continue;
                }
                dropList.add(stack.copy());
                continue;
            }
            dropList.add(stack.copy());
        }
        for (IStackType stack : this.fuelReturnSlots.getStorage()) {
            if (stack.isEmpty()) continue;
            if (stack instanceof ItemStackType) {
                itemStackType = (ItemStackType)stack;
                if (itemStackType.getStack().m_41720_() instanceof MatterCompressionBall) {
                    Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)itemStackType.copyStack());
                    continue;
                }
                dropList.add(stack.copy());
                continue;
            }
            dropList.add(stack.copy());
        }
        ItemStack ball = new ItemStack((ItemLike)ModItems.MATTER_COMPRESS_BALL.get(), 1);
        if (!dropList.isEmpty()) {
            MatterCompressionBall.setIStackList(ball, dropList);
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)ball);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputFilterSlots.deserializeNBT(tag.m_128469_("input_filter_slots"));
        this.fuelFilterSlots.deserializeNBT(tag.m_128469_("fuel_filter_slots"));
        this.inputStorageSlots.deserializeNBT(tag.m_128469_("input_storage_slots"));
        this.outputStorageSlots.deserializeNBT(tag.m_128469_("output_storage_slots"));
        this.fuelStorageSlots.deserializeNBT(tag.m_128469_("fuel_storage_slots"));
        this.fuelReturnSlots.deserializeNBT(tag.m_128469_("fuel_return_slots"));
        this.litTime = Arrays.stream(tag.m_128465_("lit_time")).boxed().collect(Collectors.toList());
        this.litDuration = Arrays.stream(tag.m_128465_("lit_duration")).boxed().collect(Collectors.toList());
        this.cookTime = Arrays.stream(tag.m_128465_("cook_time")).boxed().collect(Collectors.toList());
        this.cookTimeTotal = Arrays.stream(tag.m_128465_("cook_time_total")).boxed().collect(Collectors.toList());
        this.popMode = PopMode.valueOf(tag.m_128461_("pop_mode"));
        this.receiveMode = ReceiveMode.valueOf(tag.m_128461_("receive_mode"));
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("input_filter_slots", (Tag)this.inputFilterSlots.serializeNBT());
        tag.m_128365_("fuel_filter_slots", (Tag)this.fuelFilterSlots.serializeNBT());
        tag.m_128365_("input_storage_slots", (Tag)this.inputStorageSlots.serializeNBT());
        tag.m_128365_("output_storage_slots", (Tag)this.outputStorageSlots.serializeNBT());
        tag.m_128365_("fuel_storage_slots", (Tag)this.fuelStorageSlots.serializeNBT());
        tag.m_128365_("fuel_return_slots", (Tag)this.fuelReturnSlots.serializeNBT());
        tag.m_128408_("lit_time", this.litTime);
        tag.m_128408_("lit_duration", this.litDuration);
        tag.m_128408_("cook_time", this.cookTime);
        tag.m_128408_("cook_time_total", this.cookTimeTotal);
        tag.m_128359_("pop_mode", this.popMode.name());
        tag.m_128359_("receive_mode", this.receiveMode.name());
    }

    public void setLit(boolean lit) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        BlockState state = this.m_58900_();
        if ((Boolean)state.m_61143_((Property)NetFurnaceBlock.LIT) != lit) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)NetFurnaceBlock.LIT, (Comparable)Boolean.valueOf(lit)), 2);
            NetFurnaceBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)state);
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"menu.title.beyonddimensions.furnace_menu");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new NetFurnaceMenu(containerId, inventory, this);
    }
}

