/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class NetedItem
extends Item {
    public NetedItem(Item.Properties properties) {
        super(properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.m_21120_(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND || !player.m_6144_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (level.m_5776_()) return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
        if (net == null) return InteractionResultHolder.m_19100_((Object)itemstack);
        if (this.validToReWrite(net, player)) {
            CompoundTag tag = itemstack.m_41784_();
            if (NetedItem.getNetId(itemstack) != net.getId()) {
                tag.m_128405_("NetId", net.getId());
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 0.8f, 1.0f);
                player.m_213846_((Component)Component.m_237110_((String)"msg.beyonddimensions.item_net_bound", (Object[])new Object[]{net.getId()}));
                return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
            } else {
                tag.m_128405_("NetId", -1);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 0.8f, 1.0f);
                player.m_213846_((Component)Component.m_237110_((String)"msg.beyonddimensions.item_net_unbound", (Object[])new Object[]{net.getId()}));
            }
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"msg.beyonddimensions.no_right_to_bound_item"));
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
    }

    public static DimensionsNet getNet(ItemStack stack, MinecraftServer dataProvider) {
        int netId = NetedItem.getNetId(stack);
        if (netId >= 0) {
            return DimensionsNet.getNetFromId(netId, dataProvider);
        }
        return null;
    }

    public static int getNetId(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("NetId")) {
            return stack.m_41783_().m_128451_("NetId");
        }
        return -1;
    }

    public static void setNetId(ItemStack stack, int netId) {
        stack.m_41784_().m_128405_("NetId", netId);
    }

    protected boolean validToReWrite(DimensionsNet net, Player player) {
        return net.isManager(player);
    }
}

