/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Stack.Chemicals;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.providers.IPigmentProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.text.WordUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PigmentStackType
implements IStackType<PigmentStack> {
    public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"beyonddimensions", (String)"stack_type/chemicals/pigment");
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    private PigmentStack stack;

    public PigmentStackType() {
        this.stack = PigmentStack.EMPTY;
    }

    public PigmentStackType(PigmentStack stack) {
        this.stack = stack;
    }

    @Override
    public IStackType<PigmentStack> fromObject(Object key, long amount, CompoundTag dataComponentPatch) {
        if (key instanceof Pigment) {
            Pigment chemical = (Pigment)key;
            PigmentStack chemicalStack = new PigmentStack((IPigmentProvider)chemical, amount);
            return new PigmentStackType(chemicalStack);
        }
        return null;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public IStackType<PigmentStack> getEmpty() {
        return new PigmentStackType();
    }

    @Override
    public PigmentStack getStack() {
        return this.stack;
    }

    @Override
    public void setStack(PigmentStack stack) {
        this.stack = stack.copy();
    }

    @Override
    public Class<PigmentStack> getStackClass() {
        return PigmentStack.class;
    }

    @Override
    public Class<?> getSourceClass() {
        return Pigment.class;
    }

    @Override
    public Object getSource() {
        return PigmentStack.EMPTY.getType();
    }

    @Override
    public String getModId() {
        ResourceLocation key = MekanismAPI.pigmentRegistry().getKey((Object)((Pigment)this.stack.getRaw()));
        return key != null ? key.m_135827_() : "unknown";
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public boolean isEmptyStack() {
        return this.stack.isEmpty();
    }

    @Override
    public PigmentStack getEmptyStack() {
        return PigmentStack.EMPTY;
    }

    @Override
    public PigmentStack copyStack() {
        return this.stack.copy();
    }

    @Override
    public PigmentStack copyStackWithCount(long count) {
        return new PigmentStack(this.stack, count);
    }

    @Override
    public IStackType<PigmentStack> copy() {
        return new PigmentStackType(this.stack.copy());
    }

    @Override
    public IStackType<PigmentStack> copyWithCount(long count) {
        return new PigmentStackType(new PigmentStack(this.stack, count));
    }

    @Override
    public long getStackAmount() {
        return this.stack.getAmount();
    }

    @Override
    public void setStackAmount(long amount) {
        if (((Pigment)this.stack.getRaw()).isEmptyType()) {
            return;
        }
        this.stack.setAmount(amount);
    }

    @Override
    public void grow(long amount) {
        this.setStackAmount(this.getStackAmount() + amount);
    }

    @Override
    public void shrink(long amount) {
        this.grow(-amount);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return 64000L;
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public PigmentStack splitStack(long amount) {
        if (amount <= 0L || this.isEmpty()) {
            return PigmentStack.EMPTY;
        }
        long splitAmount = Math.min(amount, this.stack.getAmount());
        PigmentStack split = this.stack.copy();
        split.setAmount(splitAmount);
        this.stack.shrink(splitAmount);
        return split;
    }

    @Override
    public IStackType<PigmentStack> split(long amount) {
        if (amount <= 0L || this.isEmpty()) {
            return new PigmentStackType();
        }
        long splitAmount = Math.min(amount, this.stack.getAmount());
        PigmentStack split = this.stack.copy();
        split.setAmount(splitAmount);
        this.stack.shrink(splitAmount);
        return new PigmentStackType(split);
    }

    @Override
    public boolean isSame(IStackType<PigmentStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return this.stack.isTypeEqual((ChemicalStack)other.getStack());
    }

    @Override
    public boolean isSameTypeSameComponents(IStackType<PigmentStack> other) {
        if (!other.getTypeId().equals((Object)this.getTypeId())) {
            return false;
        }
        return this.stack.isTypeEqual((ChemicalStack)other.getStack());
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130085_(this.getTypeId());
        boolean hasItem = !this.stack.isEmpty();
        buf.writeBoolean(hasItem);
        if (hasItem) {
            buf.m_130103_(this.stack.getAmount());
            PigmentStack copy = new PigmentStack(this.stack, 1L);
            copy.writeToPacket(buf);
        }
    }

    @Override
    public IStackType<PigmentStack> deserialize(FriendlyByteBuf buf, ResourceLocation typeId) {
        if (!typeId.equals((Object)this.getTypeId())) {
            return null;
        }
        boolean hasItem = buf.readBoolean();
        if (!hasItem) {
            return new PigmentStackType(PigmentStack.EMPTY);
        }
        long count = buf.m_130258_();
        PigmentStack stack = new PigmentStack(PigmentStack.readFromPacket((FriendlyByteBuf)buf), count);
        return new PigmentStackType(stack);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("Amount", this.getStackAmount());
        tag.m_128365_("Stack", (Tag)new PigmentStack(this.stack, 1L).write(new CompoundTag()));
        return tag;
    }

    @Override
    public IStackType<PigmentStack> deserializeNBT(CompoundTag nbt) {
        PigmentStackType stack = new PigmentStackType(PigmentStack.readFromNBT((CompoundTag)nbt.m_128469_("Stack")));
        stack.setStackAmount(nbt.m_128454_("Amount"));
        return stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gui, int x, int y) {
        ResourceLocation fluidStill;
        Optional<TextureAtlasSprite> fluidStillSprite;
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        Pigment chemical = (Pigment)this.stack.getType();
        if (!chemical.isEmptyType() && (fluidStillSprite = Optional.ofNullable(fluidStill = chemical.getIcon()).map(f -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(f)).filter(s -> s.m_247685_() != MissingTextureAtlasSprite.m_118071_())).isPresent()) {
            int fluidColor = chemical.getTint();
            IngredientRenderer.drawTiledSprite(gui, 16, 16, fluidColor, 16L, fluidStillSprite.get(), x, y);
        }
        poseStack.m_85849_();
        String countText = this.getCountText(this.stack.getAmount());
        float scale = 0.666f;
        PoseStack poseStackText = gui.m_280168_();
        poseStackText.m_85836_();
        poseStackText.m_252880_(0.0f, 0.0f, 200.0f);
        poseStackText.m_85841_(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.m_91087_().f_91062_.m_92895_(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        gui.m_280488_(Minecraft.m_91087_().f_91062_, countText, X, Y, 0xFFFFFF);
        poseStackText.m_85849_();
    }

    @Override
    public String getCountText(long count) {
        if (count <= 0L) {
            return "";
        }
        return StringFormat.formatBucket(count);
    }

    @Override
    public Component getDisplayName() {
        return this.stack.getTextComponent();
    }

    @Override
    public List<Component> getTooltipLines(@Nullable Player player, TooltipFlag tooltipFlag) {
        if (this.stack.isEmpty()) {
            return List.of(Component.m_237119_());
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        Pigment chemical = (Pigment)this.stack.getType();
        Component displayName = this.getDisplayName();
        tooltips.add(displayName);
        ResourceLocation resourceLocation = chemical.getRegistryName();
        if (resourceLocation != null) {
            Optional container;
            if (tooltipFlag.m_7050_()) {
                MutableComponent advancedId = Component.m_237113_((String)resourceLocation.toString()).m_130940_(ChatFormatting.DARK_GRAY);
                tooltips.add((Component)advancedId);
            }
            MutableComponent modName = (container = ModList.get().getModContainerById(resourceLocation.m_135827_())).isPresent() ? Component.m_237113_((String)((ModContainer)container.get()).getModInfo().getDisplayName()).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC) : ((container = ModList.get().getModContainerById(resourceLocation.m_135827_().replace('_', '-'))).isPresent() ? Component.m_237113_((String)((ModContainer)container.get()).getModInfo().getDisplayName()).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC) : Component.m_237113_((String)WordUtils.capitalizeFully((String)resourceLocation.m_135827_().replace('_', ' '))).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC));
            tooltips.add((Component)modName);
        }
        tooltips.add((Component)Component.m_237110_((String)"istack.beyonddimensions.storage_num.fluid", (Object[])new Object[]{this.getStackAmount()}));
        return tooltips;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage() {
        return Optional.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics gui, Font font, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        gui.renderTooltip(minecraft.f_91062_, this.getTooltipLines((Player)minecraft.f_91074_, (TooltipFlag)(minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)), this.getTooltipImage(), ItemStack.f_41583_, mouseX, mouseY);
    }

    public boolean equals(Object other) {
        if (other instanceof PigmentStackType) {
            PigmentStackType otherStack = (PigmentStackType)other;
            return this.isSameTypeSameComponents(otherStack);
        }
        return false;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + ((Pigment)this.stack.getType()).hashCode();
        return code;
    }
}

