/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Stack;

import com.wintercogs.beyonddimensions.Registry.StackTypeRegistry;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IStackType<T> {
    public IStackType<T> fromObject(Object var1, long var2, CompoundTag var4);

    public ResourceLocation getTypeId();

    public IStackType<T> getEmpty();

    public T getStack();

    public void setStack(T var1);

    public Class<T> getStackClass();

    public Class<?> getSourceClass();

    public Object getSource();

    public String getModId();

    public boolean isEmpty();

    public boolean isEmptyStack();

    public T getEmptyStack();

    public T copyStack();

    public T copyStackWithCount(long var1);

    public IStackType<T> copy();

    public IStackType<T> copyWithCount(long var1);

    public long getStackAmount();

    public void setStackAmount(long var1);

    public void grow(long var1);

    public void shrink(long var1);

    public long getVanillaMaxStackSize();

    public long getCustomMaxStackSize();

    public T splitStack(long var1);

    public IStackType<T> split(long var1);

    public boolean isSame(IStackType<T> var1);

    public boolean isSameTypeSameComponents(IStackType<T> var1);

    public void serialize(FriendlyByteBuf var1);

    public IStackType<T> deserialize(FriendlyByteBuf var1, ResourceLocation var2);

    public static IStackType deserializeCommon(FriendlyByteBuf buf) {
        ResourceLocation typeId = buf.m_130281_();
        for (IStackType<?> stacktype : StackTypeRegistry.getAllTypes()) {
            IStackType<?> stack = stacktype.deserialize(buf, typeId);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    public CompoundTag serializeNBT();

    public IStackType<T> deserializeNBT(CompoundTag var1);

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics var1, int var2, int var3);

    public String getCountText(long var1);

    public Component getDisplayName();

    public List<Component> getTooltipLines(@Nullable Player var1, TooltipFlag var2);

    public Optional<TooltipComponent> getTooltipImage();

    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics var1, Font var2, int var3, int var4);
}

