/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.Chemicals;

import com.wintercogs.beyonddimensions.DataBase.Stack.Chemicals.SlurryStackType;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.resources.ResourceLocation;

public class SlurryHandlerWrapper
implements IStackHandlerWrapper<SlurryStack> {
    private final ISlurryHandler chemicalHandler;

    public SlurryHandlerWrapper(Object chemicalHandler) {
        this.chemicalHandler = (ISlurryHandler)chemicalHandler;
    }

    @Override
    public ResourceLocation getTypeId() {
        return SlurryStackType.ID;
    }

    @Override
    public int getSlots() {
        return this.chemicalHandler.getTanks();
    }

    @Override
    public SlurryStack getStackInSlot(int slot) {
        return (SlurryStack)this.chemicalHandler.getChemicalInTank(slot);
    }

    @Override
    public long getCapacity(int slot) {
        return this.chemicalHandler.getTankCapacity(slot);
    }

    @Override
    public boolean isStackValid(int slot, SlurryStack stack) {
        return this.chemicalHandler.isValid(slot, (ChemicalStack)stack);
    }

    @Override
    public long insert(int slot, SlurryStack Stack, boolean sim) {
        if (sim) {
            return ((SlurryStack)this.chemicalHandler.insertChemical(slot, (ChemicalStack)Stack, Action.SIMULATE)).getAmount();
        }
        return ((SlurryStack)this.chemicalHandler.insertChemical(slot, (ChemicalStack)Stack, Action.EXECUTE)).getAmount();
    }

    @Override
    public long insert(SlurryStack stack, boolean sim) {
        if (sim) {
            return ((SlurryStack)this.chemicalHandler.insertChemical((ChemicalStack)stack, Action.SIMULATE)).getAmount();
        }
        return ((SlurryStack)this.chemicalHandler.insertChemical((ChemicalStack)stack, Action.EXECUTE)).getAmount();
    }

    @Override
    public long extract(int slot, long amount, boolean sim) {
        if (sim) {
            return ((SlurryStack)this.chemicalHandler.extractChemical(slot, amount, Action.SIMULATE)).getAmount();
        }
        return ((SlurryStack)this.chemicalHandler.extractChemical(slot, amount, Action.EXECUTE)).getAmount();
    }

    @Override
    public long extract(SlurryStack stack, boolean sim) {
        if (sim) {
            return ((SlurryStack)this.chemicalHandler.extractChemical((ChemicalStack)stack, Action.SIMULATE)).getAmount();
        }
        return ((SlurryStack)this.chemicalHandler.extractChemical((ChemicalStack)stack, Action.EXECUTE)).getAmount();
    }
}

