/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage.Chemicals;

import com.wintercogs.beyonddimensions.DataBase.Stack.Chemicals.SlurryStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import mekanism.api.Action;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;

public class SlurryUnifiedStorageHandler
implements ISlurryHandler {
    private UnifiedStorage storage;

    public SlurryUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getTanks() {
        return this.storage.getTypeIdIndexList(SlurryStackType.ID).map(list -> list.size() + 1).orElse(1);
    }

    public SlurryStack getChemicalInTank(int slot) {
        return this.storage.getTypeIdIndexList(SlurryStackType.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> (Integer)slots.get(slot)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (SlurryStackType)this.storage.getStackBySlot((int)actualIndex)).map(SlurryStackType::getStack).orElse(SlurryStack.EMPTY);
    }

    public void setChemicalInTank(int tank, SlurryStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        this.storage.insert(new SlurryStackType(stack.copy()), false);
    }

    public long getTankCapacity(int tank) {
        return Long.MAX_VALUE;
    }

    public boolean isValid(int tank, SlurryStack stack) {
        return true;
    }

    public SlurryStack insertChemical(int tank, SlurryStack stack, Action action) {
        if (stack.isEmpty()) {
            return SlurryStack.EMPTY;
        }
        long remaining = this.storage.insert(new SlurryStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new SlurryStack(stack, remaining);
        }
        return SlurryStack.EMPTY;
    }

    public SlurryStack extractChemical(int tank, long amount, Action action) {
        return ((SlurryStackType)this.storage.extract(new SlurryStackType(new SlurryStack(this.getChemicalInTank(tank), amount)), action.simulate())).copyStack();
    }

    public SlurryStack insertChemical(SlurryStack stack, Action action) {
        if (stack.isEmpty()) {
            return SlurryStack.EMPTY;
        }
        long remaining = this.storage.insert(new SlurryStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new SlurryStack(stack, remaining);
        }
        return SlurryStack.EMPTY;
    }

    public SlurryStack extractChemical(long amount, Action action) {
        return ((SlurryStackType)this.storage.extract(new SlurryStackType(new SlurryStack(this.getChemicalInTank(0), amount)), action.simulate())).copyStack();
    }

    public SlurryStack extractChemical(SlurryStack stack, Action action) {
        return ((SlurryStackType)this.storage.extract(new SlurryStackType(stack.copy()), action.simulate())).copyStack();
    }
}

