/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Network.Packet.ClientOrServer;

import com.wintercogs.beyonddimensions.Menu.NetEnergyMenu;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record PopModeButtonPacket(boolean popMode) {
    private void handleServer(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof NetInterfaceBaseMenu) {
            NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)abstractContainerMenu;
            menu.popMode = this.popMode();
            menu.be.popMode = this.popMode();
            return;
        }
        abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof NetEnergyMenu) {
            NetEnergyMenu menu = (NetEnergyMenu)abstractContainerMenu;
            menu.popMode = this.popMode();
            menu.be.popMode = this.popMode();
            return;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleClient(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof NetInterfaceBaseMenu) {
            NetInterfaceBaseMenu menu = (NetInterfaceBaseMenu)abstractContainerMenu;
            menu.popMode = this.popMode();
            return;
        }
        abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof NetEnergyMenu) {
            NetEnergyMenu menu = (NetEnergyMenu)abstractContainerMenu;
            menu.popMode = this.popMode();
            return;
        }
    }

    public static void handle(PopModeButtonPacket packet, Supplier<NetworkEvent.Context> cxt) {
        if (packet != null) {
            NetworkEvent.Context context = cxt.get();
            NetworkDirection direction = context.getDirection();
            if (direction == NetworkDirection.PLAY_TO_CLIENT) {
                context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> packet.handleClient(context)));
                context.setPacketHandled(true);
            } else if (direction == NetworkDirection.PLAY_TO_SERVER) {
                context.enqueueWork(() -> packet.handleServer(context));
                context.setPacketHandled(true);
            }
        }
    }

    public static void encode(PopModeButtonPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.popMode);
    }

    public static PopModeButtonPacket decode(FriendlyByteBuf buf) {
        boolean popMode = buf.readBoolean();
        return new PopModeButtonPacket(popMode);
    }
}

