/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.Chemicals;

import com.wintercogs.beyonddimensions.DataBase.Stack.Chemicals.GasStackType;
import com.wintercogs.beyonddimensions.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.resources.ResourceLocation;

public class GasHandlerWrapper
implements IStackHandlerWrapper<GasStack> {
    private final IGasHandler chemicalHandler;

    public GasHandlerWrapper(Object chemicalHandler) {
        this.chemicalHandler = (IGasHandler)chemicalHandler;
    }

    @Override
    public ResourceLocation getTypeId() {
        return GasStackType.ID;
    }

    @Override
    public int getSlots() {
        return this.chemicalHandler.getTanks();
    }

    @Override
    public GasStack getStackInSlot(int slot) {
        return (GasStack)this.chemicalHandler.getChemicalInTank(slot);
    }

    @Override
    public long getCapacity(int slot) {
        return this.chemicalHandler.getTankCapacity(slot);
    }

    @Override
    public boolean isStackValid(int slot, GasStack stack) {
        return this.chemicalHandler.isValid(slot, (ChemicalStack)stack);
    }

    @Override
    public long insert(int slot, GasStack Stack, boolean sim) {
        if (sim) {
            return ((GasStack)this.chemicalHandler.insertChemical(slot, (ChemicalStack)Stack, Action.SIMULATE)).getAmount();
        }
        return ((GasStack)this.chemicalHandler.insertChemical(slot, (ChemicalStack)Stack, Action.EXECUTE)).getAmount();
    }

    @Override
    public long insert(GasStack stack, boolean sim) {
        if (sim) {
            return ((GasStack)this.chemicalHandler.insertChemical((ChemicalStack)stack, Action.SIMULATE)).getAmount();
        }
        return ((GasStack)this.chemicalHandler.insertChemical((ChemicalStack)stack, Action.EXECUTE)).getAmount();
    }

    @Override
    public long extract(int slot, long amount, boolean sim) {
        if (sim) {
            return ((GasStack)this.chemicalHandler.extractChemical(slot, amount, Action.SIMULATE)).getAmount();
        }
        return ((GasStack)this.chemicalHandler.extractChemical(slot, amount, Action.EXECUTE)).getAmount();
    }

    @Override
    public long extract(GasStack stack, boolean sim) {
        if (sim) {
            return ((GasStack)this.chemicalHandler.extractChemical((ChemicalStack)stack, Action.SIMULATE)).getAmount();
        }
        return ((GasStack)this.chemicalHandler.extractChemical((ChemicalStack)stack, Action.EXECUTE)).getAmount();
    }
}

