/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.DataBase.Storage.Chemicals;

import com.wintercogs.beyonddimensions.DataBase.Stack.Chemicals.InfusionStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import mekanism.api.Action;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;

public class InfusionUnifiedStorageHandler
implements IInfusionHandler {
    private UnifiedStorage storage;

    public InfusionUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getTanks() {
        return this.storage.getTypeIdIndexList(InfusionStackType.ID).map(list -> list.size() + 1).orElse(1);
    }

    public InfusionStack getChemicalInTank(int slot) {
        return this.storage.getTypeIdIndexList(InfusionStackType.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> (Integer)slots.get(slot)).filter(actualIndex -> actualIndex >= 0).map(actualIndex -> (InfusionStackType)this.storage.getStackBySlot((int)actualIndex)).map(InfusionStackType::getStack).orElse(InfusionStack.EMPTY);
    }

    public void setChemicalInTank(int tank, InfusionStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        this.storage.insert(new InfusionStackType(stack.copy()), false);
    }

    public long getTankCapacity(int tank) {
        return Long.MAX_VALUE;
    }

    public boolean isValid(int tank, InfusionStack stack) {
        return true;
    }

    public InfusionStack insertChemical(int tank, InfusionStack stack, Action action) {
        if (stack.isEmpty()) {
            return InfusionStack.EMPTY;
        }
        long remaining = this.storage.insert(new InfusionStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new InfusionStack(stack, remaining);
        }
        return InfusionStack.EMPTY;
    }

    public InfusionStack extractChemical(int tank, long amount, Action action) {
        return ((InfusionStackType)this.storage.extract(new InfusionStackType(new InfusionStack(this.getChemicalInTank(tank), amount)), action.simulate())).copyStack();
    }

    public InfusionStack insertChemical(InfusionStack stack, Action action) {
        if (stack.isEmpty()) {
            return InfusionStack.EMPTY;
        }
        long remaining = this.storage.insert(new InfusionStackType(stack.copy()), action.simulate()).getStackAmount();
        if (remaining > 0L) {
            return new InfusionStack(stack, remaining);
        }
        return InfusionStack.EMPTY;
    }

    public InfusionStack extractChemical(long amount, Action action) {
        return ((InfusionStackType)this.storage.extract(new InfusionStackType(new InfusionStack(this.getChemicalInTank(0), amount)), action.simulate())).copyStack();
    }

    public InfusionStack extractChemical(InfusionStack stack, Action action) {
        return ((InfusionStackType)this.storage.extract(new InfusionStackType(stack.copy()), action.simulate())).copyStack();
    }
}

