/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.Config;
import com.wintercogs.beyonddimensions.DataBase.ButtonName;
import com.wintercogs.beyonddimensions.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.GUI.BDBaseGUI;
import com.wintercogs.beyonddimensions.GUI.SharedWidget.StatusButton;
import com.wintercogs.beyonddimensions.Menu.NetEnergyMenu;
import com.wintercogs.beyonddimensions.Network.Packet.ClientOrServer.PopModeButtonPacket;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class NetEnergyGUI
extends BDBaseGUI<NetEnergyMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.m_135820_((String)"beyonddimensions:textures/gui/net_energy_storage.png");
    public StatusButton popButton;

    public NetEnergyGUI(NetEnergyMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 175;
    }

    protected void m_7856_() {
        this.f_97735_ = (this.f_96543_ - 176) / 2;
        this.f_97736_ = (this.f_96544_ - 235) / 2;
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.popButton = new StatusButton(this.f_97735_ + 72 + 72 - 5, this.f_97736_ + 6, 16, 16, ButtonName.ReverseButton, button -> {
            this.popButton.toggleState();
            ((NetEnergyMenu)this.f_97732_).popMode = !((NetEnergyMenu)this.f_97732_).popMode;
            PacketRegister.INSTANCE.sendToServer((Object)new PopModeButtonPacket(((NetEnergyMenu)this.f_97732_).popMode));
        }){

            @Override
            protected void initButton() {
                this.iconMap.put(ButtonState.ENABLED, ResourceLocation.m_214293_((String)"beyonddimensions", (String)"textures/gui/sprites/widget/sort_asc.png"));
                this.iconMap.put(ButtonState.DISABLED, ResourceLocation.m_214293_((String)"beyonddimensions", (String)"textures/gui/sprites/widget/sort_desc.png"));
                this.tooltipMap.put(ButtonState.ENABLED, Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.button.beyonddimensions.popmode_on")));
                this.tooltipMap.put(ButtonState.DISABLED, Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.button.beyonddimensions.popmode_off")));
                for (ButtonState state : this.iconMap.keySet()) {
                    this.states.add(state);
                }
                this.setState(Config.uiReverseButton);
            }
        };
        this.m_142416_((GuiEventListener)this.popButton);
        ((NetEnergyMenu)this.f_97732_).m_150443_();
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        if (((NetEnergyMenu)this.f_97732_).popMode) {
            this.popButton.setState(ButtonState.ENABLED);
        } else {
            this.popButton.setState(ButtonState.DISABLED);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        guiGraphics.m_280218_(GUI_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.popButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderEnergyBar(guiGraphics, this.f_97735_ + 8, this.f_97736_ + 35);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_ + 10, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, StringFormat.formatCount(((NetEnergyMenu)this.f_97732_).energyStored) + "/" + StringFormat.formatCount(((NetEnergyMenu)this.f_97732_).energyCapacity), this.f_97730_, this.f_97731_ - 20, 0x404040, false);
    }

    protected void renderEnergyBar(GuiGraphics guiGraphics, int xStart, int yStart) {
        int areaWidth = 160;
        int areaHeight = 16;
        boolean stripeWidth = true;
        float[] brightnessFactors = new float[areaHeight];
        for (int y = 0; y < areaHeight; ++y) {
            float normalizedY = ((float)y - (float)areaHeight / 2.0f) / ((float)areaHeight / 2.0f);
            brightnessFactors[y] = 1.0f - normalizedY * normalizedY;
        }
        for (int i = 0; i < areaWidth; ++i) {
            int color = i / 1 % 2 == 0 ? -12582912 : -14680064;
            int width = Math.min(1, areaWidth - i);
            guiGraphics.m_280509_(xStart + i, yStart, xStart + i + width, yStart + areaHeight, color);
        }
        float energyRatio = (float)((NetEnergyMenu)this.f_97732_).energyStored / (float)((NetEnergyMenu)this.f_97732_).energyCapacity;
        int filledWidth = (int)(energyRatio * (float)areaWidth);
        for (int i = 0; i < filledWidth; ++i) {
            int baseColor = i / 1 % 2 == 0 ? -65536 : -8388608;
            int drawWidth = Math.min(1, filledWidth - i);
            int alpha = baseColor >> 24 & 0xFF;
            int red = baseColor >> 16 & 0xFF;
            int green = baseColor >> 8 & 0xFF;
            int blue = baseColor & 0xFF;
            for (int y = 0; y < areaHeight; ++y) {
                int adjustedAlpha = (int)((float)alpha * brightnessFactors[y]);
                int adjustedColor = adjustedAlpha << 24 | red << 16 | green << 8 | blue;
                guiGraphics.m_280509_(xStart + i, yStart + y, xStart + i + drawWidth, yStart + y + 1, adjustedColor);
            }
        }
    }

    @Override
    public Font getFont() {
        return this.f_96547_;
    }
}

