/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.AE;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import com.wintercogs.beyonddimensions.DataBase.Stack.FluidStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Registry.StackTypeRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class AEHelper {
    public static final Map<ResourceLocation, Function<IStackType, Optional<AEKey>>> ISTACK_TO_AEKEY_MAP = new HashMap<ResourceLocation, Function<IStackType, Optional<AEKey>>>();

    public static Optional<IStackType<?>> fromAEKeyToIStack(AEKey key, long amount) {
        if (key instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)key;
            return Optional.of(new ItemStackType(itemKey.toStack(1), amount));
        }
        if (key instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)key;
            return Optional.of(new FluidStackType(fluidKey.toStack(1), amount));
        }
        Object stackKey = key.getPrimaryKey();
        for (IStackType<?> type : StackTypeRegistry.getAllTypes()) {
            if (!type.getSourceClass().isAssignableFrom(stackKey.getClass())) continue;
            IStackType<?> stack = type.fromObject(stackKey, amount, null);
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public static Optional<AEKey> fromIStackToAEKey(IStackType stack) {
        if (ISTACK_TO_AEKEY_MAP.containsKey(stack.getTypeId())) {
            return ISTACK_TO_AEKEY_MAP.get(stack.getTypeId()).apply(stack);
        }
        return Optional.empty();
    }

    static {
        ISTACK_TO_AEKEY_MAP.put(ItemStackType.ID, stackType -> Optional.ofNullable(AEItemKey.of((ItemStack)((ItemStack)stackType.copyStack()))));
        ISTACK_TO_AEKEY_MAP.put(FluidStackType.ID, stackType -> Optional.ofNullable(AEFluidKey.of((FluidStack)((FluidStack)stackType.copyStack()))));
    }
}

