/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.EMI.SlotHandler;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;

public class SlotDragHandler
implements EmiDragDropHandler<AbstractContainerScreen<?>> {
    private final Predicate<Slot> slotFilter;
    private final BiConsumer<Slot, EmiIngredient> dropHandler;

    public SlotDragHandler(Predicate<Slot> slotFilter, BiConsumer<Slot, EmiIngredient> dropHandler) {
        this.slotFilter = slotFilter;
        this.dropHandler = dropHandler;
    }

    public boolean dropStack(AbstractContainerScreen<?> screen, EmiIngredient ingredient, int x, int y) {
        double mouseX = x - screen.getGuiLeft();
        double mouseY = y - screen.getGuiTop();
        for (Slot slot : screen.m_6262_().f_38839_) {
            if (!this.slotFilter.test(slot) || !this.isMouseOverSlot(screen, slot, mouseX, mouseY)) continue;
            this.dropHandler.accept(slot, ingredient);
            return true;
        }
        return false;
    }

    public void render(AbstractContainerScreen<?> screen, EmiIngredient dragged, GuiGraphics draw, int mouseX, int mouseY, float delta) {
        super.render(screen, dragged, draw, mouseX, mouseY, delta);
    }

    private boolean isMouseOverSlot(AbstractContainerScreen<?> screen, Slot slot, double mouseX, double mouseY) {
        return this.isPointInRegion(screen, slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY);
    }

    private boolean isPointInRegion(AbstractContainerScreen<?> screen, int x, int y, int width, int height, double pointX, double pointY) {
        return pointX >= (double)(x - 1) && pointX < (double)(x + width + 1) && pointY >= (double)(y - 1) && pointY < (double)(y + height + 1);
    }
}

