/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.JEI.RecipeTransfer;

import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Stack.ItemStackType;
import com.wintercogs.beyonddimensions.Integration.JEI.RecipeTransfer.MissStackError;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenuTerminal;
import com.wintercogs.beyonddimensions.Network.Packet.toServer.RecipeFillC2SPacket;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import com.wintercogs.beyonddimensions.Registry.UIRegister;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class CraftTerminalRecipeTransferHandler
implements IRecipeTransferHandler<DimensionsCraftMenuTerminal, CraftingRecipe> {
    public Class<? extends DimensionsCraftMenuTerminal> getContainerClass() {
        return DimensionsCraftMenuTerminal.class;
    }

    public Optional<MenuType<DimensionsCraftMenuTerminal>> getMenuType() {
        return Optional.of(UIRegister.Dimensions_Craft_Menu_Terminal.get());
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    public IRecipeTransferError transferRecipe(DimensionsCraftMenuTerminal container, CraftingRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        List<Slot> craftingSlots = this.getInputSources(container);
        List<IStackType> storageSlots = container.storage.getStorage();
        ArrayList<ItemStack> availableItems = new ArrayList<ItemStack>();
        for (Slot slot : craftingSlots) {
            if (!slot.m_6657_()) continue;
            availableItems.add(slot.m_7993_().m_41777_());
        }
        for (IStackType stackType : storageSlots) {
            ItemStackType itemStackType;
            ItemStack stack;
            if (!(stackType instanceof ItemStackType) || (stack = (itemStackType = (ItemStackType)stackType).getStack()).m_41619_()) continue;
            availableItems.add(stack.m_41777_());
        }
        for (ItemStack itemStack : container.player.m_150109_().f_35974_) {
            if (itemStack.m_41619_()) continue;
            availableItems.add(itemStack.m_41777_());
        }
        ArrayList<IRecipeSlotView> missingSlots = new ArrayList<IRecipeSlotView>();
        ArrayList<ItemStack> inputElements = new ArrayList<ItemStack>();
        block3: for (IRecipeSlotView slotView : recipeSlots.getSlotViews(RecipeIngredientRole.INPUT)) {
            if (slotView.getRole() != RecipeIngredientRole.INPUT) continue;
            Ingredient mergedIngredient = Ingredient.m_43921_((Stream)slotView.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK));
            if (mergedIngredient.m_43947_()) {
                inputElements.add(ItemStack.f_41583_);
                continue;
            }
            int required = 1;
            ArrayList<ItemStack> matching = new ArrayList<ItemStack>();
            for (ItemStack stack : availableItems) {
                if (stack.m_41619_() || !mergedIngredient.test(stack)) continue;
                matching.add(stack);
            }
            int available = matching.stream().mapToInt(ItemStack::m_41613_).sum();
            if (available >= required) {
                ItemStack merged = matching.isEmpty() ? ItemStack.f_41583_ : new ItemStack((ItemLike)((ItemStack)matching.get(0)).m_41720_(), required);
                inputElements.add(merged);
                int remaining = required;
                for (ItemStack stack : matching) {
                    int deduct = Math.min(remaining, stack.m_41613_());
                    stack.m_41774_(deduct);
                    if ((remaining -= deduct) > 0) continue;
                    continue block3;
                }
                continue;
            }
            inputElements.add(ItemStack.f_41583_);
            missingSlots.add(slotView);
        }
        if (doTransfer) {
            PacketRegister.INSTANCE.sendToServer((Object)new RecipeFillC2SPacket(inputElements));
        }
        if (!missingSlots.isEmpty()) {
            return new MissStackError(missingSlots);
        }
        return null;
    }

    private List<Slot> getInputSources(DimensionsCraftMenuTerminal menu) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = menu.craftSlotStartIndex; i < menu.craftSlotEndIndex; ++i) {
            slots.add(menu.m_38853_(i));
        }
        return slots;
    }
}

