/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.wintercogs.beyonddimensions.Config;
import com.wintercogs.beyonddimensions.DataBase.ButtonName;
import com.wintercogs.beyonddimensions.DataBase.ButtonState;
import com.wintercogs.beyonddimensions.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Menu.BDDisorderedContainerMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.StoredStackSlot;
import com.wintercogs.beyonddimensions.Network.Packet.toClient.SyncStoragePacket;
import com.wintercogs.beyonddimensions.Registry.PacketRegister;
import com.wintercogs.beyonddimensions.Registry.UIRegister;
import com.wintercogs.beyonddimensions.Unit.TinyPinyinUtils;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.network.PacketDistributor;

public class DimensionsNetMenu
extends BDDisorderedContainerMenu {
    public int maxLines = 6;
    public int lineData = 0;
    public int maxLineData = 0;
    private String searchText = "";
    private HashMap<ButtonName, ButtonState> buttonStateMap = new HashMap();
    public UnifiedStorage viewerStorage;
    private ArrayList<Integer> cacheIndex;
    private ArrayList<IStackType> lastStorage;
    public boolean hasShiftDown = false;

    public DimensionsNetMenu(int id, Inventory playerInventory) {
        this(UIRegister.Dimensions_Net_Menu.get(), id, playerInventory, new DimensionsNet(true));
    }

    public DimensionsNetMenu(MenuType<?> menuType, int id, Inventory playerInventory, DimensionsNet data) {
        super(menuType, id, playerInventory, data.getUnifiedStorage());
        if (this.player.m_9236_().m_5776_()) {
            this.maxLines = Config.uiPageNum;
            this.searchText = Config.uiSearch;
        }
        this.viewerStorage = new DimensionsNet(true).getUnifiedStorage();
        if (!this.player.m_9236_().m_5776_()) {
            this.lastStorage = new ArrayList();
        }
        this.addStorageSlots();
        this.addPlayerInv(playerInventory);
    }

    public int getLines() {
        return this.maxLines;
    }

    public void reduceLines() {
        --this.maxLines;
    }

    public void addLines() {
        ++this.maxLines;
    }

    public void setLines(int lines) {
        this.maxLines = lines;
    }

    protected void addStorageSlots() {
        for (int row = 0; row < 99; ++row) {
            for (int col = 0; col < 9; ++col) {
                StoredStackSlot newSlot = new StoredStackSlot(this.viewerStorage, -1, 8 + col * 18, 25 + row * 18);
                if (row >= this.getLines()) {
                    newSlot.setActive(false);
                }
                this.m_38897_(newSlot);
            }
        }
    }

    protected void addPlayerInv(Inventory playerInventory) {
        this.inventoryStartIndex = this.f_38839_.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 25 + (this.getLines() - 1) * 18 + 26 + 6 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 25 + (this.getLines() - 1) * 18 + 26 + 6 + 54 + 4));
        }
        this.inventoryEndIndex = this.f_38839_.size();
    }

    public void rebuildSlots() {
        int sSlotNum = 0;
        for (Slot slot : this.f_38839_) {
            if (!(slot instanceof StoredStackSlot)) continue;
            StoredStackSlot sSlot = (StoredStackSlot)slot;
            if (sSlotNum / 9 < this.getLines()) {
                sSlot.setActive(true);
            } else {
                sSlot.setActive(false);
            }
            ++sSlotNum;
        }
        int slotNum = 0;
        for (int i = this.inventoryStartIndex; i < this.inventoryEndIndex; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (slot == null) continue;
            slot.f_40221_ = slotNum / 9 < 3 ? 25 + (this.getLines() - 1) * 18 + 26 + 6 + slotNum / 9 * 18 : 25 + (this.getLines() - 1) * 18 + 26 + 6 + 54 + 4;
            ++slotNum;
        }
    }

    public void updateViewerStorage() {
        this.viewerStorage.clearStorage();
        for (IStackType stack : this.storage.getStorage()) {
            this.viewerStorage.insert(stack.copy(), false);
        }
        this.buildIndexList(new ArrayList<IStackType>(this.viewerStorage.getStorage()), true);
    }

    public void updateOnlyCountAndNewViewer() {
        HashMap<IStackType, Long> storageMap = new HashMap<IStackType, Long>();
        for (IStackType stack : this.storage.getStorage()) {
            storageMap.put(stack, stack.getStackAmount());
        }
        for (IStackType viewerStack : this.viewerStorage.getStorage()) {
            long amount = storageMap.getOrDefault(viewerStack, 0L);
            viewerStack.setStackAmount(amount);
        }
    }

    public void buildIndexList(ArrayList<IStackType> itemStorage, boolean needsUpdateCacheIndex) {
        if (!this.player.m_9236_().m_5776_()) {
            return;
        }
        if (needsUpdateCacheIndex || this.cacheIndex == null) {
            this.cacheIndex = this.buildStorageWithCurrentState(new ArrayList<IStackType>(itemStorage));
        }
        this.updateScrollLineData(this.cacheIndex.size());
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < this.getLines() * 9; ++i) {
            if (i + this.lineData * 9 < this.cacheIndex.size()) {
                int index = this.cacheIndex.get(i + this.lineData * 9);
                indexList.add(index);
                continue;
            }
            indexList.add(-1);
        }
        this.loadIndexList(indexList);
    }

    public void loadIndexList(ArrayList<Integer> list) {
        for (int i = 0; i < list.size(); ++i) {
            ((StoredStackSlot)((Object)this.f_38839_.get(i))).setTheSlotIndex(list.get(i));
        }
    }

    public void loadSearchText(String text) {
        this.searchText = text.toLowerCase(Locale.ENGLISH);
    }

    public ArrayList<Integer> buildStorageWithCurrentState(ArrayList<IStackType> unifiedStorage) {
        ArrayList cache = new ArrayList();
        ArrayList<Integer> cacheIndex = new ArrayList<Integer>();
        for (int i = 0; i < unifiedStorage.size(); ++i) {
            boolean matchesSearch;
            IStackType stack = unifiedStorage.get(i).copy();
            if (stack == null || stack.isEmpty()) continue;
            String displayName = stack.getDisplayName().getString().toLowerCase(Locale.ENGLISH);
            String allPinyin = TinyPinyinUtils.getAllPinyin(displayName, false).toLowerCase(Locale.ENGLISH);
            String firstPinyin = TinyPinyinUtils.getFirstPinYin(displayName).toLowerCase(Locale.ENGLISH);
            if (this.searchText == null || this.searchText.isEmpty()) {
                matchesSearch = true;
            } else {
                String lowerSearch = this.searchText.toLowerCase(Locale.ENGLISH);
                int atIndex = lowerSearch.indexOf(64);
                if (atIndex >= 0) {
                    String mainPart = atIndex > 0 ? lowerSearch.substring(0, atIndex) : "";
                    String tooltipPart = atIndex + 1 < lowerSearch.length() ? lowerSearch.substring(atIndex + 1) : "";
                    boolean matchesMain = mainPart.isEmpty() || displayName.contains(mainPart) || allPinyin.contains(mainPart) || firstPinyin.contains(mainPart);
                    boolean matchesTooltip = tooltipPart.isEmpty() || this.checkTooltipMatches(stack, tooltipPart);
                    matchesSearch = matchesMain && matchesTooltip;
                } else {
                    boolean bl = matchesSearch = displayName.contains(lowerSearch) || allPinyin.contains(lowerSearch) || firstPinyin.contains(lowerSearch);
                }
            }
            if (!matchesSearch) continue;
            cache.add(stack);
            cacheIndex.add(i);
        }
        ButtonState sortState = Config.uiSortButton;
        if (sortState != ButtonState.SORT_DEFAULT) {
            Comparator<IStackType> comparator = sortState == ButtonState.SORT_NAME ? Comparator.comparing(item -> item.getDisplayName().getString()) : (sortState == ButtonState.SORT_QUANTITY ? Comparator.comparingLong(IStackType::getStackAmount) : (sortState == ButtonState.SORT_MODID ? Comparator.comparing(IStackType::getModId) : Comparator.comparing(item -> item.getDisplayName().getString())));
            ArrayList finalCache = cache;
            List indices = IntStream.range(0, cache.size()).parallel().boxed().sorted((a, b) -> comparator.compare((IStackType)finalCache.get((int)a), (IStackType)finalCache.get((int)b))).collect(Collectors.toList());
            ArrayList<Integer> sortedIndices = new ArrayList<Integer>(cacheIndex.size());
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                sortedIndices.add(cacheIndex.get(index));
            }
            cacheIndex = sortedIndices;
        }
        if (Config.uiReverseButton == ButtonState.ENABLED) {
            Collections.reverse(cacheIndex);
        }
        return cacheIndex;
    }

    private boolean checkTooltipMatches(IStackType stack, String matchText) {
        List<Component> toolTips = stack.getTooltipLines(this.player, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
        return toolTips.stream().anyMatch(tooltip -> tooltip.getString().toLowerCase(Locale.ENGLISH).contains(matchText));
    }

    public void updateScrollLineData(int dataSize) {
        this.maxLineData = dataSize / 9;
        if (dataSize % 9 != 0) {
            ++this.maxLineData;
        }
        this.maxLineData -= this.getLines();
        this.maxLineData = Math.max(this.maxLineData, 0);
        this.lineData = Math.max(this.lineData, 0);
        this.lineData = Math.min(this.lineData, this.maxLineData);
    }

    @Override
    protected void updateChange() {
        ArrayList changedItem = new ArrayList();
        ArrayList<Long> changedCount = new ArrayList<Long>();
        HashMap<IStackType, Long> lastMap = new HashMap<IStackType, Long>();
        for (IStackType iStackType : this.lastStorage) {
            lastMap.put(iStackType, lastMap.getOrDefault(iStackType, 0L) + iStackType.getStackAmount());
        }
        HashMap<IStackType, Long> nowMap = new HashMap<IStackType, Long>();
        for (IStackType iStackType : this.storage.getStorage()) {
            nowMap.put(iStackType, nowMap.getOrDefault(iStackType, 0L) + iStackType.getStackAmount());
        }
        this.refreshLast();
        HashSet hashSet = new HashSet();
        hashSet.addAll(lastMap.keySet());
        hashSet.addAll(nowMap.keySet());
        for (IStackType key : hashSet) {
            long lastCount = lastMap.getOrDefault(key, 0L);
            long nowCount = nowMap.getOrDefault(key, 0L);
            long delta = nowCount - lastCount;
            if (delta == 0L) continue;
            changedItem.add(key.copy());
            changedCount.add(delta);
        }
        if (!changedItem.isEmpty()) {
            int n = 921600;
            ArrayList<SyncStoragePacket> packets = new ArrayList<SyncStoragePacket>();
            ArrayList<Integer> entrySizes = new ArrayList<Integer>();
            for (int i = 0; i < changedItem.size(); ++i) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                IStackType stack = (IStackType)changedItem.get(i);
                if (stack != null) {
                    stack.serialize(buf);
                }
                buf.writeLong(((Long)changedCount.get(i)).longValue());
                entrySizes.add(buf.readableBytes());
            }
            ArrayList<IStackType> batchItems = new ArrayList<IStackType>();
            ArrayList<Long> batchCounts = new ArrayList<Long>();
            int currentSize = 0;
            for (int i = 0; i < changedItem.size(); ++i) {
                int entrySize = (Integer)entrySizes.get(i);
                if (currentSize + entrySize > 921600) {
                    packets.add(new SyncStoragePacket(new ArrayList<IStackType>(batchItems), new ArrayList<Long>(batchCounts), new ArrayList<Integer>()));
                    batchItems.clear();
                    batchCounts.clear();
                    currentSize = 0;
                }
                batchItems.add((IStackType)changedItem.get(i));
                batchCounts.add((Long)changedCount.get(i));
                currentSize += entrySize;
            }
            if (!batchItems.isEmpty()) {
                packets.add(new SyncStoragePacket(batchItems, batchCounts, new ArrayList<Integer>()));
            }
            for (SyncStoragePacket packet : packets) {
                PacketRegister.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)packet);
            }
        }
    }

    @Override
    protected void initUpdate() {
    }

    public void refreshLast() {
        this.lastStorage.clear();
        for (IStackType stack : this.storage.getStorage()) {
            this.lastStorage.add(stack.copy());
        }
    }

    @Override
    public boolean m_6875_(Player player) {
        return true;
    }
}

