/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.AE;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackType;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Integration.AE.AEHelper;
import java.util.Optional;
import net.minecraft.network.chat.Component;

public class NetStorageCell
implements StorageCell {
    private final UnifiedStorage storage;
    private final KeyCounter snapshot = new KeyCounter();
    private AutoCloseable deltaSub = null;
    private AutoCloseable anySub = null;

    public NetStorageCell(UnifiedStorage storage) {
        this.storage = storage;
        this.fullRebuildSnapshot();
        this.deltaSub = storage.subscribeDeltaWeak(this, (self, type, size, insert) -> self.applyDelta((IStackType<?>)type, (long)size, (boolean)insert));
        this.anySub = storage.subscribeAnyWeak(this, self -> self.fullRebuildSnapshot());
    }

    public CellState getStatus() {
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return 1.0;
    }

    public boolean canFitInsideCell() {
        return true;
    }

    public void persist() {
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return true;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        return AEHelper.fromAEKeyToIStack(what, amount).map(stack -> amount - this.storage.insert((IStackType)stack, mode.isSimulate()).getStackAmount()).orElse(0L);
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        return AEHelper.fromAEKeyToIStack(what, amount).map(stack -> this.storage.extract((IStackType)stack, mode.isSimulate()).getStackAmount()).orElse(0L);
    }

    public void getAvailableStacks(KeyCounter out) {
        out.addAll(this.snapshot);
    }

    public Component getDescription() {
        return Component.empty();
    }

    private void applyDelta(IStackType<?> type, long size, boolean insert) {
        long next;
        Optional<AEKey> keyOpt = AEHelper.fromIStackToAEKey(type);
        if (keyOpt.isEmpty()) {
            return;
        }
        AEKey key = keyOpt.get();
        long cur = this.snapshot.get(key);
        long l = next = insert ? cur + size : cur - size;
        if (next > 0L) {
            this.snapshot.set(key, next);
        } else {
            this.snapshot.remove(key);
        }
    }

    private void fullRebuildSnapshot() {
        this.snapshot.clear();
        for (IStackType stack : this.storage.getStorage()) {
            if (stack.isEmpty()) continue;
            AEHelper.fromIStackToAEKey(stack).ifPresent(aeKey -> this.snapshot.add(aeKey, stack.getStackAmount()));
        }
    }

    public void close() {
        try {
            if (this.deltaSub != null) {
                this.deltaSub.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.anySub != null) {
                this.anySub.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.anySub = null;
        this.deltaSub = null;
    }
}

