/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackHandler
implements IStackHandler {
    private static final MapCodec<StackHandler> NEW_FMT = RecordCodecBuilder.mapCodec(instance -> instance.group((App)KeyAmount.CODEC.listOf().fieldOf("stacks").forGetter(sh -> {
        ArrayList<KeyAmount> list = new ArrayList<KeyAmount>(sh.size);
        for (int i = 0; i < sh.size; ++i) {
            list.add(new KeyAmount(sh.keys[i], sh.amounts[i]));
        }
        return list;
    })).apply((Applicative)instance, StackHandler::new));
    public static final MapCodec<StackHandler> TYPE_CODEC = new MapCodec<StackHandler>(){
        private static final String K_NEW_STACKS = "stacks";
        private static final String K_OLD_STACKS = "Stacks";
        private static final String K_TYPED = "TypedStack";

        public <T> DataResult<StackHandler> decode(DynamicOps<T> ops, MapLike<T> input) {
            Object kNewStacks = ops.createString(K_NEW_STACKS);
            Object kOldStacks = ops.createString(K_OLD_STACKS);
            Object kTyped = ops.createString(K_TYPED);
            if (input.get(kNewStacks) != null) {
                return NEW_FMT.decode(ops, input);
            }
            Object oldNode = input.get(kOldStacks);
            if (oldNode == null) {
                return NEW_FMT.decode(ops, input);
            }
            return ops.getStream(oldNode).flatMap(stream -> {
                ArrayList<KeyAmount> out = new ArrayList<KeyAmount>();
                stream.forEach(elem -> {
                    MapLike entryML = ops.getMap(elem).result().orElse(null);
                    if (entryML == null) {
                        out.add(new KeyAmount(EmptyStackKey.INSTANCE, 0L));
                        return;
                    }
                    Object typedNode = entryML.get(kTyped);
                    if (typedNode == null) {
                        out.add(new KeyAmount(EmptyStackKey.INSTANCE, 0L));
                        return;
                    }
                    if (ops.getMap(typedNode).result().isEmpty()) {
                        out.add(new KeyAmount(EmptyStackKey.INSTANCE, 0L));
                        return;
                    }
                    KeyAmount ka = KeyAmount.CODEC.decode(ops, typedNode).map(Pair::getFirst).resultOrPartial(err -> BeyondDimensions.LOGGER.warn("\u65e7 Stacks -> KeyAmount(\u6765\u81ea TypedStack) \u89e3\u7801\u5931\u8d25: {}", err)).orElse(new KeyAmount(EmptyStackKey.INSTANCE, 0L));
                    out.add(ka);
                });
                return DataResult.success((Object)new StackHandler(out));
            });
        }

        public <T> RecordBuilder<T> encode(StackHandler value, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return NEW_FMT.encode((Object)value, ops, prefix);
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString(K_NEW_STACKS));
        }
    };
    public static final Codec<StackHandler> CODEC = TYPE_CODEC.codec();
    private final int size;
    private final IStackKey<?>[] keys;
    private final long[] amounts;
    private final Map<IStackKey<?>, Object> key2stackMap = new HashMap();
    private final List<KeyAmount> entriesView = Collections.unmodifiableList(new AbstractList<KeyAmount>(){

        @Override
        public KeyAmount get(int index) {
            if (index < 0 || index >= StackHandler.this.size) {
                return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
            }
            IStackKey<?> k = StackHandler.this.keys[index];
            long amt = k == EmptyStackKey.INSTANCE ? 0L : StackHandler.this.amounts[index];
            return new KeyAmount(k, amt);
        }

        @Override
        public int size() {
            return StackHandler.this.size;
        }
    });
    private final Map<ResourceLocation, SlotBucket> typeBuckets = new HashMap<ResourceLocation, SlotBucket>();
    private final Map<IStackKey<?>, SlotBucket> keyBuckets = new HashMap();

    private SlotBucket bucketOf(ResourceLocation typeId) {
        return this.typeBuckets.computeIfAbsent(typeId, t -> new SlotBucket());
    }

    public Optional<SlotBucket> getBucket(ResourceLocation typeId) {
        return Optional.ofNullable(this.typeBuckets.get(typeId));
    }

    private SlotBucket bucketOf(IStackKey<?> key) {
        return this.keyBuckets.computeIfAbsent(key, k -> new SlotBucket());
    }

    public Optional<SlotBucket> getBucket(IStackKey<?> key) {
        return Optional.ofNullable(this.keyBuckets.get(key));
    }

    public StackHandler(int size) {
        this.size = Math.max(0, size);
        this.keys = new IStackKey[this.size];
        this.amounts = new long[this.size];
        Arrays.fill(this.keys, EmptyStackKey.INSTANCE);
        Arrays.fill(this.amounts, 0L);
        SlotBucket eb = this.bucketOf(EmptyStackKey.INSTANCE);
        for (int i = 0; i < this.size; ++i) {
            eb.add(i);
        }
    }

    public StackHandler(List<KeyAmount> stacks) {
        this(stacks.size());
        for (int i = 0; i < this.size; ++i) {
            KeyAmount ka = stacks.get(i);
            if (ka != null) {
                this.setStackDirectly(i, ka.key(), ka.amount());
                continue;
            }
            this.setStackDirectly(i, EmptyStackKey.INSTANCE, 0L);
        }
    }

    @Override
    public List<KeyAmount> getStorage() {
        return this.entriesView;
    }

    @Override
    public void onChange() {
    }

    @Override
    public int getSlots() {
        return this.size;
    }

    @Override
    public void clearStorage() {
        Arrays.fill(this.keys, EmptyStackKey.INSTANCE);
        Arrays.fill(this.amounts, 0L);
        this.typeBuckets.clear();
        this.keyBuckets.clear();
        this.key2stackMap.clear();
        SlotBucket eb = this.bucketOf(EmptyStackKey.INSTANCE);
        for (int i = 0; i < this.size; ++i) {
            eb.add(i);
        }
        this.onChange();
    }

    @Override
    @NotNull
    public KeyAmount getStackBySlot(int slot) {
        IStackKey<?> k;
        if (slot < 0 || slot >= this.size) {
            return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
        }
        return new KeyAmount(k, (k = this.keys[slot]) == EmptyStackKey.INSTANCE ? 0L : this.amounts[slot]);
    }

    @Override
    @NotNull
    public KeyAmount getStackByKey(IStackKey<?> key) {
        if (key == null || key == EmptyStackKey.INSTANCE) {
            return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
        }
        SlotBucket b = this.keyBuckets.get(key);
        if (b == null || b.size() == 0) {
            return new KeyAmount(key, 0L);
        }
        int slot = b.get(0);
        return new KeyAmount(key, this.amounts[slot]);
    }

    @Override
    public boolean hasStack(IStackKey<?> key) {
        if (key == null || key == EmptyStackKey.INSTANCE) {
            return false;
        }
        SlotBucket b = this.keyBuckets.get(key);
        return b != null && b.size() > 0;
    }

    @Override
    public void setStackDirectly(int slot, IStackKey<?> key, long amount) {
        if (slot < 0 || slot >= this.size) {
            return;
        }
        IStackKey<?> oldKey = this.keys[slot];
        if (oldKey == EmptyStackKey.INSTANCE) {
            SlotBucket eb = this.keyBuckets.get(EmptyStackKey.INSTANCE);
            if (eb != null) {
                eb.remove(slot);
            }
        } else {
            SlotBucket kb;
            SlotBucket tb = this.typeBuckets.get(oldKey.getTypeId());
            if (tb != null) {
                tb.remove(slot);
                if (tb.size() == 0) {
                    this.typeBuckets.remove(oldKey.getTypeId());
                }
            }
            if ((kb = this.keyBuckets.get(oldKey)) != null) {
                kb.remove(slot);
                if (kb.size() == 0) {
                    this.keyBuckets.remove(oldKey);
                }
            }
        }
        if (key == null || key == EmptyStackKey.INSTANCE || amount <= 0L) {
            this.keys[slot] = EmptyStackKey.INSTANCE;
            this.amounts[slot] = 0L;
            this.bucketOf(EmptyStackKey.INSTANCE).add(slot);
            this.removeFromIndex(oldKey);
            this.onChange();
            return;
        }
        long clamped = Math.max(0L, Math.min(amount, this.getSlotCapacity(slot)));
        if (clamped <= 0L) {
            this.keys[slot] = EmptyStackKey.INSTANCE;
            this.amounts[slot] = 0L;
            this.bucketOf(EmptyStackKey.INSTANCE).add(slot);
            this.removeFromIndex(oldKey);
            this.onChange();
            return;
        }
        this.keys[slot] = key;
        this.amounts[slot] = clamped;
        SlotBucket eb = this.keyBuckets.get(EmptyStackKey.INSTANCE);
        if (eb != null) {
            eb.remove(slot);
        }
        this.bucketOf(key.getTypeId()).add(slot);
        this.bucketOf(key).add(slot);
        this.ensureInIndex(key);
        this.removeFromIndex(oldKey);
        this.onChange();
    }

    @Override
    public void addStackDirectly(IStackKey<?> key, long amount) {
        if (key == null || key == EmptyStackKey.INSTANCE || amount <= 0L) {
            return;
        }
        SlotBucket eb = this.keyBuckets.get(EmptyStackKey.INSTANCE);
        if (eb == null || eb.size() == 0) {
            return;
        }
        int empty = eb.get(0);
        this.setStackDirectly(empty, key, amount);
    }

    @Override
    @NotNull
    public KeyAmount insert(int slot, IStackKey<?> key, long amount, boolean simulate) {
        if (key == null || key == EmptyStackKey.INSTANCE || amount <= 0L) {
            return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
        }
        if (slot < 0 || slot >= this.size) {
            return new KeyAmount(key, amount);
        }
        if (!this.isStackValid(slot, key)) {
            return new KeyAmount(key, amount);
        }
        long left = amount;
        IStackKey<?> curKey = this.keys[slot];
        if (curKey == EmptyStackKey.INSTANCE) {
            long cap = Math.min(key.getVanillaMaxStackSize(), this.getSlotCapacity(slot));
            long ins = Math.min(left, cap);
            if (ins <= 0L) {
                return new KeyAmount(key, left);
            }
            if (!simulate) {
                this.keys[slot] = key;
                this.amounts[slot] = ins;
                SlotBucket eb = this.keyBuckets.get(EmptyStackKey.INSTANCE);
                if (eb != null) {
                    eb.remove(slot);
                }
                this.bucketOf(key.getTypeId()).add(slot);
                this.bucketOf(key).add(slot);
                this.ensureInIndex(key);
                this.onChange();
            }
            return new KeyAmount(key, left -= ins);
        }
        if (!curKey.equals(key)) {
            return new KeyAmount(key, left);
        }
        long cap = Math.min(key.getVanillaMaxStackSize(), this.getSlotCapacity(slot));
        long room = Math.max(0L, cap - this.amounts[slot]);
        long ins = Math.min(left, room);
        if (ins <= 0L) {
            return new KeyAmount(key, left);
        }
        if (!simulate) {
            int n = slot;
            this.amounts[n] = this.amounts[n] + ins;
            this.onChange();
        }
        return new KeyAmount(key, left -= ins);
    }

    @Override
    @NotNull
    public KeyAmount insert(IStackKey<?> key, long amount, boolean simulate) {
        SlotBucket eb;
        if (key == null || key == EmptyStackKey.INSTANCE || amount <= 0L) {
            return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
        }
        long left = amount;
        SlotBucket exact = this.keyBuckets.get(key);
        if (exact != null && exact.size() > 0) {
            List<Integer> slots = exact.snapshot();
            for (int slot : slots) {
                if (left <= 0L) break;
                long cap = Math.min(key.getVanillaMaxStackSize(), this.getSlotCapacity(slot));
                long room = Math.max(0L, cap - this.amounts[slot]);
                if (room <= 0L) continue;
                long ins = Math.min(left, room);
                if (simulate) {
                    left -= ins;
                    continue;
                }
                int n = slot;
                this.amounts[n] = this.amounts[n] + ins;
                left -= ins;
            }
        }
        if (left > 0L && (eb = this.keyBuckets.get(EmptyStackKey.INSTANCE)) != null && eb.size() > 0) {
            List<Integer> slots = eb.snapshot();
            for (int idx : slots) {
                long cap;
                long ins;
                if (left <= 0L) break;
                if (!this.isStackValid(idx, key) || (ins = Math.min(left, cap = Math.min(key.getVanillaMaxStackSize(), this.getSlotCapacity(idx)))) <= 0L) continue;
                if (!simulate) {
                    this.keys[idx] = key;
                    this.amounts[idx] = ins;
                    eb.remove(idx);
                    this.bucketOf(key.getTypeId()).add(idx);
                    this.bucketOf(key).add(idx);
                    this.ensureInIndex(key);
                }
                left -= ins;
            }
        }
        if (!simulate && left != amount) {
            this.onChange();
        }
        return new KeyAmount(key, left);
    }

    @Override
    @NotNull
    public KeyAmount extract(int slot, long count, boolean simulate) {
        if (slot < 0 || slot >= this.size || count <= 0L) {
            return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
        }
        IStackKey<?> k = this.keys[slot];
        if (k == EmptyStackKey.INSTANCE) {
            return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
        }
        long have = this.amounts[slot];
        long take = Math.min(count, have);
        if (take <= 0L) {
            return new KeyAmount(k, 0L);
        }
        if (!simulate) {
            long left = have - take;
            if (left == 0L) {
                SlotBucket kb;
                SlotBucket tb = this.typeBuckets.get(k.getTypeId());
                if (tb != null) {
                    tb.remove(slot);
                    if (tb.size() == 0) {
                        this.typeBuckets.remove(k.getTypeId());
                    }
                }
                if ((kb = this.keyBuckets.get(k)) != null) {
                    kb.remove(slot);
                    if (kb.size() == 0) {
                        this.keyBuckets.remove(k);
                    }
                }
                this.keys[slot] = EmptyStackKey.INSTANCE;
                this.amounts[slot] = 0L;
                this.bucketOf(EmptyStackKey.INSTANCE).add(slot);
                this.removeFromIndex(k);
            } else {
                this.amounts[slot] = left;
            }
            this.onChange();
        }
        return new KeyAmount(k, take);
    }

    @Override
    @NotNull
    public KeyAmount extract(IStackKey<?> key, long amount, boolean simulate) {
        if (key == null || key == EmptyStackKey.INSTANCE || amount <= 0L) {
            return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
        }
        SlotBucket exact = this.keyBuckets.get(key);
        if (exact == null || exact.size() == 0) {
            return new KeyAmount(key, 0L);
        }
        long need = amount;
        long taken = 0L;
        List<Integer> slots = exact.snapshot();
        for (int slot : slots) {
            long t;
            if (need <= 0L) break;
            long have = this.amounts[slot];
            if (have <= 0L || (t = Math.min(need, have)) <= 0L) continue;
            if (!simulate) {
                long left = have - t;
                if (left == 0L) {
                    SlotBucket kb;
                    SlotBucket tb = this.typeBuckets.get(key.getTypeId());
                    if (tb != null) {
                        tb.remove(slot);
                        if (tb.size() == 0) {
                            this.typeBuckets.remove(key.getTypeId());
                        }
                    }
                    if ((kb = this.keyBuckets.get(key)) != null) {
                        kb.remove(slot);
                        if (kb.size() == 0) {
                            this.keyBuckets.remove(key);
                        }
                    }
                    this.keys[slot] = EmptyStackKey.INSTANCE;
                    this.amounts[slot] = 0L;
                    this.bucketOf(EmptyStackKey.INSTANCE).add(slot);
                    this.removeFromIndex(key);
                } else {
                    this.amounts[slot] = left;
                }
            }
            taken += t;
            need -= t;
        }
        if (!simulate && taken > 0L) {
            this.onChange();
        }
        return new KeyAmount(key, taken);
    }

    @Override
    public long getSlotCapacity(int slot) {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean isStackValid(int slot, IStackKey<?> key) {
        return key != null;
    }

    @Override
    public boolean isEmpty() {
        SlotBucket eb = this.keyBuckets.get(EmptyStackKey.INSTANCE);
        return eb != null && eb.size() == this.size;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)provider);
        Tag encoded = (Tag)CODEC.encodeStart((DynamicOps)ops, (Object)this).getOrThrow(IllegalStateException::new);
        return (CompoundTag)encoded;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.clearStorage();
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)provider);
        StackHandler decoded = (StackHandler)CODEC.parse((DynamicOps)ops, (Object)tag).getOrThrow(IllegalStateException::new);
        for (int i = 0; i < decoded.size; ++i) {
            this.setStackDirectly(i, decoded.keys[i], decoded.amounts[i]);
        }
    }

    private void ensureInIndex(IStackKey<?> key) {
        if (key != null && key != EmptyStackKey.INSTANCE && !this.key2stackMap.containsKey(key)) {
            this.key2stackMap.put(key, key.copyStack());
        }
    }

    private void removeFromIndex(IStackKey<?> key) {
        boolean stillPresent;
        if (key == null || key == EmptyStackKey.INSTANCE) {
            return;
        }
        SlotBucket kb = this.keyBuckets.get(key);
        boolean bl = stillPresent = kb != null && kb.size() > 0;
        if (!stillPresent) {
            if (kb != null && kb.size() == 0) {
                this.keyBuckets.remove(key);
            }
            this.key2stackMap.remove(key);
        }
    }

    @Nullable
    public Object getOutStackByKey(IStackKey<?> key) {
        return key == null || key == EmptyStackKey.INSTANCE ? null : this.key2stackMap.get(key);
    }

    public static final class SlotBucket {
        final ArrayList<Integer> slots = new ArrayList();
        final HashMap<Integer, Integer> pos = new HashMap();

        void add(int slot) {
            if (this.pos.containsKey(slot)) {
                return;
            }
            int i = this.slots.size();
            this.slots.add(slot);
            this.pos.put(slot, i);
        }

        void remove(int slot) {
            Integer p = this.pos.remove(slot);
            if (p == null) {
                return;
            }
            int last = this.slots.size() - 1;
            if (p != last) {
                int tail = this.slots.get(last);
                this.slots.set(p, tail);
                this.pos.put(tail, p);
            }
            this.slots.remove(last);
        }

        public int size() {
            return this.slots.size();
        }

        public int get(int i) {
            return this.slots.get(i);
        }

        List<Integer> snapshot() {
            return new ArrayList<Integer>(this.slots);
        }
    }
}

