/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.buuz135.industrialforegoingsouls.capabilities.ISoulHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.WardenSoulStackKey;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.minecraft.resources.ResourceLocation;

public class WardenSoulStackTypedHandler
implements ISoulHandler {
    private static final ResourceLocation SOUL_TYPE = WardenSoulStackKey.ID;
    private final StackHandler handlerStorage;

    public WardenSoulStackTypedHandler(StackHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    private int soulCount() {
        return this.handlerStorage.getBucket(SOUL_TYPE).map(StackHandler.SlotBucket::size).orElse(0);
    }

    private int emptyCount() {
        return this.handlerStorage.getBucket(EmptyStackKey.INSTANCE).map(StackHandler.SlotBucket::size).orElse(0);
    }

    private boolean inSoulRegion(int visibleSlot) {
        int souls = this.soulCount();
        return visibleSlot >= 0 && visibleSlot < souls;
    }

    private int getSoulSlotAt(int index) {
        if (index < 0) {
            return -1;
        }
        return this.handlerStorage.getBucket(SOUL_TYPE).map(b -> index < b.size() ? b.get(index) : -1).orElse(-1);
    }

    private int getEmptySlotAt(int index) {
        if (index < 0) {
            return -1;
        }
        return this.handlerStorage.getBucket(EmptyStackKey.INSTANCE).map(b -> index < b.size() ? b.get(index) : -1).orElse(-1);
    }

    private int resolveActualIndex(int visibleSlot) {
        if (visibleSlot < 0) {
            return -1;
        }
        int souls = this.soulCount();
        if (visibleSlot < souls) {
            return this.getSoulSlotAt(visibleSlot);
        }
        int rest = visibleSlot - souls;
        return this.getEmptySlotAt(rest);
    }

    public int getSoulTanks() {
        return this.soulCount() + this.emptyCount();
    }

    public int getSoulInTank(int slot) {
        if (!this.inSoulRegion(slot)) {
            return 0;
        }
        int actualIndex = this.resolveActualIndex(slot);
        if (actualIndex < 0) {
            return 0;
        }
        KeyAmount ka = this.handlerStorage.getStackBySlot(actualIndex);
        if (ka.isEmpty()) {
            return 0;
        }
        int shown = BDMath.clampLongToInt(ka.amount());
        return Math.max(shown, 0);
    }

    public int getTankCapacity(int slot) {
        int actualIndex = this.resolveActualIndex(slot);
        if (actualIndex < 0) {
            return 0;
        }
        return BDMath.clampLongToInt(this.handlerStorage.getSlotCapacity(actualIndex));
    }

    public int fill(int amount, ISoulHandler.Action action) {
        if (amount <= 0) {
            return 0;
        }
        long remaining = this.handlerStorage.insert(WardenSoulStackKey.INSTANCE, amount, action.simulate()).amount();
        return BDMath.clampLongToInt((long)amount - remaining);
    }

    public int drain(int amount, ISoulHandler.Action action) {
        if (amount <= 0) {
            return 0;
        }
        long taken = this.handlerStorage.extract(WardenSoulStackKey.INSTANCE, (long)amount, action.simulate()).amount();
        return BDMath.clampLongToInt(taken);
    }
}

