/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.wintercogs.beyonddimensions.Api.DataBase.LongType.EnergyType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackKeyRender;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackRender;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.LongStackKey;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyStackKey
extends LongStackKey<EnergyType> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/energy");
    public static final EnergyStackKey INSTANCE = new EnergyStackKey();
    public static final MapCodec<EnergyStackKey> TYPE_CODEC = new MapCodec<EnergyStackKey>(){

        public <T> DataResult<EnergyStackKey> decode(DynamicOps<T> ops, MapLike<T> input) {
            return DataResult.success((Object)INSTANCE);
        }

        public <T> RecordBuilder<T> encode(EnergyStackKey value, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return prefix;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.empty();
        }
    };
    public static final Codec<EnergyStackKey> CODEC = TYPE_CODEC.codec();

    private EnergyStackKey() {
        this.stack = new EnergyType(0L);
    }

    @Override
    public MapCodec<EnergyStackKey> codec() {
        return TYPE_CODEC;
    }

    @Override
    @Nullable
    public KeyAmount fromStackObject(Object stack) {
        if (stack instanceof EnergyType) {
            EnergyType energyType = (EnergyType)stack;
            return new KeyAmount(INSTANCE, energyType.getStackCount());
        }
        return null;
    }

    @Override
    public ResourceLocation getTypeID() {
        return ID;
    }

    @Nullable
    public EnergyStackKey fromSourceObject(Object key, DataComponentPatch ignored) {
        if (key instanceof EnergyType || key instanceof Number) {
            return INSTANCE;
        }
        return null;
    }

    @Override
    @NotNull
    public EnergyType getSource() {
        return (EnergyType)this.stack;
    }

    @Override
    public String getModId() {
        return "NeoForge";
    }

    public EnergyStackKey getEmpty() {
        return INSTANCE;
    }

    @Override
    public EnergyType getEmptyStack() {
        return new EnergyType(0L);
    }

    @Override
    public boolean hasTag(TagKey<?> tagKey) {
        return false;
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
    }

    @NotNull
    public EnergyStackKey deserialize(RegistryFriendlyByteBuf buf) {
        return INSTANCE;
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        return new CompoundTag();
    }

    @NotNull
    public EnergyStackKey deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        return INSTANCE;
    }

    @Override
    @NotNull
    public IStackRender getRender() {
        return EnergyStackKeyRender.INSTANCE;
    }
}

