/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.Api.DataBase.LongType.EnergyType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackRender;
import com.wintercogs.beyonddimensions.Render.IngredientRenderer;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.ClientTooltipFlag;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.Nullable;

public class EnergyStackKeyRender
implements IStackRender {
    public static final EnergyStackKeyRender INSTANCE = new EnergyStackKeyRender();

    private EnergyStackKeyRender() {
    }

    @Override
    public void render(GuiGraphics gui, IStackKey<?> key, int x, int y) {
        TextureAtlasSprite sprite;
        PoseStack pose = gui.pose();
        pose.pushPose();
        ResourceLocation still = IClientFluidTypeExtensions.of((Fluid)Fluids.WATER).getStillTexture();
        TextureAtlasSprite textureAtlasSprite = sprite = still == null ? null : (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(still);
        if (sprite != null && sprite.atlasLocation() != MissingTextureAtlasSprite.getLocation()) {
            int tint = 5304718;
            IngredientRenderer.drawTiledSprite(gui, 16, 16, tint, 16L, sprite, x, y);
        }
        pose.popPose();
    }

    @Override
    public void renderAmount(GuiGraphics gui, long amount, int x, int y) {
        String text = this.getCountText(amount);
        if (text.isEmpty()) {
            return;
        }
        float scale = 0.666f;
        PoseStack pose = gui.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 200.0f);
        pose.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int w = Minecraft.getInstance().font.width(text);
        int X = (int)(((float)(x - 1) + 16.0f + 2.0f - (float)w * 0.666f) / 0.666f);
        int Y = (int)(((float)(y - 1) + 16.0f - 3.33f) / 0.666f);
        gui.drawString(Minecraft.getInstance().font, text, X, Y, 0xFFFFFF);
        pose.popPose();
    }

    @Override
    public String getCountText(long count) {
        if (count < 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public Component getDisplayName(IStackKey<?> key) {
        return ((EnergyType)EnergyStackKey.INSTANCE.getRenderStack()).getName();
    }

    @Override
    public List<Component> getTooltipLines(IStackKey<?> key, long amount, Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        return List.of(this.getDisplayName(key), Component.translatable((String)"istack.beyonddimensions.storage_num.long_type", (Object[])new Object[]{amount}));
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(IStackKey<?> key) {
        return Optional.empty();
    }

    @Override
    public void renderTooltip(GuiGraphics gui, Font font, IStackKey<?> key, long amount, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getInstance();
        Item.TooltipContext ctx = mc.level != null ? Item.TooltipContext.of((Level)mc.level) : Item.TooltipContext.EMPTY;
        gui.renderTooltip(mc.font, this.getTooltipLines(key, amount, ctx, (Player)mc.player, ClientTooltipFlag.of((TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL))), this.getTooltipImage(key), ItemStack.EMPTY, mouseX, mouseY);
    }
}

