/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackRender;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.ClientTooltipFlag;
import org.jetbrains.annotations.Nullable;

public class ItemStackKeyRender
implements IStackRender {
    public static final ItemStackKeyRender INSTANCE = new ItemStackKeyRender();

    @Override
    public void render(GuiGraphics gui, IStackKey<?> key, int x, int y) {
        if (key instanceof ItemStackKey) {
            ItemStackKey itemKey = (ItemStackKey)key;
            PoseStack poseStack = gui.pose();
            poseStack.pushPose();
            ItemStack renderStack = itemKey.getRenderStack();
            gui.renderFakeItem(renderStack, x, y);
            gui.renderItemDecorations(Minecraft.getInstance().font, renderStack, x, y, "");
            poseStack.popPose();
        }
    }

    @Override
    public void renderAmount(GuiGraphics gui, long amount, int x, int y) {
        String countText = this.getCountText(amount);
        if (countText.isEmpty()) {
            return;
        }
        float scale = 0.666f;
        PoseStack poseStackText = gui.pose();
        poseStackText.pushPose();
        poseStackText.translate(0.0f, 0.0f, 200.0f);
        poseStackText.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int X = (int)(((float)(x + -1) + 16.0f + 2.0f - (float)Minecraft.getInstance().font.width(countText) * 0.666f) * 1.0f / 0.666f);
        int Y = (int)(((float)(y + -1) + 16.0f - 3.33f) * 1.0f / 0.666f);
        gui.drawString(Minecraft.getInstance().font, countText, X, Y, 0xFFFFFF);
        poseStackText.popPose();
    }

    @Override
    public String getCountText(long count) {
        if (count < 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public Component getDisplayName(IStackKey<?> key) {
        if (key instanceof ItemStackKey) {
            ItemStackKey itemKey = (ItemStackKey)key;
            ItemStack renderStack = itemKey.getRenderStack();
            return renderStack.getDisplayName();
        }
        return Component.empty();
    }

    @Override
    public List<Component> getTooltipLines(IStackKey<?> key, long amount, Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        if (key instanceof ItemStackKey) {
            ItemStackKey itemKey = (ItemStackKey)key;
            ItemStack renderStack = itemKey.getRenderStack();
            List tooltips = renderStack.getTooltipLines(tooltipContext, player, tooltipFlag);
            tooltips.add(Component.translatable((String)"istack.beyonddimensions.storage_num.item", (Object[])new Object[]{amount}));
            return tooltips;
        }
        return new ArrayList<Component>();
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(IStackKey<?> key) {
        if (key instanceof ItemStackKey) {
            ItemStackKey itemKey = (ItemStackKey)key;
            ItemStack renderStack = itemKey.getRenderStack();
            return renderStack.getTooltipImage();
        }
        return Optional.empty();
    }

    @Override
    public void renderTooltip(GuiGraphics gui, Font font, IStackKey<?> key, long amount, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        Item.TooltipContext ctx = minecraft.level != null ? Item.TooltipContext.of((Level)minecraft.level) : Item.TooltipContext.EMPTY;
        gui.renderTooltip(minecraft.font, this.getTooltipLines(key, amount, ctx, (Player)minecraft.player, ClientTooltipFlag.of((TooltipFlag)(minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL))), this.getTooltipImage(key), ItemStack.EMPTY, mouseX, mouseY);
    }
}

