/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.wintercogs.beyonddimensions.Api.DataBase.LongType.LongType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class LongStackKey<T extends LongType<T>>
implements IStackKey<T> {
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    protected T stack;
    protected int hashCodeCache = 0;

    public abstract ResourceLocation getTypeID();

    @Override
    public ResourceLocation getTypeId() {
        return this.getTypeID();
    }

    @Override
    public T getReadOnlyStack() {
        ((LongType)this.stack).setStackCount(1L);
        return this.stack;
    }

    @Override
    @NotNull
    public T getRenderStack() {
        ((LongType)this.stack).setStackCount(1L);
        return this.stack;
    }

    @Override
    public Class<T> getStackClass() {
        return this.stack.getClass();
    }

    @Override
    public Class<?> getSourceClass() {
        return this.stack.getClass();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public T copyStack() {
        return (T)this.copyStackWithCount(1L);
    }

    @Override
    public T copyStackWithCount(long count) {
        return (T)((LongType)this.stack).copyWithAmount(count);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean isSame(IStackKey<?> other) {
        return other != null && Objects.equals(other.getTypeId(), this.getTypeId());
    }

    @Override
    public boolean isSameTypeSameComponents(IStackKey<?> other) {
        return this.isSame(other);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IStackKey)) {
            return false;
        }
        IStackKey k = (IStackKey)o;
        return Objects.equals(k.getTypeId(), this.getTypeId());
    }

    @Override
    public int hashCode() {
        if (this.hashCodeCache == 0) {
            this.hashCodeCache = 31 + Objects.hashCode(this.getTypeId());
        }
        return this.hashCodeCache;
    }
}

