/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Block.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class NetedBlock
extends Block {
    public NetedBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            DimensionsNet net;
            NetedBlockEntity blockEntity;
            BlockEntity blockEntity2;
            Player player = (Player)placer;
            if (!level.isClientSide() && (blockEntity2 = level.getBlockEntity(pos)) instanceof NetedBlockEntity && (blockEntity = (NetedBlockEntity)blockEntity2).getNetId() == -1 && (net = DimensionsNet.getNetFromPlayer(player)) != null && net.isManager(player)) {
                blockEntity.setNetId(net.getId());
                level.invalidateCapabilities(pos);
                player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.block_net_bound", (Object[])new Object[]{net.getId()}));
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!player.getMainHandItem().isEmpty() || !player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof NetedBlockEntity) {
            NetedBlockEntity blockEntity2 = (NetedBlockEntity)blockEntity;
            if (blockEntity2.getNetId() < 0) {
                net = DimensionsNet.getNetFromPlayer(player);
                if (net != null) {
                    if (net.isManager(player)) {
                        blockEntity2.setNetId(net.getId());
                        level.invalidateCapabilities(pos);
                        level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 0.5f, 1.0f);
                        player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.block_net_bound", (Object[])new Object[]{net.getId()}));
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.no_right_to_bound_block"));
                    }
                }
            } else {
                net = DimensionsNet.getNetFromPlayer(player);
                if (net != null && (net.getId() == blockEntity2.getNetId() || DimensionsNet.getNetFromId(blockEntity2.getNetId()) == null)) {
                    if (net.isManager(player)) {
                        player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.block_net_unbound", (Object[])new Object[]{blockEntity2.getNetId()}));
                        blockEntity2.setNetId(-1);
                        level.invalidateCapabilities(pos);
                        level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 0.5f, 1.0f);
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.no_right_to_bound_block"));
                    }
                }
            }
        }
        return InteractionResult.SUCCESS;
    }
}

