/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.Machine.BaseMachine;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BaseMachineBlockEntity
extends NetedBlockEntity
implements BaseMachine {
    public RedStoneControlMode controlMode = RedStoneControlMode.IGNORE;
    public int stepTick = 0;

    public BaseMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BaseMachineBlockEntity blockEntity) {
        if (level.isClientSide()) {
            return;
        }
        blockEntity.working();
    }

    @Override
    public RedStoneControlMode getControlMode() {
        return this.controlMode;
    }

    @Override
    public boolean hasRedStoneSignal() {
        return this.level.getBestNeighborSignal(this.worldPosition) > 0;
    }

    @Override
    public int getStepTick() {
        return this.stepTick;
    }

    @Override
    public void setStepTick(int newTick) {
        this.stepTick = newTick;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.controlMode = RedStoneControlMode.valueOf(tag.getString("control_mode"));
        this.stepTick = tag.getInt("step_tick");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("control_mode", this.controlMode.name());
        tag.putInt("step_tick", this.stepTick);
    }
}

