/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.platform.InputConstants;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Packet.BatchTransferPacket;
import com.wintercogs.beyonddimensions.Packet.CallSeverClickPacket;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public abstract class BDBaseGUI<T extends BDBaseMenu>
extends AbstractContainerScreen<T> {
    ItemStack lastInvClickedStack = ItemStack.EMPTY;
    ItemStackKey lastStorageClickedStack = ItemStackKey.EMPTY;
    int lastInvClickedSlot = -1;
    int cleanHold = 10;

    public BDBaseGUI(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (((BDBaseMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            Slot slot = this.hoveredSlot;
            if (slot instanceof AbstractStackTypedSlot) {
                AbstractStackTypedSlot sSlot = (AbstractStackTypedSlot)slot;
                KeyAmount stack = sSlot.getStack();
                stack.key().getRender().renderTooltip(guiGraphics, this.minecraft.font, stack.key(), stack.amount(), mouseX, mouseY);
            } else {
                ItemStack itemstack = this.hoveredSlot.getItem();
                guiGraphics.renderTooltip(this.font, this.getTooltipFromContainerItem(itemstack), itemstack.getTooltipImage(), itemstack, mouseX, mouseY);
            }
        }
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        if (slot instanceof AbstractStackTypedSlot) {
            AbstractStackTypedSlot sSlot = (AbstractStackTypedSlot)slot;
            int x = slot.x;
            int y = slot.y;
            KeyAmount stack = sSlot.getStack();
            if (stack.key().isEmpty()) {
                return;
            }
            stack.key().getRender().render(guiGraphics, stack.key(), x, y);
            stack.key().getRender().renderAmount(guiGraphics, stack.amount(), x, y);
        } else {
            super.renderSlot(guiGraphics, slot);
        }
    }

    protected void containerTick() {
        super.containerTick();
        if (this.cleanHold > 0) {
            --this.cleanHold;
        } else {
            this.lastInvClickedStack = ItemStack.EMPTY;
            this.lastStorageClickedStack = ItemStackKey.EMPTY;
            this.lastInvClickedSlot = -1;
            this.cleanHold = 10;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        GuiEventListener focused = this.getFocused();
        if (focused != null && this.isDragging() && focused.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        Slot slot = this.findSlot(mouseX, mouseY);
        if (slot instanceof AbstractStackTypedSlot) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        GuiEventListener focused = this.getFocused();
        if (focused != null && focused.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected void slotClicked(Slot slot, int slotIndex, int mouseButton, ClickType type) {
        if (!(slot instanceof AbstractStackTypedSlot)) {
            super.slotClicked(slot, slotIndex, mouseButton, type);
        }
        if (slot == null) {
            return;
        }
        int slotId = slot.index;
        if (BDBaseGUI.hasShiftDown()) {
            KeyAmount clickItem;
            if (slot instanceof AbstractStackTypedSlot) {
                IStackKey<?> iStackKey;
                AbstractStackTypedSlot sSlot = (AbstractStackTypedSlot)slot;
                clickItem = sSlot.getVanillaActualStack();
                if (!this.lastStorageClickedStack.isEmpty() && this.lastStorageClickedStack.equals(clickItem.key())) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new BatchTransferPacket(clickItem, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (!clickItem.isEmpty() && (iStackKey = clickItem.key()) instanceof ItemStackKey) {
                    ItemStackKey itemStackKey;
                    this.lastStorageClickedStack = itemStackKey = (ItemStackKey)iStackKey;
                }
            } else {
                clickItem = new KeyAmount(new ItemStackKey(slot.getItem()), slot.getItem().getCount());
                if (this.lastInvClickedSlot == slotId && !this.lastInvClickedStack.isEmpty()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new BatchTransferPacket(new KeyAmount(new ItemStackKey(this.lastInvClickedStack), this.lastInvClickedStack.getCount()), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (((BDBaseMenu)this.menu).inventoryStartIndex <= slotId && slotId < ((BDBaseMenu)this.menu).inventoryEndIndex) {
                    this.lastInvClickedStack = slot.getItem();
                    this.lastInvClickedSlot = slotId;
                }
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new CallSeverClickPacket(slotId, clickItem, mouseButton, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (slot instanceof AbstractStackTypedSlot) {
            AbstractStackTypedSlot sSlot = (AbstractStackTypedSlot)slot;
            if (sSlot.isFake()) {
                KeyAmount clickItem = sSlot.getVanillaActualStack();
                PacketDistributor.sendToServer((CustomPacketPayload)new CallSeverClickPacket(slotId, clickItem, mouseButton, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                KeyAmount clickItem = sSlot.getVanillaActualStack();
                PacketDistributor.sendToServer((CustomPacketPayload)new CallSeverClickPacket(slotId, clickItem, mouseButton, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    protected boolean checkHotbarKeyPressed(int keyCode, int scanCode) {
        if (((BDBaseMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null) {
            Slot slot = this.hoveredSlot;
            if (slot instanceof AbstractStackTypedSlot) {
                AbstractStackTypedSlot sSlot = (AbstractStackTypedSlot)slot;
            } else {
                if (this.minecraft.options.keySwapOffhand.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
                    this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, 40, ClickType.SWAP);
                    return true;
                }
                for (int i = 0; i < 9; ++i) {
                    if (!this.minecraft.options.keyHotbarSlots[i].isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) continue;
                    this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, i, ClickType.SWAP);
                    return true;
                }
            }
        }
        return false;
    }

    public Font getFont() {
        return this.font;
    }
}

