/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI.SharedWidget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.GUI.SharedWidget.GuiElementAccess;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IconButton
extends Button
implements GuiElementAccess {
    protected ResourceLocation icon;
    protected final int iconX;
    protected final int iconY;
    protected final int iconWidth;
    protected final int iconHeight;
    protected WidgetSprites backgroundSprites = new WidgetSprites(ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/slot_button"), ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/slot_button_disabled"), ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/slot_button_hovered"));

    public IconButton(int x, int y, int width, int height, ResourceLocation icon, int iconX, int iconY, int iconWidth, int iconHeight, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.icon = icon;
        this.iconX = iconX;
        this.iconY = iconY;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.initBackground();
    }

    public IconButton(int x, int y, int width, int height, ResourceLocation icon, Button.OnPress onPress) {
        this(x, y, width, height, icon, x, y, width, height, onPress);
    }

    public void renderWidget(GuiGraphics st, int mouseX, int mouseY, float pt) {
        if (this.visible) {
            int x = this.getX();
            int y = this.getY();
            st.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.isHovered = mouseX >= x && mouseY >= y && mouseX < x + this.width && mouseY < y + this.height;
            st.blitSprite(this.backgroundSprites.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            this.drawIcon(st, mouseX, mouseY, pt);
            st.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void onRelease(double mouseX, double mouseY) {
        this.setFocused(false);
    }

    protected void drawIcon(GuiGraphics st, int mouseX, int mouseY, float pt) {
        st.blitSprite(this.getIcon(), this.iconX, this.iconY, this.iconWidth, this.iconHeight);
    }

    public void initBackground() {
    }

    public void setBackgroundSprites(WidgetSprites backgroundSprites) {
        this.backgroundSprites = backgroundSprites;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public void setIcon(ResourceLocation icon) {
        this.icon = icon;
    }

    @Override
    public Rect2i getElementArea() {
        return new Rect2i(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }
}

