/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Fluid.ModFluids;
import com.wintercogs.beyonddimensions.Item.Custom.BaseMachineItem;
import com.wintercogs.beyonddimensions.Item.Custom.NetedItem;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Machine.HopperFluidMode;
import com.wintercogs.beyonddimensions.Machine.HopperItemMode;
import com.wintercogs.beyonddimensions.Machine.HopperNBTMode;
import com.wintercogs.beyonddimensions.Machine.HopperRangeMode;
import com.wintercogs.beyonddimensions.Machine.HopperXpMode;
import com.wintercogs.beyonddimensions.Menu.NetMagnetMenu;
import com.wintercogs.beyonddimensions.Unit.ItemStackHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class NetMagnetItem
extends BaseMachineItem {
    public static final int capacity = 36;

    public NetMagnetItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        super.use(level, player, usedHand);
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND || player.isShiftKeyDown()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (!level.isClientSide()) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, inv, ServerPlayer2) -> new NetMagnetMenu(containerId, inv, itemstack), (Component)Component.translatable((String)"menu.title.beyonddimensions.magnet_menu")), buf -> buf.writeEnum((Enum)usedHand));
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    @Override
    public void checkComponents(ItemStack stack) {
        super.checkComponents(stack);
        if (!stack.has(ModDataComponents.ISTACK_SLOTS)) {
            stack.set(ModDataComponents.ISTACK_SLOTS, new ArrayList<KeyAmount>(Collections.nCopies(36, new KeyAmount(ItemStackKey.EMPTY, 0L))));
        }
        if (!stack.has(ModDataComponents.FILTER_MODE)) {
            stack.set(ModDataComponents.FILTER_MODE, (Object)FilterMode.BLACK);
        }
        if (!stack.has(ModDataComponents.HOPPER_ITEM_MODE)) {
            stack.set(ModDataComponents.HOPPER_ITEM_MODE, (Object)HopperItemMode.ALLOW);
        }
        if (!stack.has(ModDataComponents.HOPPER_XP_MODE)) {
            stack.set(ModDataComponents.HOPPER_XP_MODE, (Object)HopperXpMode.DENY);
        }
        if (!stack.has(ModDataComponents.HOPPER_NBT_MODE)) {
            stack.set(ModDataComponents.HOPPER_NBT_MODE, (Object)HopperNBTMode.DENY);
        }
        if (!stack.has(ModDataComponents.HOPPER_FLUID_MODE)) {
            stack.set(ModDataComponents.HOPPER_FLUID_MODE, (Object)HopperFluidMode.DENY);
        }
        if (!stack.has(ModDataComponents.HOPPER_RANGE_MODE)) {
            stack.set(ModDataComponents.HOPPER_RANGE_MODE, (Object)HopperRangeMode.RADIUS_MID);
        }
    }

    @Override
    public boolean shouldWork(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        return super.shouldWork(stack, level, holder, slotId, isSelected) && NetedItem.getNet(stack) != null;
    }

    @Override
    public void workContent(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        super.workContent(stack, level, holder, slotId, isSelected);
        FilterMode filterMode = (FilterMode)((Object)stack.getOrDefault(ModDataComponents.FILTER_MODE, (Object)FilterMode.BLACK));
        HopperItemMode hopperItemMode = (HopperItemMode)((Object)stack.getOrDefault(ModDataComponents.HOPPER_ITEM_MODE, (Object)HopperItemMode.ALLOW));
        HopperXpMode hopperXpMode = (HopperXpMode)((Object)stack.getOrDefault(ModDataComponents.HOPPER_XP_MODE, (Object)HopperXpMode.DENY));
        HopperNBTMode hopperNBTMode = (HopperNBTMode)((Object)stack.getOrDefault(ModDataComponents.HOPPER_NBT_MODE, (Object)HopperNBTMode.DENY));
        HopperFluidMode hopperFluidMode = (HopperFluidMode)((Object)stack.getOrDefault(ModDataComponents.HOPPER_FLUID_MODE, (Object)HopperFluidMode.DENY));
        HopperRangeMode hopperRangeMode = (HopperRangeMode)((Object)stack.getOrDefault(ModDataComponents.HOPPER_RANGE_MODE, (Object)HopperRangeMode.RADIUS_MID));
        List filterSlots = (List)stack.getOrDefault(ModDataComponents.ISTACK_SLOTS, new ArrayList());
        AABB searchArea = this.getSearchArea(hopperRangeMode, level, (Vec3i)holder.getOnPos());
        ArrayList itemEntities = hopperItemMode == HopperItemMode.ALLOW ? this.refreshItemEntityCache(hopperNBTMode, level, searchArea) : new ArrayList();
        List<Object> xpEntities = hopperXpMode == HopperXpMode.ALLOW ? this.refreshXpEntityCache(level, searchArea) : new ArrayList();
        UnifiedStorage storage = NetedItem.getNet(stack).getUnifiedStorage();
        if (hopperItemMode == HopperItemMode.ALLOW) {
            for (ItemEntity itemEntity : itemEntities) {
                ItemStack itemStack;
                ItemStackKey itemKey;
                if (itemEntity == null || itemEntity.isRemoved() || !this.matchesFilter(filterMode, filterSlots, itemKey = new ItemStackKey(itemStack = itemEntity.getItem())) || !storage.insert(itemKey, itemStack.getCount(), true).isEmpty()) continue;
                itemEntity.discard();
                storage.insert(itemKey, itemStack.getCount(), false);
            }
        }
        if (hopperXpMode == HopperXpMode.ALLOW) {
            for (ExperienceOrb experienceOrb : xpEntities) {
                int xp;
                if (experienceOrb == null || experienceOrb.isRemoved() || (xp = experienceOrb.getValue()) <= 0) continue;
                long xpFluid = (long)xp * 20L;
                FluidStackKey xpStack = new FluidStackKey(new FluidStack(ModFluids.XP_FLUID.source(), 1));
                if (!storage.insert(xpStack, xpFluid, true).isEmpty()) continue;
                experienceOrb.discard();
                storage.insert(xpStack, xpFluid, false);
            }
        }
        if (hopperFluidMode == HopperFluidMode.ALLOW) {
            this.fluidCollect(filterMode, filterSlots, storage, level, searchArea);
        }
    }

    @Override
    public int getTicksPerWork(ItemStack stack, Level level, Entity holder, int slotId, boolean isSelected) {
        HopperRangeMode hopperRangeMode = (HopperRangeMode)((Object)stack.getOrDefault(ModDataComponents.HOPPER_RANGE_MODE, (Object)HopperRangeMode.RADIUS_MID));
        HopperFluidMode hopperFluidMode = (HopperFluidMode)((Object)stack.getOrDefault(ModDataComponents.HOPPER_FLUID_MODE, (Object)HopperFluidMode.DENY));
        if (hopperFluidMode == HopperFluidMode.ALLOW) {
            return switch (hopperRangeMode) {
                default -> throw new MatchException(null, null);
                case HopperRangeMode.RADIUS_LOWEST -> 0;
                case HopperRangeMode.RADIUS_LOW -> 0;
                case HopperRangeMode.RADIUS_MID -> 10;
                case HopperRangeMode.RADIUS_HIGH -> 20;
                case HopperRangeMode.RADIUS_HIGHEST -> 50;
                case HopperRangeMode.CHUNK_MODE -> 1200;
            };
        }
        return switch (hopperRangeMode) {
            default -> throw new MatchException(null, null);
            case HopperRangeMode.RADIUS_LOWEST -> 0;
            case HopperRangeMode.RADIUS_LOW -> 0;
            case HopperRangeMode.RADIUS_MID -> 2;
            case HopperRangeMode.RADIUS_HIGH -> 5;
            case HopperRangeMode.RADIUS_HIGHEST -> 10;
            case HopperRangeMode.CHUNK_MODE -> 1200;
        };
    }

    private AABB getSearchArea(HopperRangeMode hopperRangeMode, Level level, Vec3i pos) {
        if (hopperRangeMode != HopperRangeMode.CHUNK_MODE) {
            int radius = switch (hopperRangeMode) {
                case HopperRangeMode.RADIUS_LOWEST -> 2;
                case HopperRangeMode.RADIUS_LOW -> 3;
                case HopperRangeMode.RADIUS_MID -> 5;
                case HopperRangeMode.RADIUS_HIGH -> 7;
                case HopperRangeMode.RADIUS_HIGHEST -> 10;
                default -> 1;
            };
            return new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        }
        int chunkX = SectionPos.blockToSectionCoord((int)pos.getX());
        int chunkZ = SectionPos.blockToSectionCoord((int)pos.getZ());
        int minX = chunkX << 4;
        int maxX = minX + 15;
        int minZ = chunkZ << 4;
        int maxZ = minZ + 15;
        int minY = level.getMinBuildHeight();
        int maxY = level.getMaxBuildHeight();
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private List<ItemEntity> refreshItemEntityCache(HopperNBTMode hopperNBTMode, Level level, AABB searchArea) {
        return level.getEntitiesOfClass(ItemEntity.class, searchArea, itemEntity -> {
            if (hopperNBTMode == HopperNBTMode.DENY) {
                return !ItemStackHelper.hasExtraComponents(itemEntity.getItem());
            }
            return true;
        });
    }

    private List<ExperienceOrb> refreshXpEntityCache(Level level, AABB searchArea) {
        return level.getEntitiesOfClass(ExperienceOrb.class, searchArea, orb -> true);
    }

    private void fluidCollect(FilterMode filterMode, List<KeyAmount> filterSlots, UnifiedStorage storage, Level level, AABB searchArea) {
        int minX = Mth.floor((double)searchArea.minX);
        int minY = Mth.floor((double)searchArea.minY);
        int minZ = Mth.floor((double)searchArea.minZ);
        int maxX = Mth.floor((double)searchArea.maxX);
        int maxY = Mth.floor((double)searchArea.maxY);
        int maxZ = Mth.floor((double)searchArea.maxZ);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    FluidStack extracted;
                    FluidStackKey fluidKey;
                    pos.set(x, y, z);
                    FluidState fluidState = level.getFluidState((BlockPos)pos);
                    if (fluidState.isEmpty()) continue;
                    int amount = fluidState.isSource() ? 1000 : 0;
                    Fluid stillFluid = fluidState.getType();
                    if (stillFluid instanceof FlowingFluid) {
                        FlowingFluid ff = (FlowingFluid)stillFluid;
                        stillFluid = ff.getSource();
                    }
                    if (!this.matchesFilter(filterMode, filterSlots, fluidKey = new FluidStackKey(extracted = new FluidStack(stillFluid, 1))) || !storage.insert(fluidKey, amount, true).isEmpty()) continue;
                    storage.insert(fluidKey, amount, false);
                    level.setBlock((BlockPos)pos, Blocks.AIR.defaultBlockState(), 11);
                }
            }
        }
    }

    private boolean matchesFilter(FilterMode filterMode, List<KeyAmount> filterSlots, IStackKey<?> otherStack) {
        switch (filterMode) {
            case BLACK: {
                for (KeyAmount stack : filterSlots) {
                    if (!stack.key().isSame(otherStack)) continue;
                    return false;
                }
                return true;
            }
            case WHITE: {
                for (KeyAmount stack : filterSlots) {
                    if (!stack.key().isSame(otherStack)) continue;
                    return true;
                }
                return false;
            }
            case IGNORE: {
                return true;
            }
        }
        return false;
    }
}

