/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Item.Custom;

import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Fluid.ModFluids;
import com.wintercogs.beyonddimensions.Machine.XpTransferSpeedMode;
import com.wintercogs.beyonddimensions.Tags.ModFluidTags;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.XpUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class XpExchangeItem
extends Item {
    public static List<Fluid> xpFluids = new ArrayList<Fluid>();

    public XpExchangeItem(Item.Properties properties) {
        super(properties.stacksTo(1).component(ModDataComponents.XP_TRANSFER_SPEED_MODE, (Object)XpTransferSpeedMode.SLOW));
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (xpFluids.isEmpty()) {
            xpFluids = this.getExperienceFluids(level);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.isClientSide() && ((Boolean)stack.getOrDefault(ModDataComponents.XP_NET_KEEP_MODE, (Object)false)).booleanValue()) {
                this.keepXpLevel(stack, player, level);
            }
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.beyonddimensions.item.xp_exchange"));
    }

    public static int getConversionRate() {
        return 20;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        super.use(level, player, usedHand);
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (usedHand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (level.isClientSide() && player.isShiftKeyDown()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (!level.isClientSide()) {
            if (player.isShiftKeyDown()) {
                XpExchangeItem.cycleMode(itemstack, player, level);
            } else {
                boolean current = (Boolean)itemstack.getOrDefault(ModDataComponents.XP_NET_KEEP_MODE, (Object)false);
                itemstack.set(ModDataComponents.XP_NET_KEEP_MODE, (Object)(!current ? 1 : 0));
                if (((Boolean)itemstack.getOrDefault(ModDataComponents.XP_NET_KEEP_MODE, (Object)false)).booleanValue()) {
                    player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.item.xp_exchange.open"));
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"msg.beyonddimensions.item.xp_exchange.close"));
                }
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    private void keepXpLevel(ItemStack stack, Player player, Level level) {
        if (level.isClientSide()) {
            return;
        }
        DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
        if (net == null) {
            return;
        }
        int conversionRate = XpExchangeItem.getConversionRate();
        double currentLevel = XpUtil.levelAsDouble(player);
        int targetLevel = XpExchangeItem.getXpLevelPerAction(stack);
        UnifiedStorage storage = net.getUnifiedStorage();
        Fluid canonicalXp = (Fluid)ModFluids.XP_FLUID.source().get();
        if (currentLevel > (double)targetLevel) {
            long needRemoveXp = XpUtil.xpExcessAbove(currentLevel, targetLevel);
            int toRemoveXp = BDMath.clampLongToInt(needRemoveXp);
            long toInsertUnits = (long)toRemoveXp * (long)conversionRate;
            KeyAmount remaining = storage.insert(new FluidStackKey(new FluidStack(canonicalXp, 1)), toInsertUnits, false);
            if (!remaining.isEmpty()) {
                int overflowXp = BDMath.clampLongToInt(remaining.amount() / (long)conversionRate);
                toRemoveXp -= overflowXp;
            }
            if (toRemoveXp != 0) {
                player.giveExperiencePoints(-toRemoveXp);
            }
        } else if (currentLevel < (double)targetLevel) {
            long needAddXp = XpUtil.xpToReachAtLeast(currentLevel, targetLevel);
            int remainingXp = BDMath.clampLongToInt(needAddXp);
            int gainedXpTotal = 0;
            for (Fluid f : xpFluids) {
                long wantUnits;
                if (remainingXp <= 0 || (wantUnits = (long)remainingXp * (long)conversionRate) <= 0L) break;
                KeyAmount extracted = storage.extract(new FluidStackKey(new FluidStack(f, 1)), wantUnits, false);
                if (extracted.isEmpty()) continue;
                long units = extracted.amount();
                int gainedXp = BDMath.clampLongToInt(units / (long)conversionRate);
                if (gainedXp <= 0) {
                    storage.insert(new FluidStackKey(new FluidStack(f, 1)), units, false);
                    continue;
                }
                long consumedUnits = (long)gainedXp * (long)conversionRate;
                long remainderUnits = units - consumedUnits;
                if (remainderUnits > 0L) {
                    storage.insert(new FluidStackKey(new FluidStack(f, 1)), remainderUnits, false);
                }
                gainedXpTotal += gainedXp;
                remainingXp -= gainedXp;
            }
            if (gainedXpTotal > 0) {
                player.giveExperiencePoints(gainedXpTotal);
            }
        }
    }

    private List<Fluid> getExperienceFluids(Level level) {
        Registry reg = level.registryAccess().registryOrThrow(Registries.FLUID);
        LinkedHashSet set = new LinkedHashSet();
        reg.getTag(ModFluidTags.C_EXPERIENCE).ifPresent(holders -> {
            for (Holder h : holders) {
                set.add((Fluid)h.value());
            }
        });
        return new ArrayList<Fluid>(set);
    }

    public static int getXpLevelPerAction(ItemStack stack) {
        if (stack.getItem() instanceof XpExchangeItem) {
            XpTransferSpeedMode xpMode = (XpTransferSpeedMode)((Object)stack.getOrDefault(ModDataComponents.XP_TRANSFER_SPEED_MODE, (Object)XpTransferSpeedMode.SLOW));
            return switch (xpMode) {
                default -> throw new MatchException(null, null);
                case XpTransferSpeedMode.SLOW -> 1;
                case XpTransferSpeedMode.MID -> 10;
                case XpTransferSpeedMode.HIGH -> 30;
                case XpTransferSpeedMode.HIGHEST -> 100;
                case XpTransferSpeedMode.OVER_HIGHEST -> 150;
            };
        }
        return 0;
    }

    private static void cycleMode(ItemStack stack, Player player, Level level) {
        XpTransferSpeedMode cur = (XpTransferSpeedMode)((Object)stack.getOrDefault(ModDataComponents.XP_TRANSFER_SPEED_MODE, (Object)XpTransferSpeedMode.SLOW));
        XpTransferSpeedMode next = cur.next();
        stack.set(ModDataComponents.XP_TRANSFER_SPEED_MODE, (Object)next);
        player.sendSystemMessage((Component)Component.translatable((String)("msg.beyonddimensions.xp_mode.switch." + next.name().toLowerCase(Locale.ENGLISH))));
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.8f, 1.0f);
    }
}

