/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Menu.Slot.DisorderedSlotGroupSync;
import com.wintercogs.beyonddimensions.Menu.Slot.SlotGroupSync;
import com.wintercogs.beyonddimensions.Packet.QuickDataTagPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.jetbrains.annotations.Nullable;

@IPNIgnore
public abstract class BDBaseMenu
extends AbstractContainerMenu {
    public final Player player;
    public int inventoryStartIndex = -1;
    public int inventoryEndIndex = -1;
    protected int vanillaQuickMoveStartIndex = -1;
    protected int vanillaQuickMoveEndIndex = -1;
    private boolean init = false;
    protected List<AbstractStackTypedSlot> updatedSlots = new ArrayList<AbstractStackTypedSlot>();
    public List<SlotGroupSync> slotGroupSyncs = new ArrayList<SlotGroupSync>();

    protected BDBaseMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory) {
        super(menuType, containerId);
        this.player = playerInventory.player;
    }

    protected void addSlotGroupSync(SlotGroupSync slotGroupSync) {
        this.slotGroupSyncs.add(slotGroupSync);
    }

    protected Slot addSlot(Slot slot) {
        if (slot instanceof AbstractStackTypedSlot) {
            AbstractStackTypedSlot sSlot = (AbstractStackTypedSlot)slot;
            this.updatedSlots.add(sSlot);
        }
        return super.addSlot(slot);
    }

    public void broadcastChanges() {
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (slot instanceof AbstractStackTypedSlot) continue;
            ItemStack itemstack = slot.getItem();
            Objects.requireNonNull(itemstack);
            Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).copy());
            this.triggerSlotListeners(i, itemstack, (java.util.function.Supplier)supplier);
            this.synchronizeSlotToRemote(i, itemstack, (java.util.function.Supplier)supplier);
        }
        this.synchronizeCarriedToRemote();
        for (int j = 0; j < this.dataSlots.size(); ++j) {
            DataSlot dataslot = (DataSlot)this.dataSlots.get(j);
            int k = dataslot.get();
            if (dataslot.checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners(j, k);
            }
            this.synchronizeDataSlotToRemote(j, k);
        }
        if (!this.player.level().isClientSide()) {
            if (!this.init) {
                this.initUpdate();
                this.init = true;
            }
            if (this.shouldSendQuickData()) {
                CompoundTag updateTag = new CompoundTag();
                this.writeQuickDataTag(updateTag);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new QuickDataTagPacket(updateTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.setSlotGroupSyncsUpdate();
            this.abstractSlotsUpdate();
            this.updateChange();
        }
    }

    protected boolean shouldSendQuickData() {
        return false;
    }

    protected void writeQuickDataTag(CompoundTag tag) {
    }

    public void readQuickDataTag(CompoundTag tag) {
    }

    public void writeAndSendQuickData() {
        CompoundTag updateTag = new CompoundTag();
        this.writeQuickDataTag(updateTag);
        if (this.player.level().isClientSide()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new QuickDataTagPacket(updateTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new QuickDataTagPacket(updateTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void abstractSlotsUpdate() {
        for (AbstractStackTypedSlot slot : this.updatedSlots) {
            slot.updateChange();
        }
    }

    protected void setSlotGroupSyncsUpdate() {
        for (SlotGroupSync slotGroupSync : this.slotGroupSyncs) {
            slotGroupSync.updateChange();
        }
    }

    protected void updateChange() {
    }

    protected void initUpdate() {
    }

    public void customClickHandler(int slotIndex, KeyAmount clickedStack, int button, boolean shiftDown) {
        Object object;
        if (this.inventoryStartIndex < 0 || this.inventoryEndIndex < 0) {
            BeyondDimensions.LOGGER.info("\u8b66\u544a:\u80cc\u5305\u7d22\u5f15\u8bbe\u7f6e\u9519\u8bef\uff01\uff01\uff01");
        }
        if ((object = this.slots.get(slotIndex)) instanceof AbstractStackTypedSlot) {
            AbstractStackTypedSlot slot = (AbstractStackTypedSlot)((Object)object);
            if (shiftDown) {
                slot.quickMove(clickedStack, button, this.player);
            } else {
                slot.click(clickedStack, button, this.player);
            }
        } else if (shiftDown && this.vanillaQuickMoveEndIndex >= 0 && this.vanillaQuickMoveStartIndex >= 0 && this.vanillaQuickMoveStartIndex < this.vanillaQuickMoveEndIndex) {
            this.quickMoveHandle(this.player, slotIndex, clickedStack, this.vanillaQuickMoveStartIndex, this.vanillaQuickMoveEndIndex);
        }
    }

    protected ItemStack quickMoveHandle(Player player, int slotIndex, KeyAmount clickStack, int targetStartIndex, int targetEndIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && !clickStack.isEmpty()) {
            if (slot instanceof ResultSlot) {
                ResultSlot resultSlot = (ResultSlot)slot;
                ItemStack cacheStack = slot.getItem().copy();
                for (int i = 0; !slot.getItem().isEmpty() && slot.getItem().getItem() == cacheStack.getItem() && i < slot.getItem().getMaxStackSize() / slot.getItem().getCount(); ++i) {
                    int newSize;
                    Slot targetSlot;
                    ItemStack remaining = cacheStack.copy();
                    HashMap<Integer, Integer> insertedToInv = new HashMap<Integer, Integer>();
                    HashMap<Integer, Integer> insertedToSlots = new HashMap<Integer, Integer>();
                    for (int invSlot = this.inventoryStartIndex; invSlot < this.inventoryEndIndex && !remaining.isEmpty(); ++invSlot) {
                        targetSlot = (Slot)this.slots.get(invSlot);
                        newSize = targetSlot.safeInsert(remaining.copy()).getCount();
                        if (remaining.getCount() - newSize != 0) {
                            insertedToInv.put(invSlot, remaining.getCount() - newSize);
                        }
                        remaining.setCount(newSize);
                    }
                    for (int targetSlotIndex = targetStartIndex; targetSlotIndex < targetEndIndex && !remaining.isEmpty(); ++targetSlotIndex) {
                        targetSlot = (Slot)this.slots.get(targetSlotIndex);
                        if (targetSlot instanceof AbstractStackTypedSlot) {
                            AbstractStackTypedSlot aTargetSlot = (AbstractStackTypedSlot)targetSlot;
                            newSize = (int)aTargetSlot.safeInsert(new ItemStackKey(remaining), (long)remaining.getCount()).amount();
                        } else {
                            newSize = targetSlot.safeInsert(remaining.copy()).getCount();
                        }
                        if (remaining.getCount() - newSize != 0) {
                            insertedToSlots.put(targetSlotIndex, remaining.getCount() - newSize);
                        }
                        remaining.setCount(newSize);
                    }
                    if (remaining.isEmpty()) {
                        resultSlot.onTake(player, slot.getItem().copy());
                        continue;
                    }
                    for (Map.Entry entry : insertedToInv.entrySet()) {
                        Slot afterSlot = (Slot)this.slots.get(((Integer)entry.getKey()).intValue());
                        afterSlot.safeTake(((Integer)entry.getValue()).intValue(), Integer.MAX_VALUE, player);
                    }
                    for (Map.Entry entry : insertedToSlots.entrySet()) {
                        Slot afterSlot = (Slot)this.slots.get(((Integer)entry.getKey()).intValue());
                        if (afterSlot instanceof AbstractStackTypedSlot) {
                            AbstractStackTypedSlot aSlot = (AbstractStackTypedSlot)afterSlot;
                            aSlot.safeExtract(new ItemStackKey(cacheStack), ((Integer)entry.getValue()).intValue());
                            continue;
                        }
                        afterSlot.safeTake(((Integer)entry.getValue()).intValue(), Integer.MAX_VALUE, player);
                    }
                }
            } else {
                ItemStack cacheStack = slot.getItem().copy();
                ItemStack remaining = cacheStack.copy();
                for (int targetSlotIndex = targetStartIndex; targetSlotIndex < targetEndIndex && !remaining.isEmpty(); ++targetSlotIndex) {
                    int newSize;
                    Slot targetSlot = (Slot)this.slots.get(targetSlotIndex);
                    if (targetSlot instanceof AbstractStackTypedSlot) {
                        AbstractStackTypedSlot aTargetSlot = (AbstractStackTypedSlot)targetSlot;
                        newSize = (int)aTargetSlot.safeInsert(new ItemStackKey(remaining), (long)remaining.getCount()).amount();
                    } else {
                        newSize = targetSlot.safeInsert(remaining).getCount();
                    }
                    remaining.setCount(newSize);
                }
                slot.tryRemove(cacheStack.getCount() - remaining.getCount(), Integer.MAX_VALUE, player);
            }
            slot.setChanged();
        }
        return ItemStack.EMPTY;
    }

    public void broadcastFullState() {
        super.broadcastFullState();
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        return ItemStack.EMPTY;
    }

    public boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return false;
    }

    public abstract boolean stillValid(Player var1);

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        if (!(slot instanceof AbstractStackTypedSlot)) {
            return super.canTakeItemForPickAll(stack, slot);
        }
        return false;
    }

    public void removed(Player player) {
        super.removed(player);
        for (SlotGroupSync slotGroupSync : this.slotGroupSyncs) {
            if (!(slotGroupSync instanceof DisorderedSlotGroupSync)) continue;
            DisorderedSlotGroupSync disSync = (DisorderedSlotGroupSync)slotGroupSync;
            disSync.dispose();
        }
    }
}

