/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Menu.Slot;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.Registry.CapabilityHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackHandlerWrapperHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackKeyRegistry;
import com.wintercogs.beyonddimensions.Fluid.ModFluids;
import com.wintercogs.beyonddimensions.Item.Custom.XpExchangeItem;
import com.wintercogs.beyonddimensions.Menu.BDBaseMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Packet.OrderedStackTypedSlotPacket;
import java.util.function.Function;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class FlagStackTypedSlot
extends AbstractStackTypedSlot {
    private KeyAmount lastStack = new KeyAmount(ItemStackKey.EMPTY, 0L);

    public FlagStackTypedSlot(BDBaseMenu menu, IStackHandler storage, int slotIndex, int xPosition, int yPosition) {
        super(menu, storage, slotIndex, xPosition, yPosition);
        this.setFake(true);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public void setStackDirectly(IStackKey<?> key, long amount) {
        this.storage.setStackDirectly(this.theSlot, key, amount);
    }

    @Override
    public KeyAmount safeInsert(IStackKey<?> key, long amount) {
        if (key != null) {
            this.setStackDirectly(key, amount);
        }
        return new KeyAmount(key, amount);
    }

    @Override
    public KeyAmount safeExtract(IStackKey<?> key, long amount) {
        this.setStackDirectly(ItemStackKey.EMPTY, amount);
        return new KeyAmount(ItemStackKey.EMPTY, amount);
    }

    @Override
    public void click(KeyAmount clickStack, int button, Player player) {
        ItemStack carriedItem = this.menu.getCarried().copy();
        if (clickStack.isEmpty()) {
            if (!carriedItem.isEmpty()) {
                if (button == 0) {
                    this.setStackDirectly(new ItemStackKey(carriedItem), 1L);
                } else if (button == 1) {
                    if (carriedItem.getItem() instanceof XpExchangeItem) {
                        this.setStackDirectly(new FluidStackKey(new FluidStack(ModFluids.XP_FLUID.source(), 1)), 1L);
                    } else {
                        ItemStack copy = carriedItem.copy();
                        copy.setCount(1);
                        CapabilityHelper.ItemCapabilityMap.forEach((typeId, cap) -> {
                            Function<?, IStackHandlerWrapper<?>> handlerGetter;
                            IStackHandlerWrapper<?> stackHandlerWrapper;
                            Object handler = copy.getCapability(cap);
                            if (handler != null && (stackHandlerWrapper = (handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId)).apply(handler)).getSlots() > 0) {
                                for (int index = 0; index < stackHandlerWrapper.getSlots(); ++index) {
                                    KeyAmount stack;
                                    IStackKey typeKey = StackKeyRegistry.getType(typeId);
                                    KeyAmount typeStack = typeKey.fromStackObject(stackHandlerWrapper.getStackInSlot(0));
                                    if (typeStack == null || (stack = new KeyAmount(typeStack.key(), 1L)).key() == null || stack.isEmpty()) continue;
                                    this.setStackDirectly(stack.key(), stack.amount());
                                    break;
                                }
                            }
                        });
                    }
                }
            }
        } else if (carriedItem.isEmpty()) {
            this.setStackDirectly(ItemStackKey.EMPTY, 0L);
        } else {
            this.setStackDirectly(ItemStackKey.EMPTY, 0L);
        }
    }

    @Override
    public void quickMove(KeyAmount clickStack, int button, Player player) {
        this.click(clickStack, button, player);
    }

    @Override
    public void updateChange() {
        KeyAmount currentStack = this.storage.getStackBySlot(this.getSlotIndex());
        if (currentStack.key() == null) {
            this.lastStack = new KeyAmount(ItemStackKey.EMPTY, 0L);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.menu.player), (CustomPacketPayload)new OrderedStackTypedSlotPacket(this.index, this.theSlot, this.lastStack.key(), this.lastStack.amount()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (!(currentStack.isEmpty() && this.lastStack.isEmpty() || this.lastStack.amount() == currentStack.amount() && this.lastStack.key().getTypeId().equals((Object)currentStack.key().getTypeId()) && this.lastStack.key().isSameTypeSameComponents(currentStack.key()))) {
            this.lastStack = currentStack;
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.menu.player), (CustomPacketPayload)new OrderedStackTypedSlotPacket(this.index, this.theSlot, this.lastStack.key(), this.lastStack.amount()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void loadChange(int where, IStackKey<?> newKey, long newAmount) {
        this.storage.setStackDirectly(where, newKey, newAmount);
    }
}

