/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.AbstractUnorderedStackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.NetPermissionlevel;
import com.wintercogs.beyonddimensions.Api.DataBase.PlayerPermissionInfo;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Config;
import com.wintercogs.beyonddimensions.Item.ModItems;
import com.wintercogs.beyonddimensions.Unit.PlayerNameHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DimensionsNet
extends SavedData {
    private int id;
    public boolean deleted = false;
    private UUID owner;
    private final Set<UUID> managers = new HashSet<UUID>();
    private final Set<UUID> players = new HashSet<UUID>();
    private UnifiedStorage unifiedStorage = new UnifiedStorage(this, AbstractUnorderedStackHandler.UiTimestampPolicy.AUTO);
    private final boolean temporary;
    private int currentTime = 12000;
    private int holdTime = 12000;

    public DimensionsNet(boolean temporary) {
        NeoForge.EVENT_BUS.addListener(this::onServerTick);
        this.temporary = temporary;
    }

    public static DimensionsNet create() {
        return new DimensionsNet(false);
    }

    @Nullable
    public static DimensionsNet createNewNetForPlayer(Player player, long defaultSlotCapability, int defaultSlotMaxSize) {
        DimensionsNet net = DimensionsNet.getNetFromPlayer(player);
        if (net != null) {
            return net;
        }
        MinecraftServer server = player.getServer();
        if (server != null) {
            String netId = DimensionsNet.buildNewNetName(server);
            String numId = netId.replace("BDNet_", "");
            DimensionsNet newNet = (DimensionsNet)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(DimensionsNet::create, DimensionsNet::load), netId);
            newNet.setId(Integer.parseInt(numId));
            newNet.setOwner(player.getUUID());
            newNet.addManager(player.getUUID());
            newNet.addPlayer(player.getUUID());
            newNet.setDirty();
            newNet.unifiedStorage.setSlotCapacity(defaultSlotCapability);
            newNet.unifiedStorage.setSlotMaxSize(defaultSlotMaxSize);
            return newNet;
        }
        return null;
    }

    public static String buildNewNetName(@NotNull MinecraftServer dataProvider) {
        int netId;
        for (netId = 0; netId < 10000 && dataProvider.overworld().getDataStorage().get(new SavedData.Factory(DimensionsNet::create, DimensionsNet::load), "BDNet_" + netId) != null; ++netId) {
        }
        return "BDNet_" + netId;
    }

    @Nullable
    public static DimensionsNet getNetFromId(int id) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        if (id < 0) {
            return null;
        }
        DimensionsNet net = (DimensionsNet)server.overworld().getDataStorage().get(new SavedData.Factory(DimensionsNet::create, DimensionsNet::load), "BDNet_" + id);
        if (net != null && !net.deleted) {
            return net;
        }
        return null;
    }

    @Nullable
    public static DimensionsNet getNetFromPlayer(Player player) {
        MinecraftServer server = player.getServer();
        if (server == null) {
            return null;
        }
        for (int netId = 0; netId < 10000; ++netId) {
            DimensionsNet net = (DimensionsNet)server.overworld().getDataStorage().get(new SavedData.Factory(DimensionsNet::create, DimensionsNet::load), "BDNet_" + netId);
            if (net == null || net.deleted || !net.players.contains(player.getUUID())) continue;
            return net;
        }
        return null;
    }

    public static DimensionsNet load(CompoundTag tag, HolderLookup.Provider registryAccess) {
        CompoundTag energyTag;
        UUID owner;
        DimensionsNet net = new DimensionsNet(false);
        net.id = tag.getInt("Id");
        UUID uUID = owner = tag.hasUUID("Owner") ? tag.getUUID("Owner") : null;
        if (owner != null) {
            net.owner = owner;
        }
        net.unifiedStorage.deserializeNBT(registryAccess, tag.getCompound("UnifiedStorage"));
        if (tag.contains("EnergyStorage") && (energyTag = tag.getCompound("EnergyStorage")).contains("Energy")) {
            net.unifiedStorage.insert(EnergyStackKey.INSTANCE, energyTag.getLong("Energy"), false);
        }
        if (tag.contains("Managers")) {
            ListTag managerList = tag.getList("Managers", 8);
            managerList.forEach(manager -> net.managers.add(UUID.fromString(manager.getAsString())));
        }
        if (tag.contains("Players")) {
            ListTag playerList = tag.getList("Players", 8);
            playerList.forEach(player -> net.players.add(UUID.fromString(player.getAsString())));
        }
        net.currentTime = tag.getInt("currentTime");
        if (tag.contains("Deleted")) {
            net.deleted = tag.getBoolean("Deleted");
        }
        return net;
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registryAccess) {
        tag.putInt("Id", this.id);
        if (this.owner != null) {
            tag.putUUID("Owner", this.owner);
        }
        if (!tag.contains("OldDataTag")) {
            tag.putBoolean("OldDataTag", true);
        }
        ListTag managerListTag = new ListTag();
        for (UUID manager : this.managers) {
            managerListTag.add((Object)StringTag.valueOf((String)manager.toString()));
        }
        tag.put("Managers", (Tag)managerListTag);
        ListTag playerListTag = new ListTag();
        for (UUID player : this.players) {
            playerListTag.add((Object)StringTag.valueOf((String)player.toString()));
        }
        tag.put("Players", (Tag)playerListTag);
        tag.put("UnifiedStorage", (Tag)this.unifiedStorage.serializeNBT(registryAccess));
        tag.putInt("currentTime", this.currentTime);
        tag.putBoolean("Deleted", this.deleted);
        return tag;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int Id) {
        this.id = Id;
        this.setDirty();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.addManager(owner);
        this.setDirty();
    }

    public Set<UUID> getManagers() {
        return this.managers;
    }

    public void addManager(UUID managerId) {
        this.managers.add(managerId);
        this.addPlayer(managerId);
        this.setDirty();
    }

    public void removeManager(UUID managerId) {
        if (managerId.equals(this.owner)) {
            return;
        }
        this.managers.remove(managerId);
        this.setDirty();
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public void addPlayer(UUID playerId) {
        this.players.add(playerId);
        this.setDirty();
    }

    public void removePlayer(UUID playerId) {
        if (playerId == this.owner) {
            return;
        }
        this.players.remove(playerId);
        this.managers.remove(playerId);
        this.setDirty();
    }

    public boolean isOwner(Player player) {
        return player.getUUID().equals(this.getOwner());
    }

    public boolean isOwner(UUID playerId) {
        return playerId.equals(this.getOwner());
    }

    public boolean isManager(Player player) {
        return this.managers.contains(player.getUUID());
    }

    public boolean isManager(UUID playerId) {
        return this.managers.contains(playerId);
    }

    public void mergeOtherNet(DimensionsNet otherNet) {
        for (Map.Entry<UUID, PlayerPermissionInfo> entry : otherNet.getPlayerPermissionInfoMap(ServerLifecycleHooks.getCurrentServer()).entrySet()) {
            if (entry.getValue().level() == NetPermissionlevel.Owner || entry.getValue().level() == NetPermissionlevel.Manager) {
                this.addManager(entry.getKey());
                continue;
            }
            if (entry.getValue().level() != NetPermissionlevel.Member) continue;
            this.addPlayer(entry.getKey());
        }
        for (KeyAmount stack : otherNet.getUnifiedStorage().getStorage()) {
            this.unifiedStorage.insert(stack.key(), stack.amount(), false);
        }
        otherNet.destroySelf();
    }

    public void destroySelf() {
        this.owner = null;
        this.managers.clear();
        this.players.clear();
        this.id = -99;
        this.unifiedStorage.clearStorage();
        this.deleted = true;
    }

    public HashMap<UUID, PlayerPermissionInfo> getPlayerPermissionInfoMap(@NotNull MinecraftServer dataProvider) {
        HashMap<UUID, PlayerPermissionInfo> infoMap = new HashMap<UUID, PlayerPermissionInfo>();
        for (UUID playerId : this.players) {
            if (this.isOwner(playerId)) {
                infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, dataProvider), NetPermissionlevel.Owner));
                continue;
            }
            if (this.isManager(playerId)) {
                infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, dataProvider), NetPermissionlevel.Manager));
                continue;
            }
            infoMap.put(playerId, new PlayerPermissionInfo(PlayerNameHelper.getPlayerNameByUUID(playerId, dataProvider), NetPermissionlevel.Member));
        }
        return infoMap;
    }

    public UnifiedStorage getUnifiedStorage() {
        return this.unifiedStorage;
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Pre event) {
        if (this.temporary || !Config.generateTimeCrystallization) {
            return;
        }
        --this.currentTime;
        this.setDirty();
        if (this.currentTime <= 0) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.SHATTERED_SPACE_TIME_CRYSTALLIZATION.get(), 1);
            this.unifiedStorage.insert(new ItemStackKey(stack), stack.getCount(), false);
            this.currentTime = this.holdTime;
        }
    }
}

