/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.IStackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Item.Custom.MatterCompressionBall;
import com.wintercogs.beyonddimensions.Item.ModItems;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractUnorderedStackHandler
implements IStackHandler {
    private final ZeroPolicy zeroPolicy;
    private UiTimestampPolicy uiTimestampPolicy;
    protected final Map<IStackKey<?>, Long> storage = new HashMap();
    protected final ArrayList<IStackKey<?>> slotIndex = new ArrayList();
    protected final Map<IStackKey<?>, Integer> posMap = new HashMap();
    protected final Map<IStackKey<?>, Object> key2stackMap = new HashMap();
    protected final Map<ResourceLocation, TypeBucket> type2buckets = new HashMap<ResourceLocation, TypeBucket>();
    protected final Map<IStackKey<?>, Long> creationTimeMap = new HashMap();
    protected final Map<IStackKey<?>, Long> lastModifiedTimeMap = new HashMap();
    private final List<KeyAmount> entriesView = Collections.unmodifiableList(new AbstractList<KeyAmount>(){

        @Override
        public KeyAmount get(int index) {
            IStackKey<?> key = AbstractUnorderedStackHandler.this.slotIndex.get(index);
            long amt = AbstractUnorderedStackHandler.this.storage.getOrDefault(key, 0L);
            return new KeyAmount(key, amt);
        }

        @Override
        public int size() {
            return AbstractUnorderedStackHandler.this.slotIndex.size();
        }
    });
    private final CopyOnWriteArrayList<AnyEntry> anyListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<DeltaEntry> deltaListeners = new CopyOnWriteArrayList();
    private int deltaContextDepth = 0;
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    public long slotCapacity = Long.MAX_VALUE;
    public int slotMaxSize = Integer.MAX_VALUE;

    protected AbstractUnorderedStackHandler(ZeroPolicy policy, UiTimestampPolicy uiTimestampPolicy) {
        this.zeroPolicy = Objects.requireNonNull(policy);
        this.uiTimestampPolicy = Objects.requireNonNull(uiTimestampPolicy);
    }

    private void beginDeltaContext() {
        ++this.deltaContextDepth;
    }

    private void endDeltaContext() {
        this.deltaContextDepth = Math.max(0, this.deltaContextDepth - 1);
    }

    private boolean inDeltaContext() {
        return this.deltaContextDepth > 0;
    }

    protected long nowMillis() {
        return System.currentTimeMillis();
    }

    public void setCreationTime(IStackKey<?> key, long timeMillis) {
        if (key != null) {
            this.creationTimeMap.put(key, timeMillis);
        }
    }

    public void setLastModifiedTime(IStackKey<?> key, long timeMillis) {
        if (key != null) {
            this.lastModifiedTimeMap.put(key, timeMillis);
        }
    }

    public Map<IStackKey<?>, Long> getCreationTimeMap() {
        return this.creationTimeMap;
    }

    public Map<IStackKey<?>, Long> getLastModifiedTimeMap() {
        return this.lastModifiedTimeMap;
    }

    public void setUiTimestampPolicy(UiTimestampPolicy policy) {
        this.uiTimestampPolicy = policy == null ? UiTimestampPolicy.NONE : policy;
    }

    public UiTimestampPolicy getUiTimestampPolicy() {
        return this.uiTimestampPolicy;
    }

    public AutoCloseable subscribeAny(Object owner, AnyChangeListener onAny) {
        if (owner == null || onAny == null) {
            throw new IllegalArgumentException();
        }
        this.drainRefQueue();
        AnyEntry e = new AnyEntry(new OwnerRef(owner, this.refQueue), onAny);
        this.anyListeners.add(e);
        return () -> this.anyListeners.remove(e);
    }

    public AutoCloseable subscribeDelta(Object owner, DeltaListener onDelta) {
        if (owner == null || onDelta == null) {
            throw new IllegalArgumentException();
        }
        this.drainRefQueue();
        DeltaEntry e = new DeltaEntry(new OwnerRef(owner, this.refQueue), onDelta);
        this.deltaListeners.add(e);
        return () -> this.deltaListeners.remove(e);
    }

    public <T> AutoCloseable subscribeAnyWeak(T owner, Consumer<T> onAny) {
        if (owner == null || onAny == null) {
            throw new IllegalArgumentException();
        }
        this.drainRefQueue();
        OwnerRef ref = new OwnerRef((Object)owner, this.refQueue);
        AnyEntry e = new AnyEntry(ref, () -> {
            Object o = ref.get();
            if (o != null) {
                onAny.accept(o);
            } else {
                this.drainRefQueue();
            }
        });
        this.anyListeners.add(e);
        return () -> this.anyListeners.remove(e);
    }

    public <T> AutoCloseable subscribeDeltaWeak(T owner, QuadConsumer<T, IStackKey<?>, Long, Boolean> onDelta) {
        if (owner == null || onDelta == null) {
            throw new IllegalArgumentException();
        }
        this.drainRefQueue();
        OwnerRef ref = new OwnerRef((Object)owner, this.refQueue);
        DeltaEntry e = new DeltaEntry(ref, (type, size, insert) -> {
            Object o = ref.get();
            if (o != null) {
                onDelta.accept(o, type, size, insert);
            } else {
                this.drainRefQueue();
            }
        });
        this.deltaListeners.add(e);
        return () -> this.deltaListeners.remove(e);
    }

    protected void fireChange() {
        if (this.inDeltaContext()) {
            return;
        }
        this.drainRefQueue();
        for (AnyEntry e : this.anyListeners) {
            try {
                e.listener.onAnyChange();
            }
            catch (Throwable throwable) {}
        }
    }

    protected void fireDelta(IStackKey<?> type, long size, boolean insert) {
        this.drainRefQueue();
        for (DeltaEntry e : this.deltaListeners) {
            try {
                e.listener.onDelta(type, size, insert);
            }
            catch (Throwable throwable) {}
        }
    }

    private void drainRefQueue() {
        OwnerRef ref;
        while ((ref = (OwnerRef)this.refQueue.poll()) != null) {
            OwnerRef dead = ref;
            this.anyListeners.removeIf(e -> e.ownerRef == dead);
            this.deltaListeners.removeIf(e -> e.ownerRef == dead);
        }
    }

    @Override
    public void onChange() {
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onContentChanged(IStackKey<?> type, long size, boolean insert) {
        this.beginDeltaContext();
        try {
            this.onChange();
        }
        finally {
            this.endDeltaContext();
        }
        this.fireDelta(type, size, insert);
    }

    @Override
    public List<KeyAmount> getStorage() {
        return this.entriesView;
    }

    @Override
    public void clearStorage() {
        this.storage.clear();
        this.slotIndex.clear();
        this.posMap.clear();
        this.key2stackMap.clear();
        this.type2buckets.clear();
        this.creationTimeMap.clear();
        this.lastModifiedTimeMap.clear();
        this.onChange();
    }

    @Override
    @NotNull
    public KeyAmount getStackBySlot(int slot) {
        if (slot < 0 || slot >= this.slotIndex.size()) {
            return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
        }
        IStackKey<?> key = this.slotIndex.get(slot);
        return new KeyAmount(key, this.storage.getOrDefault(key, 0L));
    }

    @Override
    @NotNull
    public KeyAmount getStackByKey(IStackKey<?> key) {
        if (key == null) {
            return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
        }
        return new KeyAmount(key, this.storage.getOrDefault(key, 0L));
    }

    @Override
    public boolean hasStack(IStackKey<?> key) {
        return key != null && this.storage.getOrDefault(key, 0L) > 0L;
    }

    public long setAmountByKey(IStackKey<?> key, long amount) {
        long delta;
        boolean isNew;
        if (key == null) {
            return 0L;
        }
        long current = this.storage.getOrDefault(key, 0L);
        long target = Math.max(0L, Math.min(amount, this.slotCapacity));
        if (target == current) {
            return current;
        }
        if (target == 0L) {
            long delta2;
            if (this.zeroPolicy == ZeroPolicy.REMOVE_ON_ZERO) {
                if (current > 0L || this.posMap.containsKey(key)) {
                    this.storage.remove(key);
                    this.removeFromIndex(key);
                    if (this.uiTimestampPolicy == UiTimestampPolicy.AUTO) {
                        this.lastModifiedTimeMap.put(key, this.nowMillis());
                    }
                    this.onContentChanged(key, current, false);
                }
                return 0L;
            }
            this.storage.put(key, 0L);
            this.ensureInIndex(key);
            if (this.uiTimestampPolicy == UiTimestampPolicy.AUTO) {
                this.lastModifiedTimeMap.put(key, this.nowMillis());
            }
            if ((delta2 = current) > 0L) {
                this.onContentChanged(key, delta2, false);
            }
            return 0L;
        }
        boolean bl = isNew = current == 0L && !this.posMap.containsKey(key);
        if (isNew && this.slotIndex.size() >= this.slotMaxSize) {
            return current;
        }
        this.storage.put(key, target);
        this.ensureInIndex(key);
        if (this.uiTimestampPolicy == UiTimestampPolicy.AUTO) {
            this.lastModifiedTimeMap.put(key, this.nowMillis());
        }
        if ((delta = Math.abs(target - current)) > 0L) {
            this.onContentChanged(key, delta, target > current);
        }
        return target;
    }

    @Override
    public void setStackDirectly(int slot, IStackKey<?> newKey, long amount) {
        if (slot < 0 || slot >= this.slotIndex.size()) {
            return;
        }
        IStackKey<?> oldKey = this.slotIndex.get(slot);
        long target = Math.max(0L, amount);
        if (Objects.equals(oldKey, newKey)) {
            this.setAmountByKey(oldKey, target);
            return;
        }
        long oldAmt = this.storage.getOrDefault(oldKey, 0L);
        if (this.zeroPolicy == ZeroPolicy.REMOVE_ON_ZERO) {
            this.storage.remove(oldKey);
            this.removeFromIndex(oldKey);
        } else {
            this.storage.put(oldKey, 0L);
        }
        if (this.uiTimestampPolicy == UiTimestampPolicy.AUTO) {
            this.lastModifiedTimeMap.put(oldKey, this.nowMillis());
        }
        if (oldAmt > 0L) {
            this.onContentChanged(oldKey, oldAmt, false);
        }
        if (newKey != null) {
            this.setAmountByKey(newKey, target);
            if (this.uiTimestampPolicy == UiTimestampPolicy.AUTO) {
                this.lastModifiedTimeMap.put(newKey, this.nowMillis());
            }
        }
    }

    @Override
    public void addStackDirectly(IStackKey<?> key, long amount) {
        this.insert(key, amount, false);
    }

    @Override
    @NotNull
    public KeyAmount insert(int slot, IStackKey<?> key, long amount, boolean simulate) {
        return this.insert(key, amount, simulate);
    }

    @Override
    @NotNull
    public KeyAmount insert(IStackKey<?> key, long amount, boolean simulate) {
        long room;
        boolean needNewSlot;
        ItemStackKey itemKey;
        if (key == null) {
            return new KeyAmount(EmptyStackKey.INSTANCE, Math.max(0L, amount));
        }
        long add = Math.max(0L, amount);
        if (add == 0L) {
            return new KeyAmount(key, 0L);
        }
        if (key instanceof ItemStackKey && (itemKey = (ItemStackKey)key).getSource() == ModItems.MATTER_COMPRESS_BALL.get()) {
            return this.unzipMatterBall(itemKey, add, simulate);
        }
        long current = this.storage.getOrDefault(key, 0L);
        boolean bl = needNewSlot = current == 0L && !this.posMap.containsKey(key);
        if (needNewSlot && this.slotIndex.size() >= this.slotMaxSize) {
            return new KeyAmount(key, add);
        }
        long cap = this.slotCapacity;
        long l = room = cap <= current ? 0L : cap - current;
        if (room <= 0L) {
            return new KeyAmount(key, add);
        }
        long actual = Math.min(room, add);
        long leftover = add - actual;
        if (!simulate && actual > 0L) {
            this.storage.put(key, current + actual);
            this.ensureInIndex(key);
            if (this.uiTimestampPolicy == UiTimestampPolicy.AUTO) {
                this.lastModifiedTimeMap.put(key, this.nowMillis());
            }
            this.onContentChanged(key, actual, true);
        }
        return new KeyAmount(key, leftover);
    }

    protected KeyAmount unzipMatterBall(ItemStackKey ballKey, long ballCount, boolean simulate) {
        ItemStack ballStack = ballKey.copyStackWithCount(ballCount);
        if (ballStack.isEmpty() || !(ballStack.getItem() instanceof MatterCompressionBall)) {
            return new KeyAmount(ballKey, ballCount);
        }
        List contents = (List)ballStack.getOrDefault(ModDataComponents.ISTACK_SLOTS, new ArrayList());
        if (contents.isEmpty()) {
            return new KeyAmount(ballKey, 0L);
        }
        HashMap needMap = new HashMap();
        try {
            for (KeyAmount entry : contents) {
                if (entry.isEmpty()) continue;
                long scaled = Math.multiplyExact(entry.amount(), ballCount);
                needMap.merge(entry.key(), scaled, Math::addExact);
            }
        }
        catch (ArithmeticException e) {
            return new KeyAmount(ballKey, ballCount);
        }
        int freeSlots = Math.max(0, this.slotMaxSize - this.slotIndex.size());
        int newKeysNeeded = 0;
        for (Map.Entry e : needMap.entrySet()) {
            boolean isNew;
            IStackKey k = (IStackKey)e.getKey();
            long need = (Long)e.getValue();
            long current = this.storage.getOrDefault(k, 0L);
            boolean bl = isNew = current == 0L && !this.posMap.containsKey(k);
            if (isNew && ++newKeysNeeded > freeSlots) {
                return new KeyAmount(ballKey, ballCount);
            }
            long room = this.slotCapacity <= current ? 0L : this.slotCapacity - current;
            if (need <= room) continue;
            return new KeyAmount(ballKey, ballCount);
        }
        if (simulate) {
            return new KeyAmount(ballKey, 0L);
        }
        ArrayList<KeyAmount> applied = new ArrayList<KeyAmount>();
        for (KeyAmount entry : contents) {
            long scaled;
            if (entry.isEmpty()) continue;
            try {
                scaled = Math.multiplyExact(entry.amount(), ballCount);
            }
            catch (ArithmeticException e) {
                for (int i = applied.size() - 1; i >= 0; --i) {
                    KeyAmount a = (KeyAmount)applied.get(i);
                    this.extract(a.key(), a.amount(), false);
                }
                return new KeyAmount(ballKey, ballCount);
            }
            KeyAmount leftover = this.insert(entry.key(), scaled, false);
            long ok = scaled - leftover.amount();
            if (ok > 0L) {
                applied.add(new KeyAmount(entry.key(), ok));
            }
            if (leftover.amount() <= 0L) continue;
            for (int i = applied.size() - 1; i >= 0; --i) {
                KeyAmount a = (KeyAmount)applied.get(i);
                this.extract(a.key(), a.amount(), false);
            }
            return new KeyAmount(ballKey, ballCount);
        }
        return new KeyAmount(ballKey, 0L);
    }

    @Override
    @NotNull
    public KeyAmount extract(int slot, long count, boolean simulate) {
        if (slot < 0 || slot >= this.slotIndex.size() || count <= 0L) {
            return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
        }
        IStackKey<?> key = this.slotIndex.get(slot);
        long current = this.storage.getOrDefault(key, 0L);
        if (current <= 0L) {
            return new KeyAmount(key, 0L);
        }
        long take = Math.min(count, current);
        if (!simulate) {
            long left = current - take;
            if (left == 0L) {
                if (this.uiTimestampPolicy == UiTimestampPolicy.AUTO) {
                    this.lastModifiedTimeMap.put(key, this.nowMillis());
                }
                if (this.zeroPolicy == ZeroPolicy.REMOVE_ON_ZERO) {
                    this.storage.remove(key);
                    this.removeFromIndex(key);
                } else {
                    this.storage.put(key, 0L);
                    this.ensureInIndex(key);
                }
            } else {
                this.storage.put(key, left);
                if (this.uiTimestampPolicy == UiTimestampPolicy.AUTO) {
                    this.lastModifiedTimeMap.put(key, this.nowMillis());
                }
            }
            this.onContentChanged(key, take, false);
        }
        return new KeyAmount(key, take);
    }

    @Override
    @NotNull
    public KeyAmount extract(IStackKey<?> key, long amount, boolean simulate) {
        if (key == null || amount <= 0L) {
            return new KeyAmount(EmptyStackKey.INSTANCE, 0L);
        }
        long current = this.storage.getOrDefault(key, 0L);
        if (current <= 0L) {
            return new KeyAmount(key, 0L);
        }
        long take = Math.min(amount, current);
        if (!simulate) {
            long left = current - take;
            if (left == 0L) {
                if (this.uiTimestampPolicy == UiTimestampPolicy.AUTO) {
                    this.lastModifiedTimeMap.put(key, this.nowMillis());
                }
                if (this.zeroPolicy == ZeroPolicy.REMOVE_ON_ZERO) {
                    this.storage.remove(key);
                    this.removeFromIndex(key);
                } else {
                    this.storage.put(key, 0L);
                    this.ensureInIndex(key);
                }
            } else {
                this.storage.put(key, left);
                if (this.uiTimestampPolicy == UiTimestampPolicy.AUTO) {
                    this.lastModifiedTimeMap.put(key, this.nowMillis());
                }
            }
            this.onContentChanged(key, take, false);
        }
        return new KeyAmount(key, take);
    }

    @Override
    public long getSlotCapacity(int slot) {
        return this.slotCapacity;
    }

    @Override
    public boolean isStackValid(int slot, IStackKey<?> key) {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.slotIndex.isEmpty();
    }

    protected void ensureInIndex(IStackKey<?> key) {
        if (this.posMap.containsKey(key)) {
            return;
        }
        int idx = this.slotIndex.size();
        this.slotIndex.add(key);
        this.posMap.put(key, idx);
        this.bucketOf(key.getTypeId()).add(key);
        if (!this.key2stackMap.containsKey(key)) {
            this.key2stackMap.put(key, key.copyStack());
        }
        if (this.uiTimestampPolicy == UiTimestampPolicy.AUTO) {
            this.creationTimeMap.put(key, this.nowMillis());
        }
    }

    protected void removeFromIndex(IStackKey<?> key) {
        Integer pos = this.posMap.remove(key);
        if (pos == null) {
            return;
        }
        int last = this.slotIndex.size() - 1;
        if (pos != last) {
            IStackKey<?> tail = this.slotIndex.get(last);
            this.slotIndex.set(pos, tail);
            this.posMap.put(tail, pos);
        }
        this.slotIndex.remove(last);
        this.bucketOf(key.getTypeId()).remove(key);
        this.key2stackMap.remove(key);
        this.creationTimeMap.remove(key);
        this.lastModifiedTimeMap.remove(key);
    }

    protected TypeBucket bucketOf(ResourceLocation type) {
        return this.type2buckets.computeIfAbsent(type, t -> new TypeBucket());
    }

    public Optional<TypeBucket> getBucket(ResourceLocation type) {
        return Optional.ofNullable(this.type2buckets.get(type));
    }

    public Object getOutStackByKey(IStackKey<?> key) {
        return this.key2stackMap.get(key);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putLong("slotCapacity", this.slotCapacity);
        tag.putInt("slotMaxSize", this.slotMaxSize);
        ListTag stacksTag = new ListTag();
        boolean writeZero = this.zeroPolicy == ZeroPolicy.KEEP_ZERO;
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)provider);
        for (Map.Entry<IStackKey<?>, Long> entry : this.storage.entrySet()) {
            IStackKey<?> key = entry.getKey();
            long value = entry.getValue();
            if (key == null || key.isEmpty() || !writeZero && value <= 0L) continue;
            DataResult enc = IStackKey.CODEC.encodeStart((DynamicOps)ops, key);
            Tag encoded = enc.resultOrPartial(err -> BeyondDimensions.LOGGER.warn("\u7f16\u7801 IStackKey \u5931\u8d25\uff1a{} | key={}", err, (Object)key)).orElse(null);
            if (!(encoded instanceof CompoundTag)) {
                if (encoded == null) continue;
                BeyondDimensions.LOGGER.warn("IStackKey \u7f16\u7801\u7ed3\u679c\u4e0d\u662f CompoundTag\uff1a{} | key={}", (Object)encoded.getClass().getName(), key);
                continue;
            }
            CompoundTag ct = (CompoundTag)encoded;
            CompoundTag stackTag = new CompoundTag();
            stackTag.put("key", (Tag)ct);
            stackTag.putLong("amount", value);
            stacksTag.add((Object)stackTag);
        }
        tag.put("stacks", (Tag)stacksTag);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.clearStorage();
        this.slotCapacity = tag.contains("slotCapacity", 4) ? tag.getLong("slotCapacity") : Long.MAX_VALUE;
        this.slotMaxSize = tag.contains("slotMaxSize", 3) ? tag.getInt("slotMaxSize") : Integer.MAX_VALUE;
        RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)provider);
        ListTag stacksNew = tag.getList("stacks", 10);
        if (!stacksNew.isEmpty()) {
            for (int i = 0; i < stacksNew.size(); ++i) {
                Tag el = stacksNew.get(i);
                if (!(el instanceof CompoundTag)) continue;
                CompoundTag stackTag = (CompoundTag)el;
                long amount = AbstractUnorderedStackHandler.readAmountCompat(stackTag);
                Tag rawKeyTag = stackTag.get("key");
                if (!(rawKeyTag instanceof CompoundTag)) continue;
                CompoundTag keyTag = (CompoundTag)rawKeyTag;
                try {
                    IStackKey.CODEC.parse((DynamicOps)ops, (Object)keyTag).resultOrPartial(err -> BeyondDimensions.LOGGER.warn("\u89e3\u7801 IStackKey \u5931\u8d25\uff1a{}", err)).ifPresent(key -> this.acceptEntry((IStackKey<?>)key, amount));
                    continue;
                }
                catch (Throwable t) {
                    BeyondDimensions.LOGGER.warn("\u89e3\u7801\u7b2c {} \u4e2a\u65b0\u683c\u5f0f\u6761\u76ee\u65f6\u51fa\u9519: {}", (Object)i, (Object)t.toString());
                }
            }
            return;
        }
        ListTag stacksOld = tag.getList("Stacks", 10);
        for (int i = 0; i < stacksOld.size(); ++i) {
            Tag el = stacksOld.get(i);
            if (!(el instanceof CompoundTag)) continue;
            CompoundTag entry = (CompoundTag)el;
            String typeStr = entry.getString("Type");
            if (typeStr.isEmpty()) {
                BeyondDimensions.LOGGER.warn("\u65e7\u683c\u5f0f\u6761\u76ee\u7f3a\u5c11 Type\uff0c\u5df2\u8df3\u8fc7\uff08index={}\uff09", (Object)i);
                continue;
            }
            CompoundTag typed = entry.getCompound("TypedStack");
            if (typed.isEmpty()) {
                BeyondDimensions.LOGGER.warn("\u65e7\u683c\u5f0f\u6761\u76ee\u7f3a\u5c11 TypedStack\uff0c\u5df2\u8df3\u8fc7\uff08index={}\uff09", (Object)i);
                continue;
            }
            CompoundTag compatKey = typed.copy();
            compatKey.putString("type", typeStr);
            long amount = AbstractUnorderedStackHandler.readAmountCompat(typed);
            try {
                IStackKey.CODEC.parse((DynamicOps)ops, (Object)compatKey).resultOrPartial(err -> BeyondDimensions.LOGGER.warn("\u65e7\u683c\u5f0f IStackKey \u89e3\u7801\u5931\u8d25\uff1a{} | type={}", err, (Object)typeStr)).ifPresent(key -> this.acceptEntry((IStackKey<?>)key, amount));
                continue;
            }
            catch (Throwable t) {
                BeyondDimensions.LOGGER.warn("\u89e3\u7801\u65e7\u683c\u5f0f\u6761\u76ee\u65f6\u51fa\u9519\uff08index={} type={}\uff09\uff1a{}", new Object[]{i, typeStr, t.toString()});
            }
        }
    }

    private static long readAmountCompat(CompoundTag holder) {
        if (holder.contains("amount", 4)) {
            return holder.getLong("amount");
        }
        if (holder.contains("Amount", 4)) {
            return holder.getLong("Amount");
        }
        if (holder.contains("Stack", 10)) {
            CompoundTag inner = holder.getCompound("Stack");
            if (inner.contains("count", 3)) {
                return inner.getInt("count");
            }
            if (inner.contains("Count", 3)) {
                return inner.getInt("Count");
            }
            if (inner.contains("amount", 3)) {
                return inner.getInt("amount");
            }
            if (inner.contains("Amount", 3)) {
                return inner.getInt("Amount");
            }
            if (inner.contains("amount", 4)) {
                return inner.getLong("amount");
            }
            if (inner.contains("Amount", 4)) {
                return inner.getLong("Amount");
            }
        }
        return 0L;
    }

    private void acceptEntry(IStackKey<?> key, long amount) {
        if (key == null || key.isEmpty()) {
            return;
        }
        if (this.uiTimestampPolicy == UiTimestampPolicy.AUTO) {
            long now = this.nowMillis();
            this.creationTimeMap.put(key, now);
            this.lastModifiedTimeMap.put(key, now);
        }
        if (amount <= 0L) {
            if (this.zeroPolicy == ZeroPolicy.KEEP_ZERO) {
                this.storage.put(key, 0L);
                this.ensureInIndex(key);
            }
        } else {
            this.insert(key, amount, false);
        }
    }

    public void setSlotCapacity(long capacity) {
        this.slotCapacity = capacity;
        this.onChange();
    }

    public void setSlotMaxSize(int maxSize) {
        this.slotMaxSize = maxSize;
        this.onChange();
    }

    public boolean isFullSlotsSize() {
        return this.slotIndex.size() >= this.slotMaxSize;
    }

    protected static enum ZeroPolicy {
        KEEP_ZERO,
        REMOVE_ON_ZERO;

    }

    public static enum UiTimestampPolicy {
        NONE,
        AUTO;

    }

    private static final class AnyEntry {
        final OwnerRef ownerRef;
        final AnyChangeListener listener;

        AnyEntry(OwnerRef ref, AnyChangeListener l) {
            this.ownerRef = ref;
            this.listener = l;
        }
    }

    private static final class OwnerRef
    extends WeakReference<Object> {
        OwnerRef(Object owner, ReferenceQueue<Object> q) {
            super(owner, q);
        }
    }

    @FunctionalInterface
    public static interface AnyChangeListener {
        public void onAnyChange();
    }

    private static final class DeltaEntry {
        final OwnerRef ownerRef;
        final DeltaListener listener;

        DeltaEntry(OwnerRef ref, DeltaListener l) {
            this.ownerRef = ref;
            this.listener = l;
        }
    }

    @FunctionalInterface
    public static interface DeltaListener {
        public void onDelta(IStackKey<?> var1, long var2, boolean var4);
    }

    @FunctionalInterface
    public static interface QuadConsumer<A, B, C, D> {
        public void accept(A var1, B var2, C var3, D var4);
    }

    public static final class TypeBucket {
        final ArrayList<IStackKey<?>> keys = new ArrayList();
        final Map<IStackKey<?>, Integer> pos = new HashMap();

        void add(IStackKey<?> k) {
            if (this.pos.containsKey(k)) {
                return;
            }
            int i = this.keys.size();
            this.keys.add(k);
            this.pos.put(k, i);
        }

        void remove(IStackKey<?> k) {
            Integer p = this.pos.remove(k);
            if (p == null) {
                return;
            }
            int last = this.keys.size() - 1;
            if (p != last) {
                IStackKey<?> tail = this.keys.get(last);
                this.keys.set(p, tail);
                this.pos.put(tail, p);
            }
            this.keys.remove(last);
        }

        public int size() {
            return this.keys.size();
        }

        public IStackKey<?> get(int i) {
            return this.keys.get(i);
        }
    }
}

