/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidStackTypedHandler
implements IFluidHandler {
    private static final ResourceLocation FLUID_TYPE = FluidStackKey.ID;
    private final StackHandler handlerStorage;

    public FluidStackTypedHandler(StackHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    private int fluidCount() {
        return this.handlerStorage.getBucket(FLUID_TYPE).map(StackHandler.SlotBucket::size).orElse(0);
    }

    private int emptyCount() {
        return this.handlerStorage.getBucket(EmptyStackKey.INSTANCE).map(StackHandler.SlotBucket::size).orElse(0);
    }

    private boolean inFluidRegion(int visibleSlot) {
        int fluids = this.fluidCount();
        return visibleSlot >= 0 && visibleSlot < fluids;
    }

    private int getFluidSlotAt(int index) {
        if (index < 0) {
            return -1;
        }
        return this.handlerStorage.getBucket(FLUID_TYPE).map(b -> index < b.size() ? b.get(index) : -1).orElse(-1);
    }

    private int getEmptySlotAt(int index) {
        if (index < 0) {
            return -1;
        }
        return this.handlerStorage.getBucket(EmptyStackKey.INSTANCE).map(b -> index < b.size() ? b.get(index) : -1).orElse(-1);
    }

    private int resolveActualIndex(int visibleSlot) {
        if (visibleSlot < 0) {
            return -1;
        }
        int fluids = this.fluidCount();
        if (visibleSlot < fluids) {
            return this.getFluidSlotAt(visibleSlot);
        }
        int rest = visibleSlot - fluids;
        return this.getEmptySlotAt(rest);
    }

    public int getTanks() {
        return this.fluidCount() + this.emptyCount();
    }

    @NotNull
    public FluidStack getFluidInTank(int slot) {
        if (!this.inFluidRegion(slot)) {
            return FluidStack.EMPTY;
        }
        int actualIndex = this.resolveActualIndex(slot);
        if (actualIndex < 0) {
            return FluidStack.EMPTY;
        }
        KeyAmount ka = this.handlerStorage.getStackBySlot(actualIndex);
        if (ka.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Object cached = this.handlerStorage.getOutStackByKey(ka.key());
        if (!(cached instanceof FluidStack)) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = (FluidStack)cached;
        if (fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int shown = BDMath.clampLongToInt(ka.amount());
        if (shown <= 0) {
            return FluidStack.EMPTY;
        }
        fluid.setAmount(shown);
        return fluid;
    }

    public int getTankCapacity(int tank) {
        return 64000;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
        return true;
    }

    public int fill(FluidStack fluidStack, @NotNull IFluidHandler.FluidAction action) {
        if (fluidStack.isEmpty()) {
            return 0;
        }
        int requested = fluidStack.getAmount();
        long remaining = this.handlerStorage.insert(new FluidStackKey(fluidStack), requested, action.simulate()).amount();
        return requested - BDMath.clampLongToInt(remaining);
    }

    @NotNull
    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction action) {
        FluidStack fs;
        if (fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Object out = this.handlerStorage.extract(new FluidStackKey(fluidStack), (long)fluidStack.getAmount(), action.simulate()).toStack();
        return out instanceof FluidStack ? (fs = (FluidStack)out) : FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
        FluidStack fs;
        if (amount <= 0) {
            return FluidStack.EMPTY;
        }
        int firstFluidSlot = this.handlerStorage.getBucket(FLUID_TYPE).map(b -> b.size() > 0 ? b.get(0) : -1).orElse(-1);
        if (firstFluidSlot < 0) {
            return FluidStack.EMPTY;
        }
        KeyAmount ka = this.handlerStorage.getStackBySlot(firstFluidSlot);
        if (ka.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Object out = this.handlerStorage.extract(ka.key(), (long)amount, action.simulate()).toStack();
        return out instanceof FluidStack ? (fs = (FluidStack)out) : FluidStack.EMPTY;
    }
}

