/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ItemStackTypedHandler
implements IItemHandler {
    private static final ResourceLocation ITEM_TYPE = ItemStackKey.ID;
    private final StackHandler handlerStorage;

    public ItemStackTypedHandler(StackHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    private int itemCount() {
        return this.handlerStorage.getBucket(ITEM_TYPE).map(StackHandler.SlotBucket::size).orElse(0);
    }

    private int emptyCount() {
        return this.handlerStorage.getBucket(EmptyStackKey.INSTANCE).map(StackHandler.SlotBucket::size).orElse(0);
    }

    private boolean inItemRegion(int visibleSlot) {
        int items = this.itemCount();
        return visibleSlot >= 0 && visibleSlot < items;
    }

    private int getItemSlotAt(int index) {
        if (index < 0) {
            return -1;
        }
        return this.handlerStorage.getBucket(ITEM_TYPE).map(b -> index < b.size() ? b.get(index) : -1).orElse(-1);
    }

    private int getEmptySlotAt(int index) {
        if (index < 0) {
            return -1;
        }
        return this.handlerStorage.getBucket(EmptyStackKey.INSTANCE).map(b -> index < b.size() ? b.get(index) : -1).orElse(-1);
    }

    private int resolveActualIndex(int visibleSlot) {
        if (visibleSlot < 0) {
            return -1;
        }
        int items = this.itemCount();
        if (visibleSlot < items) {
            return this.getItemSlotAt(visibleSlot);
        }
        int rest = visibleSlot - items;
        return this.getEmptySlotAt(rest);
    }

    public int getSlots() {
        return this.itemCount() + this.emptyCount();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (!this.inItemRegion(slot)) {
            return ItemStack.EMPTY;
        }
        int actualIndex = this.resolveActualIndex(slot);
        if (actualIndex < 0) {
            return ItemStack.EMPTY;
        }
        KeyAmount ka = this.handlerStorage.getStackBySlot(actualIndex);
        if (ka.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Object cached = this.handlerStorage.getOutStackByKey(ka.key());
        if (!(cached instanceof ItemStack)) {
            return ItemStack.EMPTY;
        }
        ItemStack item = (ItemStack)cached;
        if (item.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int shown = BDMath.clampLongToInt(ka.amount());
        if (shown <= 0) {
            return ItemStack.EMPTY;
        }
        item.setCount(shown);
        return item;
    }

    @NotNull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack is;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int actualIndex = this.resolveActualIndex(slot);
        if (actualIndex < 0) {
            return stack.copy();
        }
        KeyAmount rem = this.handlerStorage.insert(actualIndex, new ItemStackKey(stack), stack.getCount(), simulate);
        Object leftover = rem.toStack();
        return leftover instanceof ItemStack ? (is = (ItemStack)leftover) : stack.copy();
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack is;
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        if (!this.inItemRegion(slot)) {
            return ItemStack.EMPTY;
        }
        int actualIndex = this.resolveActualIndex(slot);
        if (actualIndex < 0) {
            return ItemStack.EMPTY;
        }
        KeyAmount taken = this.handlerStorage.extract(actualIndex, (long)amount, simulate);
        Object out = taken.toStack();
        return out instanceof ItemStack ? (is = (ItemStack)out) : ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        if (!this.inItemRegion(slot)) {
            return 99;
        }
        int actualIndex = this.resolveActualIndex(slot);
        if (actualIndex < 0) {
            return 99;
        }
        KeyAmount ka = this.handlerStorage.getStackBySlot(actualIndex);
        long byType = ka.isEmpty() ? 99L : ka.key().getVanillaMaxStackSize();
        long byCap = this.handlerStorage.getSlotCapacity(actualIndex);
        return BDMath.clampLongToInt(Math.min(byType, byCap));
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }
}

