/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ManaStackKey;
import com.wintercogs.beyonddimensions.Api.Util.CapCtx;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.UnknownNullability;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.spark.SparkAttachable;

public class ManaStackTypedHandler
implements ManaCollector,
ManaPool,
SparkAttachable {
    private final StackHandler storageHandler;
    private final Level level;
    private final BlockPos pos;

    public ManaStackTypedHandler(StackHandler storageHandler, CapCtx ctx) {
        this.storageHandler = storageHandler;
        this.level = ctx.level();
        this.pos = ctx.pos();
    }

    public @UnknownNullability Level getManaReceiverLevel() {
        return this.level;
    }

    public BlockPos getManaReceiverPos() {
        return this.pos;
    }

    public int getCurrentMana() {
        return this.storageHandler.getBucket(ManaStackKey.ID).map(bucket -> {
            long sum = 0L;
            for (int slot : bucket.snapshot()) {
                long amt;
                if (slot < 0 || (amt = this.storageHandler.getStackBySlot(slot).amount()) <= 0L) continue;
                long remain = Integer.MAX_VALUE - sum;
                if (amt > remain) {
                    return Integer.MAX_VALUE;
                }
                sum += amt;
            }
            return (int)sum;
        }).orElse(0);
    }

    public boolean isFull() {
        for (KeyAmount keyAmount : this.storageHandler.getStorage()) {
            if (keyAmount.isEmpty()) {
                return false;
            }
            if (!(keyAmount.key() instanceof ManaStackKey) || keyAmount.amount() >= keyAmount.key().getVanillaMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public void receiveMana(int mana) {
        if (mana > 0) {
            this.storageHandler.insert(ManaStackKey.INSTANCE, mana, false);
        } else {
            this.storageHandler.extract(ManaStackKey.INSTANCE, (long)(-mana), false);
        }
    }

    public boolean canReceiveManaFromBursts() {
        return true;
    }

    public void onClientDisplayTick() {
    }

    public float getManaYieldMultiplier(ManaBurst burst) {
        return 1.0f;
    }

    public boolean isOutputtingPower() {
        return true;
    }

    public int getMaxMana() {
        int emptySlots;
        int manaSlots = this.storageHandler.getBucket(ManaStackKey.ID).map(StackHandler.SlotBucket::size).orElse(0);
        int eligibleSlots = manaSlots + (emptySlots = this.storageHandler.getBucket(EmptyStackKey.INSTANCE).map(StackHandler.SlotBucket::size).orElse(0).intValue());
        if (eligibleSlots <= 0) {
            return 0;
        }
        long perSlot = Math.min(ManaStackKey.INSTANCE.getVanillaMaxStackSize(), this.storageHandler.getSlotCapacity(0));
        long total = perSlot * (long)eligibleSlots;
        return BDMath.clampLongToInt(total);
    }

    public Optional<DyeColor> getColor() {
        return Optional.empty();
    }

    public void setColor(Optional<DyeColor> color) {
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public int getAvailableSpaceForMana() {
        return this.getMaxMana() - this.getCurrentMana();
    }

    public boolean areIncomingTransfersDone() {
        return this.isFull();
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public @UnknownNullability Level getLevel() {
        return this.level;
    }
}

