/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Handler;

import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.SourceStackKey;
import com.wintercogs.beyonddimensions.Unit.BDMath;

public class SourceStackTypedHandler
implements ISourceCap {
    private final StackHandler handlerStorage;

    public SourceStackTypedHandler(StackHandler handlerStorage) {
        this.handlerStorage = handlerStorage;
    }

    public boolean canAcceptSource(int amount) {
        return this.receiveSource(amount, true) > 0;
    }

    public boolean canProvideSource(int amount) {
        return this.extractSource(amount, true) > 0;
    }

    public int getMaxExtract() {
        return Integer.MAX_VALUE;
    }

    public int getMaxReceive() {
        return Integer.MAX_VALUE;
    }

    public int getSource() {
        return this.handlerStorage.getBucket(SourceStackKey.ID).map(bucket -> {
            long sum = 0L;
            int n = bucket.size();
            for (int i = 0; i < n; ++i) {
                int slot = bucket.get(i);
                long amt = this.handlerStorage.getStackBySlot(slot).amount();
                if (amt <= 0L) continue;
                long remain = Integer.MAX_VALUE - sum;
                if (amt >= remain) {
                    return Integer.MAX_VALUE;
                }
                sum += amt;
            }
            return (int)sum;
        }).orElse(0);
    }

    public int getSourceCapacity() {
        int emptySlots;
        int sourceSlots = this.handlerStorage.getBucket(SourceStackKey.ID).map(StackHandler.SlotBucket::size).orElse(0);
        int eligibleSlots = sourceSlots + (emptySlots = this.handlerStorage.getBucket(EmptyStackKey.INSTANCE).map(StackHandler.SlotBucket::size).orElse(0).intValue());
        if (eligibleSlots <= 0) {
            return 0;
        }
        long perSlot = Math.min(SourceStackKey.INSTANCE.getVanillaMaxStackSize(), this.handlerStorage.getSlotCapacity(0));
        long total = perSlot * (long)eligibleSlots;
        return BDMath.clampLongToInt(total);
    }

    public int getMaxSource() {
        return this.getSourceCapacity();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public void setSource(int amount) {
        int current;
        int cap = this.getSourceCapacity();
        int target = Math.max(0, Math.min(amount, cap));
        int delta = target - (current = this.getSource());
        if (delta > 0) {
            this.handlerStorage.insert(SourceStackKey.INSTANCE, delta, false);
        } else if (delta < 0) {
            this.handlerStorage.extract(SourceStackKey.INSTANCE, (long)(-delta), false);
        }
    }

    public void setMaxSource(int capacity) {
    }

    public int receiveSource(int amount, boolean sim) {
        if (amount <= 0) {
            return 0;
        }
        long rem = this.handlerStorage.insert(SourceStackKey.INSTANCE, amount, sim).amount();
        long ins = (long)amount - rem;
        return ins <= 0L ? 0 : (int)ins;
    }

    public int extractSource(int amount, boolean sim) {
        if (amount <= 0) {
            return 0;
        }
        long out = this.handlerStorage.extract(SourceStackKey.INSTANCE, (long)amount, sim).amount();
        return out <= 0L ? 0 : (int)out;
    }
}

