/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ChemicalStackKeyRender;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackRender;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import java.util.Optional;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChemicalStackKey
implements IStackKey<ChemicalStack> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/chemical");
    public static final ChemicalStackKey EMPTY = new ChemicalStackKey();
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    private static final MapCodec<ChemicalStackKey> NEW_FMT = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("chemical").forGetter(t -> t.chemical.unwrapKey().map(ResourceKey::location).orElseThrow(() -> new IllegalStateException("Unbound chemical holder")))).apply((Applicative)instance, rl -> {
        ResourceKey key = ResourceKey.create((ResourceKey)MekanismAPI.CHEMICAL_REGISTRY_NAME, (ResourceLocation)rl);
        Holder holder = MekanismAPI.CHEMICAL_REGISTRY.getHolder(key).map(r -> r).orElse(MekanismAPI.EMPTY_CHEMICAL_HOLDER);
        return new ChemicalStackKey((Holder<Chemical>)holder);
    }));
    public static final MapCodec<ChemicalStackKey> TYPE_CODEC = new MapCodec<ChemicalStackKey>(){
        private static final String K_CHEM = "chemical";
        private static final String K_LEGACY = "internal_stack";
        private static final String K_STACK = "Stack";

        public <T> DataResult<ChemicalStackKey> decode(DynamicOps<T> ops, MapLike<T> input) {
            Object kChem = ops.createString(K_CHEM);
            Object kLegacy = ops.createString(K_LEGACY);
            Object kStack = ops.createString(K_STACK);
            if (input.get(kChem) != null) {
                return NEW_FMT.decode(ops, input);
            }
            Object legacyNode = input.get(kLegacy);
            if (legacyNode == null) {
                legacyNode = input.get(kStack);
            }
            if (legacyNode != null) {
                return ChemicalStack.OPTIONAL_CODEC.parse(ops, legacyNode).map(ChemicalStackKey::new);
            }
            return NEW_FMT.decode(ops, input);
        }

        public <T> RecordBuilder<T> encode(ChemicalStackKey value, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return NEW_FMT.encode((Object)value, ops, prefix);
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(K_CHEM).map(arg_0 -> ops.createString(arg_0));
        }
    };
    public static final Codec<ChemicalStackKey> CODEC = TYPE_CODEC.codec();
    private final Holder<Chemical> chemical;
    private ChemicalStack serverCache;
    private ChemicalStack clientCache;
    private int hashCodeCache = 0;

    private ChemicalStackKey() {
        this((Holder<Chemical>)MekanismAPI.EMPTY_CHEMICAL_HOLDER);
    }

    public ChemicalStackKey(ChemicalStack stack) {
        this((Holder<Chemical>)stack.getChemicalHolder());
    }

    private ChemicalStackKey(Holder<Chemical> chemical) {
        this.chemical = ChemicalStackKey.resolveBound(chemical == null ? MekanismAPI.EMPTY_CHEMICAL_HOLDER : chemical);
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public MapCodec<ChemicalStackKey> codec() {
        return TYPE_CODEC;
    }

    @Override
    @Nullable
    public KeyAmount fromStackObject(Object stack) {
        if (stack instanceof ChemicalStack) {
            ChemicalStack chemicalStack = (ChemicalStack)stack;
            return new KeyAmount(new ChemicalStackKey(chemicalStack), chemicalStack.getAmount());
        }
        return null;
    }

    @Nullable
    public ChemicalStackKey fromSourceObject(Object key, DataComponentPatch ignored) {
        if (key instanceof Holder) {
            Holder cHolder = (Holder)key;
            boolean isChemHolder = cHolder.unwrapKey().map(ResourceKey::registryKey).filter(MekanismAPI.CHEMICAL_REGISTRY_NAME::equals).isPresent();
            if (isChemHolder) {
                Holder ch = cHolder;
                return new ChemicalStackKey((Holder<Chemical>)ch);
            }
        } else if (key instanceof Chemical) {
            Chemical c = (Chemical)key;
            ResourceLocation rl = MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)c);
            ResourceKey rkey = ResourceKey.create((ResourceKey)MekanismAPI.CHEMICAL_REGISTRY_NAME, (ResourceLocation)rl);
            return MekanismAPI.CHEMICAL_REGISTRY.getHolder(rkey).map(ChemicalStackKey::new).orElse(null);
        }
        return null;
    }

    @Override
    public ChemicalStack getReadOnlyStack() {
        if (this.serverCache == null) {
            ChemicalStack chemicalStack = this.serverCache = this.chemical == MekanismAPI.EMPTY_CHEMICAL_HOLDER ? ChemicalStack.EMPTY : new ChemicalStack(this.chemical, 1L);
        }
        if (this.chemical == MekanismAPI.EMPTY_CHEMICAL_HOLDER) {
            if (!this.serverCache.isEmpty()) {
                this.serverCache = ChemicalStack.EMPTY;
            }
            return ChemicalStack.EMPTY;
        }
        ChemicalStack cache = this.serverCache;
        if (cache.isEmpty() || cache.getChemical() != this.chemical.value()) {
            this.serverCache = new ChemicalStack(this.chemical, 1L);
            return this.serverCache;
        }
        cache.setAmount(1L);
        return cache;
    }

    @Override
    public Class<ChemicalStack> getStackClass() {
        return ChemicalStack.class;
    }

    @NotNull
    public Chemical getSource() {
        return (Chemical)this.chemical.value();
    }

    @Override
    public Class<?> getSourceClass() {
        return Chemical.class;
    }

    @Override
    public String getModId() {
        return this.chemical.unwrapKey().map(k -> k.location().getNamespace()).orElse("mekanism");
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY || this.chemical == MekanismAPI.EMPTY_CHEMICAL_HOLDER;
    }

    public ChemicalStackKey getEmpty() {
        return EMPTY;
    }

    @Override
    public ChemicalStack getEmptyStack() {
        return ChemicalStack.EMPTY;
    }

    @Override
    public ChemicalStack copyStack() {
        return this.copyStackWithCount(1L);
    }

    @Override
    public ChemicalStack copyStackWithCount(long count) {
        if (this.chemical == MekanismAPI.EMPTY_CHEMICAL_HOLDER) {
            return ChemicalStack.EMPTY;
        }
        return new ChemicalStack(this.chemical, count);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return Math.min(64000L, this.getCustomMaxStackSize());
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean hasTag(TagKey<?> tagKey) {
        if (tagKey == null || this.chemical == MekanismAPI.EMPTY_CHEMICAL_HOLDER) {
            return false;
        }
        if (!tagKey.isFor(MekanismAPI.CHEMICAL_REGISTRY_NAME)) {
            return false;
        }
        TagKey<?> chemicalTag = tagKey;
        return this.chemical.is(chemicalTag);
    }

    @Override
    public boolean isSame(IStackKey<?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ChemicalStackKey) {
            ChemicalStackKey o = (ChemicalStackKey)other;
            return this.chemical == o.chemical;
        }
        return false;
    }

    @Override
    public boolean isSameTypeSameComponents(IStackKey<?> other) {
        return this.isSame(other);
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        boolean has = this.chemical != MekanismAPI.EMPTY_CHEMICAL_HOLDER;
        buf.writeBoolean(has);
        if (!has) {
            return;
        }
        Chemical.HOLDER_STREAM_CODEC.encode((Object)buf, this.chemical);
    }

    @NotNull
    public ChemicalStackKey deserialize(RegistryFriendlyByteBuf buf) {
        boolean has = buf.readBoolean();
        if (!has) {
            return EMPTY;
        }
        Holder chemicalHolder = (Holder)Chemical.HOLDER_STREAM_CODEC.decode((Object)buf);
        return new ChemicalStackKey((Holder<Chemical>)chemicalHolder);
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        try {
            RegistryOps ops = levelRegistryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            return CODEC.encodeStart((DynamicOps)ops, (Object)this).resultOrPartial(err -> BeyondDimensions.LOGGER.warn("ChemicalStackKey \u5e8f\u5217\u5316(Codec)\u51fa\u9519: {}", err)).map(nbt -> {
                if (nbt instanceof CompoundTag) {
                    CompoundTag ct = (CompoundTag)nbt;
                    return ct;
                }
                BeyondDimensions.LOGGER.error("ChemicalStackKey \u5e8f\u5217\u5316\u5f97\u5230\u7684 NBT \u975e CompoundTag\uff0c\u5df2\u4e22\u5f03\u8be5\u7ed3\u679c: {}", (Object)nbt.getClass().getName());
                return new CompoundTag();
            }).orElseGet(CompoundTag::new);
        }
        catch (Throwable t) {
            BeyondDimensions.LOGGER.error("ChemicalStackKey \u5e8f\u5217\u5316\u65f6\u51fa\u9519: {}", (Object)t.getMessage(), (Object)t);
            return new CompoundTag();
        }
    }

    @NotNull
    public ChemicalStackKey deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        try {
            RegistryOps ops = levelRegistryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            return CODEC.parse((DynamicOps)ops, (Object)nbt).resultOrPartial(err -> BeyondDimensions.LOGGER.warn("ChemicalStackKey \u53cd\u5e8f\u5217\u5316(Codec)\u51fa\u9519: {} | Keys={}", err, (Object)nbt.getAllKeys())).orElse(EMPTY);
        }
        catch (Throwable t) {
            BeyondDimensions.LOGGER.error("ChemicalStackKey \u53cd\u5e8f\u5217\u5316\u9519\u8bef\u3002Keys={} Error={}", new Object[]{nbt.getAllKeys(), t.getMessage(), t});
            return EMPTY;
        }
    }

    @Override
    @NotNull
    public IStackRender getRender() {
        return ChemicalStackKeyRender.INSTANCE;
    }

    @Override
    @NotNull
    public ChemicalStack getRenderStack() {
        if (this.clientCache == null) {
            ChemicalStack chemicalStack = this.clientCache = this.chemical == MekanismAPI.EMPTY_CHEMICAL_HOLDER ? ChemicalStack.EMPTY : new ChemicalStack(this.chemical, 1L);
        }
        if (this.chemical == MekanismAPI.EMPTY_CHEMICAL_HOLDER) {
            if (!this.clientCache.isEmpty()) {
                this.clientCache = ChemicalStack.EMPTY;
            }
            return ChemicalStack.EMPTY;
        }
        ChemicalStack cache = this.clientCache;
        if (cache.isEmpty() || cache.getChemical() != this.chemical.value()) {
            this.clientCache = new ChemicalStack(this.chemical, 1L);
            return this.clientCache;
        }
        cache.setAmount(1L);
        return cache;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChemicalStackKey)) {
            return false;
        }
        ChemicalStackKey otherKey = (ChemicalStackKey)other;
        Optional a = this.chemical.unwrapKey();
        Optional b = otherKey.chemical.unwrapKey();
        if (a.isPresent() && b.isPresent()) {
            return ((ResourceKey)a.get()).equals(b.get());
        }
        return this.chemical.value() == otherKey.chemical.value();
    }

    @Override
    public int hashCode() {
        if (this.hashCodeCache == 0) {
            this.hashCodeCache = this.chemical.unwrapKey().map(Object::hashCode).orElse(System.identityHashCode(this.chemical.value()));
        }
        return this.hashCodeCache;
    }

    private static Holder<Chemical> resolveBound(Holder<Chemical> h) {
        if (h.unwrapKey().isPresent()) {
            return h;
        }
        ResourceLocation rl = MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)((Chemical)h.value()));
        ResourceKey rk = ResourceKey.create((ResourceKey)MekanismAPI.CHEMICAL_REGISTRY_NAME, (ResourceLocation)rl);
        return MekanismAPI.CHEMICAL_REGISTRY.getHolder(rk).map(r -> r).orElse(MekanismAPI.EMPTY_CHEMICAL_HOLDER);
    }
}

