/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.FluidStackKeyRender;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackRender;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import com.wintercogs.beyonddimensions.Unit.DataComponentPatchHelper;
import com.wintercogs.beyonddimensions.Unit.RegistryAccessResolver;
import com.wintercogs.beyonddimensions.Unit.RegistryUtil;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FluidStackKey
implements IStackKey<FluidStack> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"beyonddimensions", (String)"stack_type/fluid");
    public static final FluidStackKey EMPTY = new FluidStackKey();
    private static final long CUSTOM_MAX_STACK_SIZE = Long.MAX_VALUE;
    private static final MapCodec<FluidStackKey> NEW_FMT = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.FLUID.holderByNameCodec().fieldOf("fluid").forGetter(t -> RegistryUtil.holderOf(t.fluid)), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(t -> t.patch)).apply((Applicative)instance, (holder, patch) -> new FluidStackKey((Fluid)holder.value(), (DataComponentPatch)patch)));
    public static final MapCodec<FluidStackKey> TYPE_CODEC = new MapCodec<FluidStackKey>(){
        private static final String K_FLUID = "fluid";
        private static final String K_COMPS = "components";
        private static final String K_FLUID_OLD = "Fluid";
        private static final String K_COMPS_OLD = "Components";
        private static final String K_LEGACY = "internal_stack";
        private static final String K_STACK = "Stack";
        private static final String K_AMOUNT = "amount";
        private static final String K_AMOUNT_OLD = "Amount";

        public <T> DataResult<FluidStackKey> decode(DynamicOps<T> ops, MapLike<T> input) {
            Object kFluid = ops.createString(K_FLUID);
            Object kComps = ops.createString(K_COMPS);
            Object kFluidOld = ops.createString(K_FLUID_OLD);
            Object kCompsOld = ops.createString(K_COMPS_OLD);
            Object kLegacy = ops.createString(K_LEGACY);
            Object kStack = ops.createString(K_STACK);
            Object kAmt = ops.createString(K_AMOUNT);
            Object kAmtOld = ops.createString(K_AMOUNT_OLD);
            if (input.get(kFluid) != null) {
                DataResult r = NEW_FMT.decode(ops, input);
                if (r.result().isPresent()) {
                    return r;
                }
                Object compsNode = input.get(kComps);
                if (compsNode == null) {
                    compsNode = input.get(kCompsOld);
                }
                DataComponentPatch patch = compsNode == null ? DataComponentPatch.EMPTY : DataComponentPatch.CODEC.parse(ops, compsNode).result().orElse(DataComponentPatch.EMPTY);
                return DataResult.success((Object)new FluidStackKey(Fluids.EMPTY, patch));
            }
            if (input.get(kFluidOld) != null || input.get(kCompsOld) != null) {
                LinkedHashMap map = new LinkedHashMap();
                input.entries().forEach(p -> {
                    Object key = p.getFirst();
                    if (key.equals(kFluidOld)) {
                        key = kFluid;
                    } else if (key.equals(kCompsOld)) {
                        key = kComps;
                    }
                    if (!key.equals(kAmt) && !key.equals(kAmtOld)) {
                        map.put(key, p.getSecond());
                    }
                });
                Object remapped = ops.createMap(map);
                return NEW_FMT.codec().decode(ops, remapped).map(Pair::getFirst);
            }
            Object legacyNode = input.get(kLegacy);
            if (legacyNode == null) {
                legacyNode = input.get(kStack);
            }
            if (legacyNode != null) {
                return FluidStack.OPTIONAL_CODEC.parse(ops, legacyNode).map(FluidStackKey::new);
            }
            return NEW_FMT.decode(ops, input);
        }

        public <T> RecordBuilder<T> encode(FluidStackKey value, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return NEW_FMT.encode((Object)value, ops, prefix);
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(K_FLUID, K_COMPS).map(arg_0 -> ops.createString(arg_0));
        }
    };
    public static final Codec<FluidStackKey> CODEC = TYPE_CODEC.codec();
    private final Fluid fluid;
    private final DataComponentPatch patch;
    private volatile byte[] patchByte = new byte[0];
    private volatile transient WeakReference<HolderLookup.Provider> equalsByteProviderRef = null;
    private FluidStack severCache;
    private FluidStack clientCache;
    private int hashCodeCache = 0;

    private FluidStackKey() {
        this(Fluids.EMPTY, DataComponentPatch.EMPTY);
    }

    public FluidStackKey(FluidStack stack) {
        this(stack.getFluid(), stack.getComponentsPatch());
    }

    private FluidStackKey(Fluid fluid, DataComponentPatch patch) {
        this.fluid = fluid;
        this.patch = patch == null ? DataComponentPatch.EMPTY : patch;
    }

    @Override
    public ResourceLocation getTypeId() {
        return ID;
    }

    @Override
    public MapCodec<FluidStackKey> codec() {
        return TYPE_CODEC;
    }

    @Override
    @Nullable
    public KeyAmount fromStackObject(Object stack) {
        if (stack instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)stack;
            return new KeyAmount(new FluidStackKey(fluidStack), fluidStack.getAmount());
        }
        return null;
    }

    @Nullable
    public FluidStackKey fromSourceObject(Object key, DataComponentPatch dataComponentPatch) {
        if (key instanceof Fluid) {
            Fluid f = (Fluid)key;
            DataComponentPatch p = dataComponentPatch != null && !dataComponentPatch.isEmpty() ? dataComponentPatch : DataComponentPatch.EMPTY;
            return new FluidStackKey(f, p);
        }
        return null;
    }

    @Override
    public FluidStack getReadOnlyStack() {
        if (this.severCache == null) {
            FluidStack fluidStack = this.severCache = this.fluid == Fluids.EMPTY ? FluidStack.EMPTY : new FluidStack(RegistryUtil.holderOf(this.fluid), 1, this.patch);
        }
        if (this.fluid == Fluids.EMPTY) {
            if (!this.severCache.isEmpty()) {
                this.severCache = FluidStack.EMPTY;
            }
            return FluidStack.EMPTY;
        }
        FluidStack cache = this.severCache;
        if (cache.isEmpty() || cache.getFluid() != this.fluid) {
            this.severCache = new FluidStack(RegistryUtil.holderOf(this.fluid), 1, this.patch);
            return this.severCache;
        }
        cache.setAmount(1);
        return cache;
    }

    @Override
    public Class<FluidStack> getStackClass() {
        return FluidStack.class;
    }

    @NotNull
    public Fluid getSource() {
        return this.fluid;
    }

    @Override
    public Class<?> getSourceClass() {
        return Fluid.class;
    }

    @Override
    public String getModId() {
        return BuiltInRegistries.FLUID.getKey((Object)this.fluid).getNamespace();
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY || this.fluid == Fluids.EMPTY;
    }

    public FluidStackKey getEmpty() {
        return EMPTY;
    }

    @Override
    public FluidStack getEmptyStack() {
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack copyStack() {
        return this.copyStackWithCount(1L);
    }

    @Override
    public FluidStack copyStackWithCount(long count) {
        if (this.fluid == Fluids.EMPTY) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(RegistryUtil.holderOf(this.fluid), BDMath.clampLongToInt(count), this.patch);
    }

    @Override
    public long getVanillaMaxStackSize() {
        return Math.min(64000L, this.getCustomMaxStackSize());
    }

    @Override
    public long getCustomMaxStackSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean hasTag(TagKey<?> tagKey) {
        if (tagKey == null || this.fluid == Fluids.EMPTY) {
            return false;
        }
        if (!tagKey.isFor(Registries.FLUID)) {
            return false;
        }
        TagKey<?> fluidTag = tagKey;
        return RegistryUtil.holderOf(this.fluid).is(fluidTag);
    }

    @Override
    public boolean isSame(IStackKey<?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FluidStackKey) {
            FluidStackKey o = (FluidStackKey)other;
            return this.fluid == o.fluid;
        }
        return false;
    }

    @Override
    public boolean isSameTypeSameComponents(IStackKey<?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FluidStackKey) {
            FluidStackKey o = (FluidStackKey)other;
            if (this.fluid != o.fluid) {
                return false;
            }
            this.ensureByte();
            o.ensureByte();
            if (this.patchByte != null && this.patchByte.length > 0 && o.patchByte != null && o.patchByte.length > 0) {
                return Arrays.equals(this.patchByte, o.patchByte);
            }
            return Objects.equals(this.patch, o.patch);
        }
        return false;
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        boolean hasFluid = this.fluid != Fluids.EMPTY;
        buf.writeBoolean(hasFluid);
        if (!hasFluid) {
            return;
        }
        ResourceLocation key = BuiltInRegistries.FLUID.getKey((Object)this.fluid);
        buf.writeResourceLocation(key);
        DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)this.patch);
    }

    @NotNull
    public FluidStackKey deserialize(RegistryFriendlyByteBuf buf) {
        boolean hasFluid = buf.readBoolean();
        if (!hasFluid) {
            return new FluidStackKey(Fluids.EMPTY, DataComponentPatch.EMPTY);
        }
        ResourceLocation key = buf.readResourceLocation();
        Fluid f = (Fluid)BuiltInRegistries.FLUID.get(key);
        DataComponentPatch p = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buf);
        return new FluidStackKey(f, p);
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(HolderLookup.Provider levelRegistryAccess) {
        try {
            RegistryOps ops = levelRegistryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            return CODEC.encodeStart((DynamicOps)ops, (Object)this).resultOrPartial(err -> BeyondDimensions.LOGGER.warn("FluidStackKey \u5e8f\u5217\u5316(Codec)\u51fa\u9519: {}", err)).map(nbt -> {
                if (nbt instanceof CompoundTag) {
                    CompoundTag ct = (CompoundTag)nbt;
                    return ct;
                }
                BeyondDimensions.LOGGER.error("FluidStackKey \u5e8f\u5217\u5316\u5f97\u5230\u7684 NBT \u975e CompoundTag\uff0c\u5df2\u4e22\u5f03\u8be5\u7ed3\u679c: {}", (Object)nbt.getClass().getName());
                return new CompoundTag();
            }).orElseGet(CompoundTag::new);
        }
        catch (Throwable t) {
            BeyondDimensions.LOGGER.error("FluidStackKey \u5e8f\u5217\u5316\u65f6\u51fa\u9519: {}", (Object)t.getMessage(), (Object)t);
            return new CompoundTag();
        }
    }

    @NotNull
    public FluidStackKey deserializeNBT(CompoundTag nbt, HolderLookup.Provider levelRegistryAccess) {
        try {
            RegistryOps ops = levelRegistryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            return CODEC.parse((DynamicOps)ops, (Object)nbt).resultOrPartial(err -> BeyondDimensions.LOGGER.warn("FluidStackKey \u53cd\u5e8f\u5217\u5316(Codec)\u51fa\u9519: {} | Keys={}", err, (Object)nbt.getAllKeys())).orElse(EMPTY);
        }
        catch (Throwable t) {
            BeyondDimensions.LOGGER.error("FluidStackKey \u53cd\u5e8f\u5217\u5316\u9519\u8bef\u3002Keys={} Error={}", new Object[]{nbt.getAllKeys(), t.getMessage(), t});
            return EMPTY;
        }
    }

    @Override
    @NotNull
    public IStackRender getRender() {
        return FluidStackKeyRender.INSTANCE;
    }

    @Override
    @NotNull
    public FluidStack getRenderStack() {
        if (this.clientCache == null) {
            FluidStack fluidStack = this.clientCache = this.fluid == Fluids.EMPTY ? FluidStack.EMPTY : new FluidStack(RegistryUtil.holderOf(this.fluid), 1, this.patch);
        }
        if (this.fluid == Fluids.EMPTY) {
            if (!this.clientCache.isEmpty()) {
                this.clientCache = FluidStack.EMPTY;
            }
            return FluidStack.EMPTY;
        }
        FluidStack cache = this.clientCache;
        if (cache.isEmpty() || cache.getFluid() != this.fluid) {
            this.clientCache = new FluidStack(RegistryUtil.holderOf(this.fluid), 1, this.patch);
            return this.clientCache;
        }
        cache.setAmount(1);
        return cache;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FluidStackKey) {
            FluidStackKey o = (FluidStackKey)other;
            return this.isSameTypeSameComponents(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCodeCache == 0 || this.patchByte == null || this.patchByte.length == 0) {
            this.ensureByte();
            int base = 31 + this.fluid.hashCode();
            int patchPart = this.patchByte != null && this.patchByte.length > 0 ? Arrays.hashCode(this.patchByte) : this.patch.hashCode();
            this.hashCodeCache = 31 * base + patchPart;
        }
        return this.hashCodeCache;
    }

    private void ensureByte() {
        HolderLookup.Provider cached;
        HolderLookup.Provider current = null;
        try {
            current = RegistryAccessResolver.resolve();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HolderLookup.Provider provider = cached = this.equalsByteProviderRef != null ? (HolderLookup.Provider)this.equalsByteProviderRef.get() : null;
        if (this.patchByte != null && this.patchByte.length > 0 && cached != null && cached == current) {
            return;
        }
        try {
            byte[] retry;
            RegistryAccess.Frozen connProv;
            Minecraft mc;
            ClientPacketListener conn;
            HolderLookup.Provider use = current != null ? current : RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
            byte[] out = DataComponentPatchHelper.toCanonicalBytes(this.patch, use);
            if (out.length == 0 && FMLEnvironment.dist == Dist.CLIENT && (conn = (mc = Minecraft.getInstance()).getConnection()) != null && (connProv = conn.registryAccess()) != use && (retry = DataComponentPatchHelper.toCanonicalBytes(this.patch, (HolderLookup.Provider)connProv)).length > 0) {
                out = retry;
                use = connProv;
            }
            this.patchByte = out;
            this.equalsByteProviderRef = out.length > 0 ? new WeakReference<HolderLookup.Provider>(use) : null;
        }
        catch (Throwable t) {
            BeyondDimensions.LOGGER.warn("FluidStackKey \u7ec4\u4ef6\u89c4\u8303\u5316\u5931\u8d25: {}", (Object)t.toString());
            this.patchByte = new byte[0];
            this.equalsByteProviderRef = null;
        }
    }
}

