/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackRender;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.Registry.StackKeyRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IStackKey<T> {
    public static final Codec<IStackKey<?>> CODEC = ResourceLocation.CODEC.dispatch("type", IStackKey::getTypeId, id -> {
        IStackKey type = StackKeyRegistry.getType(id);
        return type.codec();
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, IStackKey<?>> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, IStackKey<?>>(){

        public void encode(RegistryFriendlyByteBuf buf, IStackKey<?> key) {
            buf.writeResourceLocation(key.getTypeId());
            key.serialize(buf);
        }

        @NotNull
        public IStackKey<?> decode(RegistryFriendlyByteBuf buf) {
            ResourceLocation typeId = buf.readResourceLocation();
            IStackKey typePrototype = StackKeyRegistry.getType(typeId);
            return typePrototype.deserialize(buf);
        }
    };

    public ResourceLocation getTypeId();

    public MapCodec<? extends IStackKey<T>> codec();

    @Nullable
    public KeyAmount fromStackObject(Object var1);

    @Nullable
    public IStackKey<T> fromSourceObject(Object var1, DataComponentPatch var2);

    public T getReadOnlyStack();

    public Class<T> getStackClass();

    @NotNull
    public Object getSource();

    public Class<?> getSourceClass();

    public String getModId();

    public boolean isEmpty();

    public IStackKey<T> getEmpty();

    public T getEmptyStack();

    public T copyStack();

    public T copyStackWithCount(long var1);

    public long getVanillaMaxStackSize();

    public long getCustomMaxStackSize();

    public boolean hasTag(TagKey<?> var1);

    public boolean isSame(IStackKey<?> var1);

    public boolean isSameTypeSameComponents(IStackKey<?> var1);

    public void serialize(RegistryFriendlyByteBuf var1);

    @NotNull
    public IStackKey<T> deserialize(RegistryFriendlyByteBuf var1);

    @NotNull
    public CompoundTag serializeNBT(HolderLookup.Provider var1);

    @NotNull
    public IStackKey<T> deserializeNBT(CompoundTag var1, HolderLookup.Provider var2);

    @NotNull
    public IStackRender getRender();

    @NotNull
    public T getRenderStack();

    public int hashCode();

    public boolean equals(Object var1);
}

