/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Stack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.wintercogs.beyonddimensions.Api.DataBase.LongType.WardenSoulType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackRender;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.WardenSoulStackKey;
import com.wintercogs.beyonddimensions.Unit.StringFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.ClientTooltipFlag;
import org.jetbrains.annotations.Nullable;

public class WardenSoulStackKeyRender
implements IStackRender {
    public static final WardenSoulStackKeyRender INSTANCE = new WardenSoulStackKeyRender();
    private static long lastCheckedForParticle = 0L;
    private static final List<GuiParticle> particleList = new ArrayList<GuiParticle>();

    private WardenSoulStackKeyRender() {
    }

    @Override
    public void render(GuiGraphics gui, IStackKey<?> key, int x, int y) {
        int ageTick;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        gui.pose().pushPose();
        ResourceLocation warden_rl = ResourceLocation.withDefaultNamespace((String)"textures/entity/warden/warden.png");
        ResourceLocation warden_hear = ResourceLocation.withDefaultNamespace((String)"textures/entity/warden/warden_heart.png");
        gui.blit(warden_rl, x, y, 12.0f, 14.0f, 16, 16, 128, 128);
        gui.pose().pushPose();
        float heart_timing_total = 30.0f;
        float heart_phase = 1.0f - (float)(mc.level.getGameTime() % (long)heart_timing_total) / heart_timing_total;
        RenderSystem.setShaderColor((float)heart_phase, (float)heart_phase, (float)heart_phase, (float)heart_phase);
        gui.blit(warden_hear, x - 1, y - 1, 11.0f, 13.0f, 18, 18, 128, 128);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.pose().popPose();
        long rotation = mc.level.getGameTime() % 160L - 80L;
        gui.pose().pushPose();
        gui.pose().translate((float)x, (float)(y - 1), 100.0f);
        gui.pose().mulPose(Axis.YP.rotationDegrees((float)rotation));
        gui.blit(warden_rl, 0, 0, 91.0f, 13.0f, 17, 18, 128, 128);
        gui.pose().popPose();
        gui.pose().pushPose();
        gui.pose().translate((float)(x + 16), (float)(y + 17), 100.0f);
        gui.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
        gui.pose().mulPose(Axis.YP.rotationDegrees((float)rotation));
        gui.blit(warden_rl, 0, 0, 91.0f, 13.0f, 17, 18, 128, 128);
        gui.pose().popPose();
        gui.pose().scale(0.75f, 0.75f, 0.75f);
        double spawnChance = 0.05;
        int xSize = 8;
        int ySize = 6;
        long now = mc.level.getGameTime();
        if (lastCheckedForParticle != now) {
            if (mc.level.random.nextDouble() <= spawnChance) {
                particleList.add(new GuiParticle(mc.level.random.nextInt(xSize), ySize - mc.level.random.nextInt(3), now));
            }
            lastCheckedForParticle = now;
        }
        if (now % (long)(ageTick = 3) == 0L) {
            particleList.removeIf(p -> (now - p.age) / (long)ageTick > 10L);
        }
        gui.pose().translate(0.0f, 0.0f, 200.0f);
        for (GuiParticle p2 : particleList.reversed()) {
            double age = (double)(now - p2.age) / (double)ageTick;
            double extraY = (double)(ySize - 32) / 20.0 * age;
            int frame = Math.max(0, Math.min(10, (int)age));
            gui.blit(ResourceLocation.withDefaultNamespace((String)("textures/particle/sculk_soul_" + frame + ".png")), (int)((float)(x + p2.x) * 1.3333334f), (int)((float)((int)((double)(y + p2.y) + extraY)) * 1.3333334f), 0.0f, 0.0f, 16, 16, 16, 16);
        }
        gui.pose().popPose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    @Override
    public void renderAmount(GuiGraphics gui, long amount, int x, int y) {
        String text = this.getCountText(amount);
        if (text.isEmpty()) {
            return;
        }
        float scale = 0.666f;
        PoseStack pose = gui.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 200.0f);
        pose.scale(scale, scale, scale);
        RenderSystem.disableBlend();
        int w = Minecraft.getInstance().font.width(text);
        int X = (int)(((float)(x - 1) + 16.0f + 2.0f - (float)w * 0.666f) / 0.666f);
        int Y = (int)(((float)(y - 1) + 16.0f - 3.33f) / 0.666f);
        gui.drawString(Minecraft.getInstance().font, text, X, Y, 0xFFFFFF);
        pose.popPose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    @Override
    public String getCountText(long count) {
        if (count < 0L) {
            return "";
        }
        return StringFormat.formatCount(count);
    }

    @Override
    public Component getDisplayName(IStackKey<?> key) {
        return ((WardenSoulType)WardenSoulStackKey.INSTANCE.getRenderStack()).getName();
    }

    @Override
    public List<Component> getTooltipLines(IStackKey<?> key, long amount, Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        return List.of(this.getDisplayName(key), Component.translatable((String)"istack.beyonddimensions.storage_num.long_type", (Object[])new Object[]{amount}));
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(IStackKey<?> key) {
        return Optional.empty();
    }

    @Override
    public void renderTooltip(GuiGraphics gui, Font font, IStackKey<?> key, long amount, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getInstance();
        Item.TooltipContext ctx = mc.level != null ? Item.TooltipContext.of((Level)mc.level) : Item.TooltipContext.EMPTY;
        gui.renderTooltip(mc.font, this.getTooltipLines(key, amount, ctx, (Player)mc.player, ClientTooltipFlag.of((TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL))), this.getTooltipImage(key), ItemStack.EMPTY, mouseX, mouseY);
    }

    private static final class GuiParticle {
        final int x;
        final int y;
        final long age;

        GuiParticle(int x, int y, long age) {
            this.x = x;
            this.y = y;
            this.age = age;
        }
    }
}

