/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper;

import com.wintercogs.beyonddimensions.Api.DataBase.LongType.EnergyType;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyHandlerWrapper
implements IStackHandlerWrapper<EnergyType> {
    private final IEnergyStorage energyStorage;

    public EnergyHandlerWrapper(Object energyStorage) {
        this.energyStorage = (IEnergyStorage)energyStorage;
    }

    @Override
    public ResourceLocation getTypeId() {
        return EnergyStackKey.ID;
    }

    @Override
    public int getSlots() {
        return 1;
    }

    @Override
    public EnergyType getStackInSlot(int slot) {
        return new EnergyType(this.energyStorage.getEnergyStored());
    }

    @Override
    public long getCapacity(int slot) {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public boolean isStackValid(int slot, EnergyType stack) {
        return true;
    }

    @Override
    public long insert(int slot, EnergyType stack, boolean sim) {
        long amount = stack.getStackCount();
        int insertAmount = amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount;
        int accepted = this.energyStorage.receiveEnergy(insertAmount, sim);
        return amount - (long)accepted;
    }

    @Override
    public long insert(EnergyType stack, boolean sim) {
        long amount = stack.getStackCount();
        int insertAmount = amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount;
        int accepted = this.energyStorage.receiveEnergy(insertAmount, sim);
        return amount - (long)accepted;
    }

    @Override
    public long extract(int slot, long amount, boolean sim) {
        int extractAmount;
        int n = extractAmount = amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount;
        if (extractAmount < 0) {
            extractAmount = 0;
        }
        return this.energyStorage.extractEnergy(extractAmount, sim);
    }

    @Override
    public long extract(EnergyType stack, boolean sim) {
        int extractAmount;
        int n = extractAmount = stack.getStackCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)stack.getStackCount();
        if (extractAmount < 0) {
            extractAmount = 0;
        }
        return this.energyStorage.extractEnergy(extractAmount, sim);
    }
}

