/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ChemicalStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import org.jetbrains.annotations.NotNull;

public class ChemicalUnifiedStorageHandler
implements IChemicalHandler {
    private final UnifiedStorage storage;

    public ChemicalUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int getChemicalTanks() {
        return this.storage.getBucket(ChemicalStackKey.ID).map(list -> this.storage.isFullSlotsSize() ? list.size() : list.size() + 1).orElse(this.storage.isFullSlotsSize() ? 0 : 1);
    }

    @NotNull
    public ChemicalStack getChemicalInTank(int slot) {
        return this.storage.getBucket(ChemicalStackKey.ID).filter(slots -> slot >= 0 && slot < slots.size()).map(slots -> slots.get(slot)).map(key -> {
            Object outStack = this.storage.getOutStackByKey((IStackKey<?>)key);
            if (outStack instanceof ChemicalStack) {
                ChemicalStack chemicalStack = (ChemicalStack)outStack;
                if (!chemicalStack.isEmpty()) {
                    chemicalStack.setAmount(this.storage.getStackByKey((IStackKey<?>)key).amount());
                }
                return chemicalStack;
            }
            return null;
        }).orElse(ChemicalStack.EMPTY);
    }

    public void setChemicalInTank(int tank, ChemicalStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        this.storage.insert(new ChemicalStackKey(stack), stack.getAmount(), false);
    }

    public long getChemicalTankCapacity(int tank) {
        return this.storage.getSlotCapacity(0);
    }

    public boolean isValid(int tank, @NotNull ChemicalStack stack) {
        return true;
    }

    @NotNull
    public ChemicalStack insertChemical(int tank, ChemicalStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        long remaining = this.storage.insert(new ChemicalStackKey(stack), stack.getAmount(), action.simulate()).amount();
        if (remaining > 0L) {
            return stack.copyWithAmount(remaining);
        }
        return ChemicalStack.EMPTY;
    }

    @NotNull
    public ChemicalStack extractChemical(int tank, long amount, Action action) {
        Object object = this.storage.extract(new ChemicalStackKey(this.getChemicalInTank(tank)), amount, action.simulate()).toStack();
        if (object instanceof ChemicalStack) {
            ChemicalStack result = (ChemicalStack)object;
            return result;
        }
        return ChemicalStack.EMPTY;
    }

    @NotNull
    public ChemicalStack insertChemical(ChemicalStack stack, @NotNull Action action) {
        if (stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        long remaining = this.storage.insert(new ChemicalStackKey(stack), stack.getAmount(), action.simulate()).amount();
        if (remaining > 0L) {
            return stack.copyWithAmount(remaining);
        }
        return ChemicalStack.EMPTY;
    }

    @NotNull
    public ChemicalStack extractChemical(long amount, Action action) {
        Object object = this.storage.extract(new ChemicalStackKey(this.getChemicalInTank(0)), amount, action.simulate()).toStack();
        if (object instanceof ChemicalStack) {
            ChemicalStack result = (ChemicalStack)object;
            return result;
        }
        return ChemicalStack.EMPTY;
    }

    @NotNull
    public ChemicalStack extractChemical(@NotNull ChemicalStack stack, Action action) {
        Object object = this.storage.extract(new ChemicalStackKey(stack), stack.getAmount(), action.simulate()).toStack();
        if (object instanceof ChemicalStack) {
            ChemicalStack result = (ChemicalStack)object;
            return result;
        }
        return ChemicalStack.EMPTY;
    }
}

