/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EnergyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Unit.BDMath;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyUnifiedStorageHandler
implements IEnergyStorage {
    private final UnifiedStorage storage;

    public EnergyUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public int receiveEnergy(int count, boolean simulate) {
        return (int)((long)count - this.storage.insert(EnergyStackKey.INSTANCE, count, simulate).amount());
    }

    public int extractEnergy(int count, boolean simulate) {
        return (int)this.storage.extract(EnergyStackKey.INSTANCE, (long)count, simulate).amount();
    }

    public int getEnergyStored() {
        return BDMath.clampLongToInt(this.storage.getStackByKey(EnergyStackKey.INSTANCE).amount());
    }

    public int getMaxEnergyStored() {
        return BDMath.clampLongToInt(this.storage.getSlotCapacity(0));
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

