/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Api.DataBase.Storage;

import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.SourceStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.BeyondDimensions;
import com.wintercogs.beyonddimensions.Unit.BDMath;

public class SourceUnifiedStorageHandler
implements ISourceCap {
    private UnifiedStorage storage;

    public SourceUnifiedStorageHandler(UnifiedStorage storage) {
        this.storage = storage;
    }

    public boolean canAcceptSource(int amount) {
        return this.receiveSource(amount, true) > 0;
    }

    public boolean canProvideSource(int amount) {
        return this.extractSource(amount, true) > 0;
    }

    public int getMaxExtract() {
        return Integer.MAX_VALUE;
    }

    public int getMaxReceive() {
        return Integer.MAX_VALUE;
    }

    public int getSource() {
        return BDMath.clampLongToInt(this.storage.getStackByKey(SourceStackKey.INSTANCE).amount());
    }

    public int getSourceCapacity() {
        return BDMath.clampLongToInt(this.storage.getSlotCapacity(0));
    }

    public int getMaxSource() {
        return this.getSourceCapacity();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public void setSource(int amount) {
        int wanted = BDMath.clampLongToInt(this.storage.getSlotCapacity(0));
        long actualInside = this.getSource();
        long operation = (long)wanted - actualInside;
        BeyondDimensions.LOGGER.info("\u67d0\u4e2a\u7f51\u7edc\u7684\u9b54\u6e90\u6570\u91cf\u88ab\u5916\u754c\u5f3a\u884c\u8bbe\u7f6e\uff0c\u53ef\u80fd\u5bfc\u81f4\u9519\u8bef\uff0c\u6700\u7ec8\u9b54\u6e90\u6570\u91cf\u88ab\u8bbe\u7f6e\u4e3a\uff1a{}", (Object)operation);
        if (operation > 0L) {
            this.storage.insert(SourceStackKey.INSTANCE, operation, false);
        } else {
            this.storage.extract(SourceStackKey.INSTANCE, -operation, false);
        }
    }

    public void setMaxSource(int max) {
    }

    public int receiveSource(int amount, boolean sim) {
        return (int)((long)amount - this.storage.insert(SourceStackKey.INSTANCE, amount, sim).amount());
    }

    public int extractSource(int amount, boolean sim) {
        return (int)this.storage.extract(SourceStackKey.INSTANCE, (long)amount, sim).amount();
    }
}

