/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.Registry.CapabilityHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackHandlerWrapperHelper;
import com.wintercogs.beyonddimensions.Api.Util.CapCtx;
import com.wintercogs.beyonddimensions.Api.Util.CommonHandler;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.BaseMachineBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Config;
import com.wintercogs.beyonddimensions.DataComponents.ModDataComponents;
import com.wintercogs.beyonddimensions.Item.Custom.MatterCompressionBall;
import com.wintercogs.beyonddimensions.Item.ModItems;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Menu.NetInterfaceBaseMenu;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public class NetInterfaceBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    private static final int capacity = Config.interfaceUsableCapacity;
    private final StackHandler fakeStackHandler = new StackHandler(capacity){

        @Override
        public void onChange() {
            if (NetInterfaceBlockEntity.this.level != null && !NetInterfaceBlockEntity.this.level.isClientSide()) {
                NetInterfaceBlockEntity.this.level.blockEntityChanged(NetInterfaceBlockEntity.this.worldPosition);
            }
        }
    };
    private final StackHandler stackHandler = new StackHandler(capacity){

        @Override
        public void onChange() {
            if (NetInterfaceBlockEntity.this.level != null && !NetInterfaceBlockEntity.this.level.isClientSide()) {
                NetInterfaceBlockEntity.this.level.blockEntityChanged(NetInterfaceBlockEntity.this.worldPosition);
            }
        }
    };
    public PopMode popMode = PopMode.STOP;
    private final Direction[] directions = Direction.values();
    private int redstoneLevel = 0;
    private final Multimap<ResourceLocation, Object> handlerCache = ArrayListMultimap.create();
    private boolean needsCapabilityUpdate = true;

    public StackHandler getStackHandler() {
        return this.stackHandler;
    }

    public StackHandler getFakeStackHandler() {
        return this.fakeStackHandler;
    }

    public int getRedstoneLevel() {
        return this.redstoneLevel;
    }

    public NetInterfaceBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_INTERFACE_BLOCK_ENTITY.get(), pos, blockState);
    }

    @Override
    public boolean shouldWork() {
        int empty = this.stackHandler.getBucket(EmptyStackKey.INSTANCE).map(StackHandler.SlotBucket::size).orElse(this.stackHandler.getSlots());
        int notEmpty = this.stackHandler.getSlots() - empty;
        int newRedstoneLevel = (int)((float)notEmpty / (float)this.stackHandler.getSlots() * 15.0f);
        if (this.redstoneLevel != newRedstoneLevel) {
            this.redstoneLevel = newRedstoneLevel;
            this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        }
        return super.shouldWork();
    }

    @Override
    public void workContent() {
        super.workContent();
        if (this.getNet() != null) {
            if (Config.interfaceCanReceiveResource) {
                this.transferToNet();
            }
            if (Config.interfaceCanOutputResource) {
                this.transferFromNet();
            }
        }
        if (Config.interfaceCanPopResource && this.popMode == PopMode.OPEN) {
            this.updateCapabilityCache();
            this.popStack();
        }
    }

    public void updateCapabilityCache() {
        if (this.level == null || !this.needsCapabilityUpdate) {
            return;
        }
        this.handlerCache.clear();
        for (Direction dir : this.directions) {
            BlockPos targetPos = this.getBlockPos().relative(dir);
            BlockEntity neighbor = this.level.getBlockEntity(targetPos);
            if (neighbor == null || neighbor instanceof NetedBlockEntity) continue;
            CapabilityHelper.BlockCapabilityMap.forEach((resourceLocation, cap) -> {
                Object handler = this.level.getCapability(cap, targetPos, (Object)dir.getOpposite());
                if (handler != null) {
                    this.handlerCache.put(resourceLocation, handler);
                }
            });
        }
        this.needsCapabilityUpdate = false;
    }

    public void setNeedsCapabilityUpdate() {
        this.needsCapabilityUpdate = true;
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.setNeedsCapabilityUpdate();
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        CapabilityHelper.BlockCapabilityMap.forEach((resourceLocation, directionBlockCapability) -> {
            CommonHandler handler = CapabilityHelper.CommonHandlerMap.get(resourceLocation);
            event.registerBlockEntity(directionBlockCapability, ModBlockEntities.NET_INTERFACE_BLOCK_ENTITY.get(), (be, side) -> {
                if (handler != null) {
                    if (handler.isContextual()) {
                        return handler.apply(be.stackHandler, new CapCtx(be.level, be.getBlockPos(), (BlockEntity)be));
                    }
                    return handler.apply(be.stackHandler, null);
                }
                return null;
            });
        });
    }

    public void transferToNet() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (int i = 0; i < capacity; ++i) {
                KeyAmount stack;
                KeyAmount flag = this.fakeStackHandler.getStackBySlot(i);
                if (!flag.isEmpty() && flag.key().isSameTypeSameComponents(this.stackHandler.getStackBySlot(i).key()) || (stack = this.stackHandler.getStackBySlot(i)).isEmpty()) continue;
                KeyAmount extracted = this.stackHandler.extract(i, stack.amount(), false);
                KeyAmount remaining = net.getUnifiedStorage().insert(extracted.key(), extracted.amount(), false);
                if (remaining.isEmpty()) continue;
                this.stackHandler.insert(i, remaining.key(), remaining.amount(), false);
            }
        }
    }

    public void transferFromNet() {
        DimensionsNet net = this.getNet();
        if (net != null) {
            for (int i = 0; i < capacity; ++i) {
                KeyAmount remaining;
                KeyAmount stack;
                KeyAmount current;
                KeyAmount flag = this.fakeStackHandler.getStackBySlot(i);
                if (flag.isEmpty() || !(current = this.stackHandler.getStackBySlot(i)).isEmpty() && (current.key().getVanillaMaxStackSize() >= current.amount() || !current.key().isSameTypeSameComponents(flag.key())) || (stack = net.getUnifiedStorage().extract(flag.key(), flag.key().getVanillaMaxStackSize(), false)).isEmpty() || (remaining = this.stackHandler.insert(i, stack.key(), stack.amount(), false)).isEmpty()) continue;
                net.getUnifiedStorage().insert(remaining.key(), remaining.amount(), false);
            }
        }
    }

    public void popStack() {
        this.handlerCache.forEach((typeId, handler) -> {
            Function<?, IStackHandlerWrapper<?>> handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId);
            IStackHandlerWrapper<?> stackHandlerWrapper = handlerGetter.apply(handler);
            block0: for (int i = 0; i < capacity; ++i) {
                if (!this.fakeStackHandler.getStackBySlot(i).key().getTypeId().equals(typeId) || !this.fakeStackHandler.getStackBySlot(i).key().isSameTypeSameComponents(this.stackHandler.getStackBySlot(i).key())) continue;
                KeyAmount current = this.stackHandler.getStackBySlot(i);
                for (int slot = 0; slot < stackHandlerWrapper.getSlots(); ++slot) {
                    long remainging = stackHandlerWrapper.insert(slot, current.toStack(), false);
                    long extract = current.amount() - remainging;
                    this.stackHandler.extract(i, extract, false);
                    current = new KeyAmount(current.key(), current.amount() - extract);
                    if (current.isEmpty()) continue block0;
                }
            }
        });
    }

    public void dropContent() {
        ArrayList<KeyAmount> dropList = new ArrayList<KeyAmount>();
        for (KeyAmount stack : this.stackHandler.getStorage()) {
            if (stack.isEmpty()) continue;
            IStackKey<?> iStackKey = stack.key();
            if (iStackKey instanceof ItemStackKey) {
                ItemStackKey itemStackKey = (ItemStackKey)iStackKey;
                if (itemStackKey.getSource() instanceof MatterCompressionBall) {
                    Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)itemStackKey.copyStackWithCount(stack.amount()));
                    continue;
                }
                dropList.add(stack);
                continue;
            }
            dropList.add(stack);
        }
        ItemStack ball = new ItemStack((ItemLike)ModItems.MATTER_COMPRESS_BALL.get(), 1);
        if (!dropList.isEmpty()) {
            ball.set(ModDataComponents.ISTACK_SLOTS, dropList);
            Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)ball);
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.stackHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        this.fakeStackHandler.deserializeNBT(registries, tag.getCompound("flags"));
        String popModeNew = tag.getString("popMode");
        this.popMode = !popModeNew.isEmpty() ? PopMode.valueOf(popModeNew) : (tag.getBoolean("popMode") ? PopMode.OPEN : PopMode.STOP);
        this.setNeedsCapabilityUpdate();
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.stackHandler.serializeNBT(registries));
        tag.put("flags", (Tag)this.fakeStackHandler.serializeNBT(registries));
        tag.putString("popMode", this.popMode.name());
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.title.beyonddimensions.net_interface_menu");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new NetInterfaceBaseMenu(containerId, player.getInventory(), this);
    }

    @Override
    public int getTicksPerWork() {
        return 9;
    }
}

