/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.BlockEntity.Custom;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Handler.StackHandler;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.StackHandlerWrapper.IStackHandlerWrapper;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Api.Registry.CapabilityHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackHandlerWrapperHelper;
import com.wintercogs.beyonddimensions.Api.Registry.StackKeyRegistry;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.BaseMachineBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.Custom.NetedBlockEntity;
import com.wintercogs.beyonddimensions.BlockEntity.ModBlockEntities;
import com.wintercogs.beyonddimensions.Machine.FilterMode;
import com.wintercogs.beyonddimensions.Menu.NetPumpMenu;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class NetPumpBlockEntity
extends BaseMachineBlockEntity
implements MenuProvider {
    private final Multimap<ResourceLocation, Object> handlerCache = ArrayListMultimap.create();
    private boolean needsCapabilityUpdate = true;
    private final Direction[] directions = Direction.values();
    private static final int capacity = 36;
    private final StackHandler filterSlots = new StackHandler(36){

        @Override
        public void onChange() {
            if (NetPumpBlockEntity.this.level != null && !NetPumpBlockEntity.this.level.isClientSide()) {
                NetPumpBlockEntity.this.level.blockEntityChanged(NetPumpBlockEntity.this.worldPosition);
            }
        }
    };
    public FilterMode filterMode = FilterMode.BLACK;

    public NetPumpBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.NET_PUMP_BLOCK_ENTITY.get(), pos, blockState);
    }

    @Override
    public boolean shouldWork() {
        return super.shouldWork() && this.getNet() != null;
    }

    @Override
    public int getTicksPerWork() {
        return 10;
    }

    @Override
    public void workStart() {
        if (this.level == null || !this.needsCapabilityUpdate) {
            return;
        }
        this.handlerCache.clear();
        for (Direction dir : this.directions) {
            BlockPos targetPos = this.getBlockPos().relative(dir);
            BlockEntity neighbor = this.level.getBlockEntity(targetPos);
            if (neighbor == null || neighbor instanceof NetedBlockEntity) continue;
            CapabilityHelper.BlockCapabilityMap.forEach((resourceLocation, cap) -> {
                Object handler = this.level.getCapability(cap, targetPos, (Object)dir.getOpposite());
                if (handler != null) {
                    this.handlerCache.put(resourceLocation, handler);
                }
            });
        }
        this.needsCapabilityUpdate = false;
    }

    @Override
    public void workContent() {
        this.handlerCache.forEach((typeId, handler) -> {
            Function<?, IStackHandlerWrapper<?>> handlerGetter = StackHandlerWrapperHelper.stackWrappers.get(typeId);
            IStackHandlerWrapper<?> stackHandlerWrapper = handlerGetter.apply(handler);
            for (int slot = 0; slot < stackHandlerWrapper.getSlots(); ++slot) {
                DimensionsNet net;
                Object stack = stackHandlerWrapper.getStackInSlot(slot);
                IStackKey typeKey = StackKeyRegistry.getType(typeId);
                KeyAmount ka = typeKey.fromStackObject(stack);
                if (ka == null || ka.key().isEmpty() || !this.matchesFilter(ka.key()) || (net = this.getNet()) == null) continue;
                UnifiedStorage storage = net.getUnifiedStorage();
                long canInsert = ka.amount() - storage.insert(ka.key(), ka.amount(), true).amount();
                canInsert = Math.min(canInsert, ka.amount());
                long extract = stackHandlerWrapper.extract(slot, canInsert, false);
                net.getUnifiedStorage().insert(ka.key(), extract, false);
            }
        });
    }

    private boolean matchesFilter(IStackKey<?> otherStack) {
        switch (this.filterMode) {
            case BLACK: {
                for (KeyAmount stack : this.filterSlots.getStorage()) {
                    if (!stack.key().isSame(otherStack)) continue;
                    return false;
                }
                return true;
            }
            case WHITE: {
                for (KeyAmount stack : this.filterSlots.getStorage()) {
                    if (!stack.key().isSame(otherStack)) continue;
                    return true;
                }
                return false;
            }
            case IGNORE: {
                return true;
            }
        }
        return false;
    }

    public void setNeedsCapabilityUpdate() {
        this.needsCapabilityUpdate = true;
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.setNeedsCapabilityUpdate();
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.filterSlots.deserializeNBT(registries, tag.getCompound("filter_slots"));
        this.filterMode = FilterMode.valueOf(tag.getString("filter_type"));
        this.setNeedsCapabilityUpdate();
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("filter_slots", (Tag)this.filterSlots.serializeNBT(registries));
        tag.putString("filter_type", this.filterMode.name());
    }

    public Component getDisplayName() {
        return Component.translatable((String)"menu.title.beyonddimensions.pump_menu");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new NetPumpMenu(containerId, inventory, this.filterSlots, this);
    }
}

