/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.GUI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wintercogs.beyonddimensions.GUI.BDBaseGUI;
import com.wintercogs.beyonddimensions.GUI.CommonTexturesRender;
import com.wintercogs.beyonddimensions.GUI.SharedWidget.RightTabButton;
import com.wintercogs.beyonddimensions.Machine.AutoSortMode;
import com.wintercogs.beyonddimensions.Machine.PopMode;
import com.wintercogs.beyonddimensions.Machine.ReceiveMode;
import com.wintercogs.beyonddimensions.Machine.RedStoneControlMode;
import com.wintercogs.beyonddimensions.Menu.NetFurnaceMenu;
import com.wintercogs.beyonddimensions.Render.GuiRenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class NetFurnaceGUI
extends BDBaseGUI<NetFurnaceMenu> {
    private RightTabButton popModeButton;
    private RightTabButton controlModeButton;
    private RightTabButton receiveModeButton;
    private RightTabButton sortModeButton;

    public NetFurnaceGUI(NetFurnaceMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void init() {
        this.imageWidth = 230;
        this.imageHeight = 210;
        this.rebuildLabelHeight();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.popModeButton = new RightTabButton(this.leftPos + this.imageWidth, this.topPos + 6, 23, 26, this.leftPos + this.imageWidth + 3, this.topPos + 6 + 4, 16, 16, button -> {
            this.popModeButton.toggleState();
            ((NetFurnaceMenu)this.menu).be.popMode = (PopMode)this.popModeButton.currentState;
            ((NetFurnaceMenu)this.menu).writeAndSendQuickData();
        }){

            @Override
            protected void initButton() {
                this.iconMap.put(PopMode.OPEN, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/popmode_up"));
                this.iconMap.put(PopMode.STOP, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/popmode_down"));
                this.tooltipMap.put(PopMode.OPEN, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.popmode_on")));
                this.tooltipMap.put(PopMode.STOP, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.popmode_off")));
                for (Enum state : this.iconMap.keySet()) {
                    this.states.add(state);
                }
                this.setState(((NetFurnaceMenu)((NetFurnaceGUI)NetFurnaceGUI.this).menu).be.popMode);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.popModeButton);
        this.receiveModeButton = new RightTabButton(this.leftPos + this.imageWidth, this.topPos + 36, 23, 26, this.leftPos + this.imageWidth + 3, this.topPos + 36 + 4, 16, 16, button -> {
            this.receiveModeButton.toggleState();
            ((NetFurnaceMenu)this.menu).be.receiveMode = (ReceiveMode)this.receiveModeButton.currentState;
            ((NetFurnaceMenu)this.menu).writeAndSendQuickData();
        }){

            @Override
            protected void initButton() {
                this.iconMap.put(ReceiveMode.STOP, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/net_disable"));
                this.iconMap.put(ReceiveMode.OPEN, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/net_absorb"));
                this.tooltipMap.put(ReceiveMode.STOP, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.receive_mode_stop")));
                this.tooltipMap.put(ReceiveMode.OPEN, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.receive_mode_open")));
                for (Enum state : this.iconMap.keySet()) {
                    this.states.add(state);
                }
                this.setState(((NetFurnaceMenu)((NetFurnaceGUI)NetFurnaceGUI.this).menu).be.receiveMode);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.receiveModeButton);
        this.controlModeButton = new RightTabButton(this.leftPos + this.imageWidth, this.topPos + 66, 23, 26, this.leftPos + this.imageWidth + 3, this.topPos + 66 + 4, 16, 16, button -> {
            this.controlModeButton.toggleState();
            ((NetFurnaceMenu)this.menu).be.controlMode = (RedStoneControlMode)this.controlModeButton.currentState;
            ((NetFurnaceMenu)this.menu).writeAndSendQuickData();
        }){

            @Override
            protected void initButton() {
                this.iconMap.put(RedStoneControlMode.IGNORE, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_ignore"));
                this.iconMap.put(RedStoneControlMode.NOT_WORKING, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_not_working"));
                this.iconMap.put(RedStoneControlMode.POWERED, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_powered"));
                this.iconMap.put(RedStoneControlMode.UNPOWERED, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/control_mode_unpowered"));
                this.tooltipMap.put(RedStoneControlMode.IGNORE, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_ignore")));
                this.tooltipMap.put(RedStoneControlMode.NOT_WORKING, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_not_working")));
                this.tooltipMap.put(RedStoneControlMode.POWERED, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_powered")));
                this.tooltipMap.put(RedStoneControlMode.UNPOWERED, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.control_mode_unpowered")));
                for (Enum state : this.iconMap.keySet()) {
                    this.states.add(state);
                }
                this.setState(((NetFurnaceMenu)((NetFurnaceGUI)NetFurnaceGUI.this).menu).be.controlMode);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.controlModeButton);
        this.sortModeButton = new RightTabButton(this.leftPos + this.imageWidth, this.topPos + 96, 23, 26, this.leftPos + this.imageWidth + 3, this.topPos + 96 + 4, 16, 16, button -> {
            this.sortModeButton.toggleState();
            ((NetFurnaceMenu)this.menu).be.sortMode = (AutoSortMode)this.sortModeButton.currentState;
            ((NetFurnaceMenu)this.menu).writeAndSendQuickData();
        }){

            @Override
            protected void initButton() {
                this.iconMap.put(AutoSortMode.OPEN, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/sort_mode_open"));
                this.iconMap.put(AutoSortMode.STOP, ResourceLocation.tryBuild((String)"beyonddimensions", (String)"widget/sort_mode_stop"));
                this.tooltipMap.put(AutoSortMode.OPEN, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.sort_mode_open")));
                this.tooltipMap.put(AutoSortMode.STOP, Tooltip.create((Component)Component.translatable((String)"tooltip.button.beyonddimensions.sort_mode_stop")));
                for (Enum state : this.iconMap.keySet()) {
                    this.states.add(state);
                }
                this.setState(((NetFurnaceMenu)((NetFurnaceGUI)NetFurnaceGUI.this).menu).be.sortMode);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.sortModeButton);
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        if (this.controlModeButton.currentState != ((NetFurnaceMenu)this.menu).be.controlMode) {
            this.controlModeButton.setState(((NetFurnaceMenu)this.menu).be.controlMode);
        }
        if (this.popModeButton.currentState != ((NetFurnaceMenu)this.menu).be.popMode) {
            this.popModeButton.setState(((NetFurnaceMenu)this.menu).be.popMode);
        }
        if (this.receiveModeButton.currentState != ((NetFurnaceMenu)this.menu).be.receiveMode) {
            this.receiveModeButton.setState(((NetFurnaceMenu)this.menu).be.receiveMode);
        }
        if (this.sortModeButton.currentState != ((NetFurnaceMenu)this.menu).be.sortMode) {
            this.sortModeButton.setState(((NetFurnaceMenu)this.menu).be.sortMode);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        float progress;
        int i;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CommonTexturesRender.renderNetFurnaceBackground(guiGraphics, this.leftPos, new int[]{this.topPos});
        for (i = 0; i < ((NetFurnaceMenu)this.menu).be.getCapacity(); ++i) {
            progress = (float)((NetFurnaceMenu)this.menu).be.getCookTime().get(i).intValue() / (float)((NetFurnaceMenu)this.menu).be.getCookTimeTotal().get(i).intValue();
            CommonTexturesRender.renderWorkDoneV_AsProgress(guiGraphics, this.leftPos + 32 + i * 19, new int[]{this.topPos + 61}, 14, 19, progress);
        }
        for (i = 0; i < ((NetFurnaceMenu)this.menu).be.getCapacity(); ++i) {
            progress = (float)((NetFurnaceMenu)this.menu).be.getLitTime().get(i).intValue() / (float)((NetFurnaceMenu)this.menu).be.getLitDuration().get(i).intValue();
            CommonTexturesRender.renderFurnaceWorkV_AsProgress(guiGraphics, this.leftPos + 33 + i * 19, new int[]{this.topPos + 109}, 12, 12, progress);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"menu.label.beyonddimensions.input_filter_slots"), 6, 27, 0x404040, false);
        GuiRenderHelper.drawRightAnchoredText(guiGraphics, this.font, (Component)Component.translatable((String)"menu.label.beyonddimensions.fuel_filter_slots"), 224, 27, 0x404040, false);
    }

    protected int rebuildImageHeight() {
        return 210;
    }

    protected void rebuildLabelHeight() {
        this.titleLabelY = 8;
        this.inventoryLabelX = 6;
        this.inventoryLabelY = 190;
    }
}

