/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.EMI.Recipe;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Menu.DimensionsCraftMenu;
import com.wintercogs.beyonddimensions.Menu.Slot.AbstractStackTypedSlot;
import com.wintercogs.beyonddimensions.Packet.RecipeFillC2SPacket;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class NetRecipeHandler<T extends DimensionsCraftMenu>
implements StandardRecipeHandler<T> {
    public List<Slot> getInputSources(T handler) {
        ArrayList<Slot> inputSlots = new ArrayList<Slot>();
        for (Slot slot : ((DimensionsCraftMenu)((Object)handler)).slots) {
            if (slot instanceof ResultSlot || slot instanceof AbstractStackTypedSlot) continue;
            inputSlots.add(slot);
        }
        return inputSlots;
    }

    public List<Slot> getCraftingSlots(T handler) {
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>();
        for (int i = ((DimensionsCraftMenu)((Object)handler)).craftSlotStartIndex; i < ((DimensionsCraftMenu)((Object)handler)).craftSlotEndIndex; ++i) {
            craftingSlots.add((Slot)((DimensionsCraftMenu)((Object)handler)).slots.get(i));
        }
        return craftingSlots;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree();
    }

    public EmiPlayerInventory getInventory(AbstractContainerScreen<T> screen) {
        List stacks = this.getInputSources((T)((Object)((DimensionsCraftMenu)screen.getMenu()))).stream().map(Slot::getItem).map(EmiStack::of).collect(Collectors.toCollection(ArrayList::new));
        if (((DimensionsCraftMenu)screen.getMenu()).storage.getStorage() != null) {
            for (KeyAmount stack : ((DimensionsCraftMenu)screen.getMenu()).storage.getStorage()) {
                IStackKey<?> iStackKey;
                if (stack.isEmpty() || !((iStackKey = stack.key()) instanceof ItemStackKey)) continue;
                ItemStackKey itemStackKey = (ItemStackKey)iStackKey;
                stacks.add(EmiStack.of((ItemStack)itemStackKey.getReadOnlyStack(), (long)stack.amount()));
            }
        }
        return new EmiPlayerInventory(stacks);
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        Minecraft.getInstance().setScreen((Screen)context.getScreen());
        List inputs = recipe.getInputs();
        DimensionsCraftMenu menu = (DimensionsCraftMenu)context.getScreen().getMenu();
        HashMap pool = new HashMap();
        BiConsumer<ItemStackKey, Long> add = (key, amt) -> {
            if (amt == null || amt <= 0L) {
                return;
            }
            pool.computeIfAbsent(key.getSource(), i -> new ArrayList()).add(new Avail((ItemStackKey)key, (long)amt));
        };
        for (Slot slot : this.getInputSources((T)((Object)menu))) {
            if (!slot.hasItem()) continue;
            ItemStack s = slot.getItem();
            add.accept(new ItemStackKey(s), Long.valueOf(s.getCount()));
        }
        for (KeyAmount ka : menu.storage.getStorage()) {
            IStackKey<?> iStackKey;
            if (ka == null || ka.isEmpty() || !((iStackKey = ka.key()) instanceof ItemStackKey)) continue;
            ItemStackKey isk = (ItemStackKey)iStackKey;
            add.accept(isk, ka.amount());
        }
        for (ItemStack s : menu.player.getInventory().items) {
            if (s.isEmpty()) continue;
            add.accept(new ItemStackKey(s), Long.valueOf(s.getCount()));
        }
        ArrayList outKeys = new ArrayList(inputs.size());
        ArrayList<Long> outAmts = new ArrayList<Long>(inputs.size());
        for (EmiIngredient ing : inputs) {
            if (ing.isEmpty()) {
                outKeys.add(EmptyStackKey.INSTANCE);
                outAmts.add(0L);
                continue;
            }
            int required = (int)ing.getAmount();
            boolean satisfied = false;
            for (EmiStack alt : ing.getEmiStacks()) {
                Item candidateItem = alt.getItemStack().getItem();
                List list = (List)pool.get(candidateItem);
                if (list == null || list.isEmpty()) continue;
                long available = 0L;
                for (Object a : list) {
                    available += Math.max(0L, ((Avail)a).remain);
                }
                if (available < (long)required) continue;
                ItemStackKey repKey = null;
                for (Avail a : list) {
                    if (a.remain <= 0L) continue;
                    repKey = a.key;
                    break;
                }
                if (repKey == null) continue;
                int left = required;
                for (Avail a : list) {
                    if (left <= 0) break;
                    long take = Math.min(a.remain, (long)left);
                    if (take <= 0L) continue;
                    a.remain -= take;
                    left -= (int)take;
                }
                outKeys.add(repKey);
                outAmts.add(Long.valueOf(required));
                satisfied = true;
                break;
            }
            if (satisfied) continue;
            Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"beyonddimensions.message.insufficient_materials"), true);
            return true;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new RecipeFillC2SPacket(outKeys, outAmts), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    private static final class Avail {
        final ItemStackKey key;
        long remain;

        Avail(ItemStackKey key, long remain) {
            this.key = key;
            this.remain = remain;
        }
    }
}

