/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.JEI.RecipeTransfer;

import com.wintercogs.beyonddimensions.Api.DataBase.Stack.EmptyStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.ItemStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Integration.JEI.RecipeTransfer.MissStackError;
import com.wintercogs.beyonddimensions.Packet.RecipeFillC2SPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class TransferHelper {
    @Nullable
    public static IRecipeTransferError transferRecipe(List<Slot> inputSource, List<KeyAmount> storage, List<ItemStack> playerInv, IRecipeSlotsView recipeSlots, boolean doTransfer) {
        HashMap pool = new HashMap();
        BiConsumer<ItemStackKey, Long> add = (key, amt) -> {
            if (amt == null || amt <= 0L) {
                return;
            }
            pool.computeIfAbsent(key.getSource(), i -> new ArrayList()).add(new Avail((ItemStackKey)key, (long)amt));
        };
        for (Slot slot : inputSource) {
            if (!slot.hasItem()) continue;
            ItemStack s2 = slot.getItem();
            add.accept(new ItemStackKey(s2), Long.valueOf(s2.getCount()));
        }
        for (KeyAmount ka : storage) {
            Object object;
            if (ka == null || ka.isEmpty() || !((object = ka.key()) instanceof ItemStackKey)) continue;
            ItemStackKey isk = (ItemStackKey)object;
            add.accept(isk, ka.amount());
        }
        for (ItemStack s3 : playerInv) {
            if (s3.isEmpty()) continue;
            add.accept(new ItemStackKey(s3), Long.valueOf(s3.getCount()));
        }
        ArrayList<IRecipeSlotView> missingSlots = new ArrayList<IRecipeSlotView>();
        ArrayList outKeys = new ArrayList();
        ArrayList<Long> outAmts = new ArrayList<Long>();
        for (IRecipeSlotView slotView : recipeSlots.getSlotViews(RecipeIngredientRole.INPUT)) {
            if (slotView.getRole() != RecipeIngredientRole.INPUT) continue;
            List<ItemStack> candidates = slotView.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).filter(s -> s != null && !s.isEmpty()).collect(Collectors.toList());
            if (candidates.isEmpty()) {
                outKeys.add(EmptyStackKey.INSTANCE);
                outAmts.add(0L);
                continue;
            }
            int required = TransferHelper.requiredCountFor(candidates);
            boolean satisfied = false;
            for (ItemStack alt : candidates) {
                Item item = alt.getItem();
                List list = (List)pool.get(item);
                if (list == null || list.isEmpty()) continue;
                long available = 0L;
                for (Object a : list) {
                    available += Math.max(0L, ((Avail)a).remain);
                }
                if (available < (long)required) continue;
                ItemStackKey repKey = null;
                for (Avail a : list) {
                    if (a.remain <= 0L) continue;
                    repKey = a.key;
                    break;
                }
                if (repKey == null) continue;
                int left = required;
                for (Avail a : list) {
                    if (left <= 0) break;
                    long take = Math.min(a.remain, (long)left);
                    if (take <= 0L) continue;
                    a.remain -= take;
                    left -= (int)take;
                }
                outKeys.add(repKey);
                outAmts.add(Long.valueOf(required));
                satisfied = true;
                break;
            }
            if (satisfied) continue;
            outKeys.add(EmptyStackKey.INSTANCE);
            outAmts.add(0L);
            missingSlots.add(slotView);
        }
        if (doTransfer) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RecipeFillC2SPacket(outKeys, outAmts), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (!missingSlots.isEmpty()) {
            return new MissStackError(missingSlots);
        }
        return null;
    }

    private static int requiredCountFor(List<ItemStack> candidates) {
        int max = 0;
        for (ItemStack s : candidates) {
            if (s == null) continue;
            max = Math.max(max, s.getCount());
        }
        return Math.max(1, max);
    }

    private static final class Avail {
        final ItemStackKey key;
        long remain;

        Avail(ItemStackKey key, long remain) {
            this.key = key;
            this.remain = remain;
        }
    }
}

