/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.beyonddimensions.Integration.RS.ExternalStorage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageProvider;
import com.wintercogs.beyonddimensions.Api.DataBase.DimensionsNet;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.IStackKey;
import com.wintercogs.beyonddimensions.Api.DataBase.Stack.KeyAmount;
import com.wintercogs.beyonddimensions.Api.DataBase.Storage.UnifiedStorage;
import com.wintercogs.beyonddimensions.Integration.RS.Block.RSNetPathwayBlockEntity;
import com.wintercogs.beyonddimensions.Integration.RS.RSHelper;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BD_RSExternalStorageProvider
implements ExternalStorageProvider {
    private final ServerLevel level;
    private final BlockPos pos;
    private final Object2LongOpenHashMap<ResourceKey> counts = new Object2LongOpenHashMap();
    private final Object2IntOpenHashMap<ResourceKey> index = new Object2IntOpenHashMap();
    private final ArrayList<ResourceAmount> all = new ArrayList();
    @Nullable
    private UnifiedStorage subscribedUnified = null;
    @Nullable
    private AutoCloseable unifiedDeltaSub = null;
    @Nullable
    private AutoCloseable unifiedAnySub = null;
    private static final int FULL_REBUILD_INTERVAL_TICKS = 0;
    private long lastFullBuildGt = Long.MIN_VALUE;

    public BD_RSExternalStorageProvider(ServerLevel level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
        this.index.defaultReturnValue(-1);
        this.counts.defaultReturnValue(0L);
        this.fullRebuildSnapshot();
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof RSNetPathwayBlockEntity) {
            RSNetPathwayBlockEntity rsBe = (RSNetPathwayBlockEntity)be;
            rsBe.addNetChangeTask(() -> level.getServer().execute(this::refreshBindingIfNeeded));
        }
        this.refreshBindingIfNeeded();
    }

    public Iterator<ResourceAmount> iterator() {
        this.refreshBindingIfNeeded();
        this.maybePeriodicFullRebuild();
        return this.all.iterator();
    }

    public long extract(ResourceKey resourceKey, long amount, Action action, Actor actor) {
        UnifiedStorage us = this.currentUnified();
        if (us == null || amount <= 0L) {
            return 0L;
        }
        return RSHelper.fromRSKeyToIStack(resourceKey).map(s -> us.extract((IStackKey<?>)s, amount, action == Action.SIMULATE).amount()).orElse(0L);
    }

    public long insert(ResourceKey resourceKey, long amount, Action action, Actor actor) {
        UnifiedStorage us = this.currentUnified();
        if (us == null || amount <= 0L) {
            return 0L;
        }
        return RSHelper.fromRSKeyToIStack(resourceKey).map(s -> amount - us.insert((IStackKey<?>)s, amount, action == Action.SIMULATE).amount()).orElse(0L);
    }

    private void refreshBindingIfNeeded() {
        UnifiedStorage current = this.currentUnified();
        if (current == this.subscribedUnified) {
            return;
        }
        this.cancelUnifiedSub();
        this.subscribedUnified = current;
        if (current == null) {
            this.clearSnapshot();
            return;
        }
        this.unifiedDeltaSub = current.subscribeDeltaWeak(this, (prov, type, size, insert) -> RSHelper.fromIStackToRSKey(type).ifPresent(key -> prov.applyDelta((ResourceKey)key, insert != false ? size : -size.longValue())));
        this.unifiedAnySub = current.subscribeAnyWeak(this, prov -> prov.level.getServer().execute(prov::fullRebuildSnapshot));
        this.fullRebuildSnapshot();
    }

    private void cancelUnifiedSub() {
        if (this.unifiedDeltaSub != null) {
            try {
                this.unifiedDeltaSub.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unifiedDeltaSub = null;
        }
        if (this.unifiedAnySub != null) {
            try {
                this.unifiedAnySub.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unifiedAnySub = null;
        }
    }

    private void applyDelta(ResourceKey key, long diff) {
        if (diff == 0L) {
            return;
        }
        long old = this.counts.getLong((Object)key);
        long now = old + diff;
        if (now > 0L) {
            this.counts.put((Object)key, now);
            int i = this.index.getInt((Object)key);
            if (i >= 0) {
                this.all.set(i, new ResourceAmount(key, now));
            } else {
                this.index.put((Object)key, this.all.size());
                this.all.add(new ResourceAmount(key, now));
            }
        } else {
            this.counts.removeLong((Object)key);
            int i = this.index.getInt((Object)key);
            if (i >= 0) {
                int last = this.all.size() - 1;
                if (i != last) {
                    ResourceAmount tail = this.all.get(last);
                    this.all.set(i, tail);
                    this.index.put((Object)tail.resource(), i);
                }
                this.all.remove(last);
                this.index.removeInt((Object)key);
            }
        }
    }

    private void clearSnapshot() {
        this.counts.clear();
        this.index.clear();
        this.all.clear();
        this.lastFullBuildGt = this.level.getGameTime();
    }

    private void fullRebuildSnapshot() {
        this.counts.clear();
        this.index.clear();
        this.all.clear();
        UnifiedStorage us = this.currentUnified();
        if (us != null) {
            for (KeyAmount s : us.getStorage()) {
                if (s.isEmpty()) continue;
                RSHelper.fromIStackToRSKey(s.key()).ifPresent(k -> {
                    long prev = this.counts.getLong(k);
                    long now = prev + s.amount();
                    if (prev == 0L) {
                        this.counts.put(k, now);
                        this.index.put(k, this.all.size());
                        this.all.add(new ResourceAmount(k, now));
                    } else {
                        this.counts.put(k, now);
                        int i = this.index.getInt(k);
                        if (i >= 0) {
                            this.all.set(i, new ResourceAmount(k, now));
                        } else {
                            this.index.put(k, this.all.size());
                            this.all.add(new ResourceAmount(k, now));
                        }
                    }
                });
            }
        }
        this.lastFullBuildGt = this.level.getGameTime();
    }

    private void maybePeriodicFullRebuild() {
    }

    @Nullable
    private UnifiedStorage currentUnified() {
        RSNetPathwayBlockEntity rsBe;
        DimensionsNet net;
        BlockEntity be = this.level.getBlockEntity(this.pos);
        if (be instanceof RSNetPathwayBlockEntity && (net = (rsBe = (RSNetPathwayBlockEntity)be).getNet()) != null) {
            return net.getUnifiedStorage();
        }
        return null;
    }
}

